/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealTableScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public boolean coarserLock;
    public int fetchSize;
    public String isolationLevel;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    public String lockString;
    public String qualifiers;
    public String startPosition;
    public String stopPosition;
    public FormatableProperties scanProperties;

    public RealTableScanStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, String qualifiers, Properties scanProperties, String startPosition, String stopPosition, String isolationLevel, String lockString, int fetchSize, boolean coarserLock, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.qualifiers = qualifiers;
        this.scanProperties = new FormatableProperties();
        Enumeration<Object> e = scanProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.scanProperties.put(key, scanProperties.get(key));
        }
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.isolationLevel = isolationLevel;
        this.lockString = lockString;
        this.fetchSize = fetchSize;
        this.coarserLock = coarserLock;
    }

    public String getStatementExecutionPlanText(int depth) {
        String header = "";
        Object isolationString = null;
        this.initFormatInfo(depth);
        if (this.userSuppliedOptimizerOverrides != null) {
            header = this.indent + MessageService.getTextMessage("43Y56.U", this.tableName, this.userSuppliedOptimizerOverrides);
            header = header + "\n";
        }
        header = this.indexName != null ? header + this.indent + MessageService.getTextMessage("43Y09.U", this.tableName, MessageService.getTextMessage(this.isConstraint ? "43X24.U" : "43X25.U"), this.indexName) : header + this.indent + MessageService.getTextMessage("43Y10.U", this.tableName);
        header = header + " " + MessageService.getTextMessage("43X72.U", this.isolationLevel, this.lockString);
        if (this.coarserLock) {
            header = header + " (" + MessageService.getTextMessage("43Y11.U") + ")";
        }
        header = header + "\n";
        String scanInfo = this.indent + MessageService.getTextMessage("43X28.U") + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        return header + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43Y12.U") + " = " + this.fetchSize + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + scanInfo + this.subIndent + MessageService.getTextMessage("43X34.U") + ": \n" + this.startPosition + this.subIndent + MessageService.getTextMessage("43X35.U") + ": \n" + this.stopPosition + this.subIndent + MessageService.getTextMessage("43Y13.U") + ":\n" + this.qualifiers + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeName() {
        return MessageService.getTextMessage(this.indexName == null ? "43X73.U" : "43X74.U");
    }

    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage("43X75.U", this.tableName);
        }
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }
}

