/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.AccessControlException;
import java.security.Permission;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.jmx.ManagementService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.JDBC;
import org.apache.derby.mbeans.JDBCMBean;
import org.apache.derby.security.SystemPermission;

public abstract class InternalDriver
implements ModuleControl {
    private static final Object syncMe = new Object();
    private static InternalDriver activeDriver;
    private Object mbean;
    protected boolean active;
    private ContextService contextServiceFactory = ContextService.getFactory();
    private AuthenticationService authenticationService;

    public static final InternalDriver activeDriver() {
        return activeDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(boolean create, Properties properties) throws StandardException {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = this;
        }
        this.active = true;
        this.mbean = ((ManagementService)Monitor.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).registerMBean(new JDBC(this), JDBCMBean.class, "type=JDBC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = syncMe;
        synchronized (object) {
            activeDriver = null;
        }
        ((ManagementService)Monitor.getSystemModule("org.apache.derby.iapi.services.jmx.ManagementService")).unregisterMBean(this.mbean);
        this.active = false;
        this.contextServiceFactory = null;
    }

    public boolean acceptsURL(String url) {
        return this.active && InternalDriver.embeddedDriverAcceptsURL(url);
    }

    public static boolean embeddedDriverAcceptsURL(String url) {
        return !url.startsWith("jdbc:derby:net:") && !url.startsWith("jdbc:derby://") && (url.startsWith("jdbc:derby:") || url.equals("jdbc:default:connection"));
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (EmbedConnection.memoryState.isLowMemory()) {
            throw EmbedConnection.NO_MEM;
        }
        boolean current = url.equals("jdbc:default:connection");
        if (current) {
            ConnectionContext connContext = this.getConnectionContext();
            if (connContext != null) {
                return connContext.getNestedConnection(false);
            }
            return null;
        }
        FormatableProperties finfo = null;
        try {
            finfo = this.getAttributes(url, info);
            info = null;
            boolean shutdown = Boolean.valueOf(finfo.getProperty("shutdown"));
            if (shutdown && InternalDriver.getDatabaseName(url, finfo).length() == 0) {
                if (this.getAuthenticationService() == null) {
                    throw Util.generateCsSQLException("08004", MessageService.getTextMessage("A001"));
                }
                if (!this.getAuthenticationService().authenticate(null, finfo)) {
                    throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020"));
                }
                Monitor.getMonitor().shutdown();
                throw Util.generateCsSQLException("XJ015.M");
            }
            EmbedConnection conn = this.getNewEmbedConnection(url, finfo);
            if (conn.isClosed()) {
                Connection connection = null;
                return connection;
            }
            EmbedConnection embedConnection = conn;
            return embedConnection;
        }
        catch (OutOfMemoryError noMemory) {
            EmbedConnection.memoryState.setLowMemory();
            throw EmbedConnection.NO_MEM;
        }
        finally {
            if (finfo != null) {
                finfo.clearDefaults();
            }
        }
    }

    public abstract void checkSystemPrivileges(String var1, Permission var2) throws Exception;

    private void checkShutdownPrivileges(String user) throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            SystemPermission sp = new SystemPermission("engine", "shutdown");
            this.checkSystemPrivileges(user, sp);
        }
        catch (AccessControlException ace) {
            throw Util.generateCsSQLException("08004.C.9", (Object)user, (Object)ace);
        }
        catch (Exception e) {
            throw Util.generateCsSQLException("08004.C.9", (Object)user, (Object)e);
        }
    }

    public int getMajorVersion() {
        return Monitor.getMonitor().getEngineVersion().getMajorVersion();
    }

    public int getMinorVersion() {
        return Monitor.getMonitor().getEngineVersion().getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return true;
    }

    protected FormatableProperties getAttributes(String url, Properties info) throws SQLException {
        FormatableProperties finfo = new FormatableProperties(info);
        info = null;
        StringTokenizer st = new StringTokenizer(url, ";");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            int eqPos = v.indexOf(61);
            if (eqPos == -1) {
                throw Util.generateCsSQLException("XJ028.C", url);
            }
            finfo.put(v.substring(0, eqPos).trim(), v.substring(eqPos + 1).trim());
        }
        InternalDriver.checkBoolean(finfo, "dataEncryption");
        InternalDriver.checkBoolean(finfo, "create");
        InternalDriver.checkBoolean(finfo, "shutdown");
        InternalDriver.checkBoolean(finfo, "upgrade");
        return finfo;
    }

    private static void checkBoolean(Properties set, String attribute) throws SQLException {
        String[] booleanChoices = new String[]{"true", "false"};
        InternalDriver.checkEnumeration(set, attribute, booleanChoices);
    }

    private static void checkEnumeration(Properties set, String attribute, String[] choices) throws SQLException {
        String value = set.getProperty(attribute);
        if (value == null) {
            return;
        }
        for (int i = 0; i < choices.length; ++i) {
            if (!value.toUpperCase(Locale.ENGLISH).equals(choices[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String choicesStr = "{";
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                choicesStr = choicesStr + "|";
            }
            choicesStr = choicesStr + choices[i];
        }
        throw Util.generateCsSQLException("XJ05B.C", attribute, value, choicesStr + "}");
    }

    public static String getDatabaseName(String url, Properties info) {
        if (url.equals("jdbc:default:connection")) {
            return "";
        }
        int attributeStart = url.indexOf(59);
        String dbname = attributeStart == -1 ? url.substring("jdbc:derby:".length()) : url.substring("jdbc:derby:".length(), attributeStart);
        if (dbname.length() == 0 && info != null) {
            dbname = info.getProperty("databaseName", dbname);
        }
        dbname = dbname.trim();
        return dbname;
    }

    public final ContextService getContextServiceFactory() {
        return this.contextServiceFactory;
    }

    public AuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = (AuthenticationService)Monitor.findService("org.apache.derby.iapi.jdbc.AuthenticationService", "authentication");
        }
        SanityManager.ASSERT(this.authenticationService != null, "Unexpected - There is no valid authentication service!");
        return this.authenticationService;
    }

    protected abstract EmbedConnection getNewEmbedConnection(String var1, Properties var2) throws SQLException;

    private ConnectionContext getConnectionContext() {
        ContextManager cm = this.getCurrentContextManager();
        ConnectionContext localCC = null;
        if (cm != null) {
            localCC = (ConnectionContext)((Object)cm.getContext("JDBC_ConnectionContext"));
        }
        return localCC;
    }

    private ContextManager getCurrentContextManager() {
        return this.getContextServiceFactory().getCurrentContextManager();
    }

    public boolean isActive() {
        return this.active;
    }

    public abstract Connection getNewNestedConnection(EmbedConnection var1);

    public Statement newEmbedStatement(EmbedConnection conn, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new EmbedStatement(conn, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public abstract PreparedStatement newEmbedPreparedStatement(EmbedConnection var1, String var2, boolean var3, int var4, int var5, int var6, int var7, int[] var8, String[] var9) throws SQLException;

    public abstract CallableStatement newEmbedCallableStatement(EmbedConnection var1, String var2, int var3, int var4, int var5) throws SQLException;

    public DatabaseMetaData newEmbedDatabaseMetaData(EmbedConnection conn, String dbname) throws SQLException {
        return new EmbedDatabaseMetaData(conn, dbname);
    }

    public abstract EmbedResultSet newEmbedResultSet(EmbedConnection var1, ResultSet var2, boolean var3, EmbedStatement var4, boolean var5) throws SQLException;

    public EmbedResultSetMetaData newEmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo) {
        return new EmbedResultSetMetaData(columnInfo);
    }
}

