/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class RegistrationInputStreamHandler
extends DefaultHandler
implements ITransformerHandler,
LexicalHandler {
    private IRegisterRequest request;
    private IGraphElement currentRegisterEntity;
    private String currentElementData;
    private IInstanceId currentInstanceId;
    private IRecord currentRecord;
    private IRecordMetadata currentRecordMetadata;
    private IRegisterInputArtifactFactory artifactFactory;
    private boolean inCDATA = false;

    public RegistrationInputStreamHandler(IRegisterInputArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            if (this.currentRecord == null) {
                return;
            }
            StringWriter tempWriter = new StringWriter();
            CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            tempWriter.write(CMDBfServicesUtil.beginTagFor((String)name, (Attributes)attributes));
            tempWriter.write(ICMDBfServicesConstants.nl);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
            if (!name.equals(localName)) {
                String prefix = name.split(":")[0];
                this.currentRecord.addNamespace(prefix, uri);
            }
            return;
        }
        if ("registerRequest".equals(localName)) {
            this.request = this.getArtifactFactory().createRegisterRequest();
        } else if ("item".equals(localName)) {
            this.currentRegisterEntity = this.getArtifactFactory().createItem();
            this.request.addItem((IItem)this.currentRegisterEntity);
        } else if ("relationship".equals(localName)) {
            this.currentRegisterEntity = this.getArtifactFactory().createRelationship();
            this.request.addRelationship((IRelationship)this.currentRegisterEntity);
        } else if ("source".equals(localName)) {
            this.currentInstanceId = this.getArtifactFactory().createInstanceId();
        } else if ("target".equals(localName)) {
            this.currentInstanceId = this.getArtifactFactory().createInstanceId();
        } else if ("record".equals(localName)) {
            this.currentRecord = this.getArtifactFactory().createRecord(this.currentRegisterEntity, null);
            this.currentRegisterEntity.addRecord(this.currentRecord);
            this.currentElementData = "";
            CMDBfInternalUtility.addNamespaces((IRecord)this.currentRecord, (Attributes)attributes);
        } else if (this.currentRecord != null && "recordMetadata".equals(localName)) {
            this.currentRecordMetadata = this.getArtifactFactory().createRecordMetadata();
            this.currentRecord.setRecordMetadata(this.currentRecordMetadata);
            this.currentRecord.setValueFromString(String.valueOf(this.currentElementData) + "\n");
            this.currentElementData = "";
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceId = this.getArtifactFactory().createInstanceId();
        } else if ("additionalRecordType".equals(localName)) {
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            IAdditionalRecordType adt = this.getArtifactFactory().createAdditionalRecordType(namespace, locName);
            this.currentRegisterEntity.addAdditionalRecordType(adt);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://cmdbf.org/schema/1-0-0/datamodel".equals(uri)) {
            if (this.currentRecord != null) {
                StringWriter tempWriter = new StringWriter();
                CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
                tempWriter.write(CMDBfServicesUtil.endTagFor((String)name));
                tempWriter.write(ICMDBfServicesConstants.nl);
                this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
            }
            return;
        }
        if ("mdrId".equals(localName)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setMdrId(this.currentElementData.trim());
            } else {
                this.request.setMdrId(CMDBfServicesUtil.createURI((String)this.currentElementData));
            }
            this.currentElementData = null;
        } else if ("localId".equals(localName)) {
            this.currentInstanceId.setLocalId(this.currentElementData);
            this.currentElementData = null;
        } else if ("instanceId".equals(localName)) {
            this.currentRegisterEntity.addInstanceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("source".equals(localName)) {
            ((IRelationship)this.currentRegisterEntity).setSourceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("target".equals(localName)) {
            ((IRelationship)this.currentRegisterEntity).setTargetId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("record".equals(localName)) {
            this.currentRecord = null;
        } else if ("recordMetadata".equals(localName)) {
            if (this.currentElementData != null && !"".equals(this.currentElementData.trim())) {
                this.currentRecordMetadata.setExtensibilityElementsFromString(this.currentElementData);
            }
            this.currentRecordMetadata = null;
            this.currentElementData = "";
        } else if (this.currentRecordMetadata != null && "recordId".equals(localName)) {
            this.currentRecordMetadata.setRecordId(this.currentElementData == null ? null : CMDBfServicesUtil.createURI((String)this.currentElementData.trim()));
            this.currentElementData = "";
        } else if (this.currentRecordMetadata != null && "lastModified".equals(localName)) {
            this.currentRecordMetadata.setLastModified(this.currentElementData);
            this.currentElementData = null;
        } else if (this.currentRecordMetadata != null && "baselineId".equals(localName)) {
            this.currentRecordMetadata.setBaselineId(this.currentElementData);
            this.currentElementData = null;
        } else if (this.currentRecordMetadata != null && "snapshotId".equals(localName)) {
            this.currentRecordMetadata.setSnapshotId(this.currentElementData);
            this.currentElementData = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        StringWriter tempWriter = new StringWriter();
        if (this.currentElementData == null) {
            this.currentElementData = "";
            RegistrationInputStreamHandler.addXMLEscapeCharacters(tempWriter, this.inCDATA, tempData);
        } else {
            if (this.currentRecord != null && new String(ch, start, length).startsWith("\n")) {
                tempWriter.write(ICMDBfServicesConstants.nl);
                CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            }
            RegistrationInputStreamHandler.addXMLEscapeCharacters(tempWriter, this.inCDATA, tempData);
            if (this.currentRecord != null && new String(ch, start, length).endsWith("\n")) {
                tempWriter.write(ICMDBfServicesConstants.nl);
            }
        }
        this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
    }

    public static void addXMLEscapeCharacters(StringWriter writer, boolean inCDATA, String input) {
        if (!inCDATA) {
            String[] escapeChars = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;"};
            int i = 0;
            while (i < escapeChars.length) {
                input = input.replace(escapeChars[i], escapeChars[i + 1]);
                i += 2;
            }
        }
        writer.append(input);
    }

    public IRegisterRequest getRequest() {
        return this.request;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getRequest();
    }

    protected IRegisterInputArtifactFactory getArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = RegisterInputArtifactFactory.getInstance();
        }
        return this.artifactFactory;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
        this.appendToElementData("]]>");
    }

    private void appendToElementData(String string) {
        this.currentElementData = this.currentElementData == null ? string : String.valueOf(this.currentElementData) + string;
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
        this.appendToElementData("<![CDATA[");
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }
}

