/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * An element declaration builder is used to construct a data structure that
 * stores all global element declarations.
 * 
 * @author Ali Mehregani
 */
public class ElementDeclarationBuilder extends AbstractDeclarationBuilder<ElementDeclarationCollection>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".ElementDeclarationBuilder";

	
	/**
	 * The data structure used to keep track of all element declarations
	 */
	private ElementDeclarationCollection datastructure;
	
	
	public ElementDeclarationBuilder()
	{
		
		datastructure = new ElementDeclarationCollection();
	}
	
	@Override
	public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException
	{
		String lastElement = getLastElement();
		super.startElement(uri, localName, name, attributes);
		
		if (!ISMLConstants.SCHEMA_URI.equals(uri))
		{
			return;
		}
		
		if (ISMLConstants.ELEMENT_ELEMENT.equals(localName) && ISMLConstants.SCHEMA_ELEMENT.equals(lastElement))
		{
			datastructure.add(createElementDeclaration(attributes));			
		}
		
	}

	
	public ElementDeclarationCollection getDataStructure()
	{		
		return datastructure;
	}
}
