/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.internal.smlif.export.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.cosmos.rm.internal.smlif.SMLImages;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

/**
 * Label provider for displaying resources that can be selected for export
 * 
 * @author David Whiteman
 */
public class ExportResourceTreeLabelProvider extends LabelProvider {
	public String getText(Object element) {
		return ((IResource) element).getName();
	}

	public Image getImage(Object element) {
		if (element instanceof IProject) {
			return SMLImages.INSTANCE.getImage(SMLImages.PROJECT);
		} else if (element instanceof IContainer) {
			return SMLImages.INSTANCE.getImage(SMLImages.FOLDER);
		} else 
		{
			try
			{
				return (SMLValidatorUtil.identifyDocumentType((IFile) element) == ISMLConstants.TYPE_DEFINITION) ?
						SMLImages.INSTANCE.getImage(SMLImages.DEFINITIONS) :
						SMLImages.INSTANCE.getImage(SMLImages.INSTANCES);
			} 
			catch (Exception e)
			{
				SMLCommonUtil.openErrorWithDetail(SMLValidationMessages.errorContentTypeTitle, 
						NLS.bind(SMLValidationMessages.errorContentType, ((IFile) element).getFullPath()), e);
				return null;
			} 
		}
	}
}
