/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.LanguageType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageCompare {
    protected static Collection<? extends LanguageType> merge(List<LanguageType> l, List<LanguageType> l2) {
        Vector<LanguageType> toRemove = new Vector<LanguageType>();
        for (LanguageType o1 : l) {
            for (LanguageType o2 : l2) {
                if (toRemove.contains(o2) || !LanguageCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = LanguageCompare.merge(o1, o2);
            }
        }
        l2.removeAll(toRemove);
        Vector<LanguageType> finals = new Vector<LanguageType>();
        finals.addAll(l);
        finals.addAll(l2);
        return finals;
    }

    protected static LanguageType merge(LanguageType o1, LanguageType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        LanguageType merged = objectFactory.createLanguageType();
        merged.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        merged.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
        merged.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        merged.setType(o1.getType());
        return merged;
    }

    protected static boolean equals(LanguageType l, LanguageType l2) {
        return StringCompare.equals(l.getType(), l2.getType());
    }
}

