package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;

public class URIParameterCompare
{
	protected static Vector<URIParameterType> merge(List<URIParameterType> params, List<URIParameterType> params2)
	{
		Vector <URIParameterType> toRemove = new Vector <URIParameterType> ();
		Iterator <URIParameterType> iter1 = params.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			URIParameterType o1 = (URIParameterType) iter1.next();
			Iterator <URIParameterType> iter2 = params2.iterator();
			while (iter2.hasNext())
			{
				URIParameterType o2 = (URIParameterType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						//merge hosted resources, types and description groups
						toRemove.add(o2);
						o1 = merge(o1,o2);
					}
				}
					
			}
		}
		
		params2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <URIParameterType> finals = new Vector <URIParameterType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(params);
		finals.addAll(params2);		
		
		return finals;
	}

	private static boolean equals(URIParameterType o1, URIParameterType o2)
	{
		if (!StringCompare.equals(o1.getDefaultValue(),o2.getDefaultValue()))
			return false;
		if (o1.isSensitive()!=o2.isSensitive())
			return false;
		if (o1.isRequired()!=o2.isRequired())
			return false;
		if (OperationCompare.equals(o1.getOperation(),o2.getOperation()))
			return false;
		return true;
	}
	protected static URIParameterType merge(URIParameterType string1, URIParameterType string2)
	{
		ObjectFactory objectFactory = new ObjectFactory();
		URIParameterType merged = objectFactory.createURIParameterType();
		
		merged.setDisplayName(DisplayTextCompare.merge(string1.getDisplayName(), string2.getDisplayName()));
		merged.setDescription(DisplayTextCompare.merge(string1.getDescription(), string2.getDescription()));
		
		return merged;
		
	}	

}
