/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class CmdGraphQuery
extends CommandEntry {
    private String _id = null;
    private String _queryFilename = null;
    private String _queryResultFilename = null;

    CmdGraphQuery(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("GraphQuery");
        this._usage_entry = new String("USAGE_GRAPHQUERY_INFO");
    }

    public void performAction() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        DataManager dm = brokerclient.getDataManagerById(this._id);
        if (dm != null) {
            QueryServiceClient queryServiceClient = dm.getCMDBfQueryClient();
            if (queryServiceClient == null) {
                this._cli.logMessage(MessageFormat.format(Messages.getString("NO_QUERYSERVICE_CLIENT_ERR"), this._id));
            } else {
                if (this._cli.getUsername() != null) {
                    queryServiceClient.setUsername(this._cli.getUsername());
                }
                if (this._cli.getPassword() != null) {
                    queryServiceClient.setPassword(this._cli.getPassword());
                }
                queryServiceClient.setSoapVersion(this._cli.getSoapversion());
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(this._queryFilename));
                Element response = queryServiceClient.graphQuery(doc.getDocumentElement());
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                StringWriter sw = new StringWriter();
                trans.transform(new DOMSource(response), new StreamResult(sw));
                this._cli.logMessage(Messages.getString("GRAPHQUERY_INFO"));
                this._cli.logMessage(sw.toString());
                if (this._queryResultFilename != null) {
                    File qFile = new File(this._queryResultFilename);
                    BufferedWriter output = new BufferedWriter(new FileWriter(qFile));
                    output.write(sw.toString());
                    ((Writer)output).close();
                    this._cli.logMessage(MessageFormat.format(Messages.getString("GRAPHQUERY_WRITTEN_INFO"), qFile.getCanonicalPath()));
                }
            }
        } else {
            this._cli.logMessage(MessageFormat.format(Messages.getString("NOT_REGISTERED_ERR"), this._id));
        }
    }

    public boolean validateArguments(Tokenizer st, String line) {
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_DM_ID_ERR"));
            return false;
        }
        this._id = st.nextToken();
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_FILE_ERR"));
            return false;
        }
        this._queryFilename = this.getToken(this._id, line);
        this._queryResultFilename = this.getToken(this._queryFilename, line);
        return true;
    }

    private String getToken(String lastToken, String line) {
        int index = line.indexOf(lastToken);
        if (line.substring(index - 1, index).startsWith("\"")) {
            index += 2;
        }
        if ((index += lastToken.length()) >= line.length()) {
            return null;
        }
        String result = line.substring(index).trim();
        if (result.startsWith("\"")) {
            int endIndex = result.substring(1).indexOf("\"");
            if (endIndex > 0) {
                result = result.substring(1, endIndex + 1);
            }
        } else {
            int endIndex = result.indexOf(" ");
            if (endIndex > 0) {
                result = result.substring(0, endIndex + 1);
            }
        }
        return result;
    }
}

