/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdRegisterAllDataManagers
extends CommandEntry {
    CmdRegisterAllDataManagers(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("RegisterAllDataManagers");
        this._usage_entry = new String("USAGE_REGALL_INFO");
    }

    public boolean validateArguments(Tokenizer st, String line) {
        String sfe = null;
        if (st.hasMoreTokens()) {
            sfe = st.nextToken();
            this._cli.setServiceFinder(sfe);
        }
        return true;
    }

    public void performAction() throws Exception {
        Iterator<?> iter = this._cli.doFindDataManagers();
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        while (iter.hasNext()) {
            DataManager dm = (DataManager)iter.next();
            Group group = dm.getGroup();
            if (brokerclient.registerGroup(group)) {
                this._cli.logMessage(MessageFormat.format(Messages.getString("REGISTERED_INFO"), dm.getName()));
                continue;
            }
            this._cli.logMessage(MessageFormat.format(Messages.getString("DUPLICATE_REGISTRATION_ERR"), dm.getName()));
        }
    }
}

