/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInternalUtility {
    private static final char CHAR_GREATER_THAN = '>';
    private static final char CHAR_LESS_THAN = '<';
    private static final String ENCODING_QUOTATION_MARK = "&quot;";
    private static final char CHAR_SEMICOLON = ';';
    private static final String ENCODING_APOSTROPHE = "&apos;";
    private static final String ENCODING_LESS_THAN = "&lt;";
    private static final String ENCODING_GREATER_THAN = "&gt;";
    private static final String ENCODING_AMPERSAND = "&amp;";
    private static final char CHAR_AMPERSAND = '&';
    private static final char CHAR_SINGLE_QUOTE = '\'';
    private static final char CHAR_DOUBLE_QUOTE = '\"';
    private static Document document;

    private static Document getDocument() {
        if (document == null) {
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return document;
    }

    public static Node createElement(String namespaceURI, String qualifiedName) {
        return XMLInternalUtility.createElement(namespaceURI, qualifiedName, null);
    }

    public static Node createElement(String namespaceURI, String qualifiedName, String[][] attributes) {
        Document doc = XMLInternalUtility.getDocument();
        if (doc == null) {
            return null;
        }
        Element node = doc.createElementNS(namespaceURI, qualifiedName);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                node.setAttribute(attributes[i][0], attributes[i][1]);
                ++i;
            }
        }
        return node;
    }

    public static Node appendNode(Node parent, Node child) {
        if (parent == null || child == null) {
            return null;
        }
        parent.appendChild(child);
        return parent;
    }

    public static Node createTextNode(String value) {
        Document doc = XMLInternalUtility.getDocument();
        if (doc == null) {
            return null;
        }
        return doc.createTextNode(value);
    }

    public static Document domParseDocument(InputStream resource) throws ParserConfigurationException, SAXException, IOException {
        return XMLInternalUtility.domParseDocument(resource, true, true);
    }

    public static Document domParseDocument(InputStream resource, boolean ignoreComments, boolean ignoreWhitespace) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setIgnoringElementContentWhitespace(ignoreWhitespace);
        docBuilderFactory.setIgnoringComments(ignoreComments);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(resource);
    }

    public static void serializeNode(StringBuffer buffer, Node node) {
        XMLInternalUtility.serializeNode(buffer, node, -1, false);
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent, boolean autoFormat) {
        XMLInternalUtility.serializeNode(buffer, node, indent, null, null, autoFormat);
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent, String currentIndex, Map<String, int[]> indices, boolean autoFormat) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: {
                if (!autoFormat) {
                    buffer.append(XMLInternalUtility.encodeSpecialCharacters(node.getNodeValue()));
                    break;
                }
                StringBuffer textValueBuffer = new StringBuffer();
                String textValue = node.getNodeValue();
                StringTokenizer st = new StringTokenizer(textValue, "\n");
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken().trim();
                    if (currentToken.length() <= 0) continue;
                    textValueBuffer.append("\n");
                    XMLInternalUtility.addIndent(textValueBuffer, indent);
                    textValueBuffer.append(currentToken);
                }
                buffer.append(textValueBuffer);
                break;
            }
            case 8: {
                if (node.getNodeValue() == null) {
                    return;
                }
                XMLInternalUtility.addIndent(buffer, indent);
                buffer.append("<!--" + node.getNodeValue() + "-->");
                buffer.append("\n");
                break;
            }
            case 1: {
                if (autoFormat) {
                    boolean needsLineSep = false;
                    int i = buffer.length() - 1;
                    while (i >= 0) {
                        char currentChar = buffer.charAt(i);
                        if (currentChar == '\n') break;
                        if (currentChar != '\t' && currentChar != ' ' && currentChar != '\r') {
                            needsLineSep = true;
                            break;
                        }
                        --i;
                    }
                    if (needsLineSep) {
                        buffer.append("\n");
                    }
                }
                NamedNodeMap attributes = node.getAttributes();
                Node[] children = XMLInternalUtility.retrieveChildNodes(node);
                boolean hasAttributes = attributes != null && attributes.getLength() > 0;
                boolean hasChildren = children != null && children.length > 0;
                int[] elementIndices = new int[2];
                elementIndices[0] = buffer.length();
                if (autoFormat) {
                    XMLInternalUtility.addElement(buffer, indent, node.getNodeName(), false, false);
                } else {
                    XMLInternalUtility.addIndent(buffer, indent);
                    buffer.append("<").append(node.getNodeName());
                }
                if (hasAttributes) {
                    if (autoFormat) {
                        XMLInternalUtility.addAttribute(buffer, attributes, !hasChildren, true);
                    } else {
                        int i = 0;
                        int attCount = attributes.getLength();
                        while (i < attCount) {
                            Node currentAttribute = attributes.item(i);
                            buffer.append(" " + currentAttribute.getNodeName() + "=" + "\"" + currentAttribute.getNodeValue() + "\"");
                            ++i;
                        }
                        buffer.append(hasChildren ? ">" : "/>");
                    }
                } else if (hasChildren) {
                    buffer.append(">");
                } else {
                    buffer.append("/").append(">");
                }
                if (!hasChildren) {
                    elementIndices[1] = buffer.length();
                    if (currentIndex != null) {
                        indices.put(currentIndex, elementIndices);
                    }
                    return;
                }
                int counter = -1;
                if (autoFormat) {
                    int i = 0;
                    while (i < children.length) {
                        Node child = children[i];
                        if (!XMLInternalUtility.isWhitespace(child)) {
                            buffer.append("\n");
                            if (child.getNodeType() == 1) {
                                ++counter;
                            }
                            XMLInternalUtility.serializeNode(buffer, child, indent + 1, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter, indices, autoFormat);
                        }
                        ++i;
                    }
                } else {
                    NodeList children1 = node.getChildNodes();
                    int i = 0;
                    int nodeCount = children1.getLength();
                    while (i < nodeCount) {
                        Node currentChild = children1.item(i);
                        if (currentChild.getNodeType() == 1) {
                            ++counter;
                        }
                        XMLInternalUtility.serializeNode(buffer, currentChild, 0, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter, indices, autoFormat);
                        ++i;
                    }
                }
                if (autoFormat) {
                    buffer.append("\n");
                    XMLInternalUtility.addElement(buffer, indent, node.getNodeName(), true, true);
                } else {
                    buffer.append("<").append("/").append(node.getNodeName()).append(">");
                }
                elementIndices[1] = buffer.length();
                if (currentIndex == null) break;
                indices.put(currentIndex, elementIndices);
                break;
            }
            case 9: {
                buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int i = 0;
                int childCount = children.getLength();
                while (i < childCount) {
                    XMLInternalUtility.serializeNode(buffer, children.item(i), indent, currentIndex, indices, autoFormat);
                    ++i;
                }
                break;
            }
        }
    }

    public static void addAttribute(StringBuffer stringBuffer, NamedNodeMap attributes, boolean close, boolean end) {
        int i = 0;
        int attCount = attributes.getLength();
        while (i < attCount) {
            Node currentAttribute = attributes.item(i);
            stringBuffer.append(" ");
            stringBuffer.append(currentAttribute.getNodeName());
            stringBuffer.append("=");
            stringBuffer.append("\"");
            stringBuffer.append(currentAttribute.getNodeValue());
            stringBuffer.append("\"");
            ++i;
        }
        stringBuffer.append(close ? "/" : "");
        stringBuffer.append(end ? ">" + (close ? "\n" : "") : "");
    }

    public static void addElement(StringBuffer stringBuffer, int indent, String elementName, boolean close, boolean end) {
        if (stringBuffer == null) {
            return;
        }
        if (indent > 0) {
            XMLInternalUtility.addIndent(stringBuffer, indent);
        }
        stringBuffer.append("<");
        stringBuffer.append(close ? "/" : "");
        stringBuffer.append(elementName);
        stringBuffer.append(end ? ">" + (close ? "\n" : "") : "");
    }

    public static void addIndent(StringBuffer stringBuffer, int indent) {
        int i = 0;
        while (i < indent) {
            stringBuffer.append("\t");
            ++i;
        }
    }

    public static void addIndent(StringWriter stringWriter, int indent) {
        int i = 0;
        while (i < indent) {
            stringWriter.append('\t');
            ++i;
        }
    }

    private static Node[] retrieveChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        ArrayList<Node> finalChildrenList = new ArrayList<Node>();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (!XMLInternalUtility.isWhitespace(child)) {
                finalChildrenList.add(child);
            }
            ++i;
        }
        return finalChildrenList.toArray(new Node[finalChildrenList.size()]);
    }

    public static boolean isWhitespace(Node node) {
        return node != null && node.getNodeType() == 3 && (node.getNodeValue() == null || node.getNodeValue().trim().length() <= 0);
    }

    public static String encodeSpecialCharacters(String stringToEncode) {
        if (stringToEncode == null) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        int incr = 0;
        while (i < stringToEncode.length()) {
            String encodingChar = null;
            char currentChar = stringToEncode.charAt(i);
            switch (currentChar) {
                case '\"': {
                    encodingChar = ENCODING_QUOTATION_MARK;
                    break;
                }
                case '\'': {
                    encodingChar = ENCODING_APOSTROPHE;
                    break;
                }
                case '&': {
                    String temp = stringToEncode.substring(i);
                    if (temp.startsWith(ENCODING_AMPERSAND) || temp.startsWith(ENCODING_QUOTATION_MARK) || temp.startsWith(ENCODING_APOSTROPHE) || temp.startsWith(ENCODING_LESS_THAN) || temp.startsWith(ENCODING_GREATER_THAN)) {
                        incr = temp.indexOf(59);
                        encodingChar = temp.substring(0, temp.indexOf(59) + 1);
                        break;
                    }
                    encodingChar = ENCODING_AMPERSAND;
                    break;
                }
                case '<': {
                    encodingChar = ENCODING_LESS_THAN;
                    break;
                }
                case '>': {
                    encodingChar = ENCODING_GREATER_THAN;
                }
            }
            if (encodingChar != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(stringToEncode.substring(0, i));
                }
                if (incr > 0) {
                    i += incr;
                    incr = 0;
                }
                buffer.append(encodingChar);
            } else if (buffer != null) {
                buffer.append(currentChar);
            }
            ++i;
        }
        if (buffer == null) {
            return stringToEncode;
        }
        return buffer.toString();
    }

    public static class NodeXMLWritable {
        private List<Node> rootNode = new ArrayList<Node>();

        public NodeXMLWritable(Node node) {
            this.addNode(node);
        }

        public void addNode(Node node) {
            if (node == null) {
                return;
            }
            this.rootNode.add(node);
        }

        public void toXML(StringWriter writer, int indentLevel) {
            int i = 0;
            int nodeCount = this.rootNode.size();
            while (i < nodeCount) {
                StringBuffer sb = new StringBuffer();
                sb.append("\n");
                XMLInternalUtility.serializeNode(sb, this.rootNode.get(i), indentLevel, false);
                sb.append("\n");
                writer.write(sb.toString());
                ++i;
            }
        }
    }

    public static class XMLWritableString {
        private String value;

        public XMLWritableString(String value) {
            this.value = value;
        }

        public void toXML(StringWriter writer, int indentLevel) {
            XMLInternalUtility.addIndent(writer, indentLevel);
            writer.write(String.valueOf(this.valueWithIndent(indentLevel + 1)) + "\n");
        }

        private String valueWithIndent(int i) {
            String tempValue = this.value;
            StringWriter tabsWriter = new StringWriter();
            tabsWriter.append('\n');
            XMLInternalUtility.addIndent(tabsWriter, i);
            tempValue = tempValue.replace("\n", tabsWriter.toString());
            tempValue = String.valueOf(tabsWriter.toString()) + tempValue;
            return tempValue;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XMLWritableString other = (XMLWritableString)obj;
            return !(this.value == null ? other.value != null : !this.equalsSpaceIgnore(this.value, other.value));
        }

        private boolean equalsSpaceIgnore(String string1, String string2) {
            String cleanedString1 = string1.replaceAll("[\\t\\r\\n]", "");
            String cleanedString2 = string2.replaceAll("[\\t\\r\\n]", "");
            return cleanedString1.equals(cleanedString2);
        }
    }
}

