/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.reference;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.reference.BadContextException;
import org.eclipse.cosmos.rm.internal.validation.reference.BadExpressionException;
import org.eclipse.cosmos.rm.internal.validation.reference.IXScheme;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPointerExpression {
    private static final int CHILD_SEQ_INCREMENT = 5;
    protected static final byte BARE_NAME_TYPE = 0;
    protected static final byte CHILD_SEQUENCE_TYPE = 1;
    protected static final byte FULL_XPOINTER_TYPE = 2;
    private byte type;
    private String bareName;
    private List<IXScheme> schemes;
    private int[] childSequence;
    private int childSequenceIndex;

    protected XPointerExpression(byte type) {
        this.type = type;
        this.schemes = new ArrayList<IXScheme>();
        this.childSequence = new int[5];
        this.childSequenceIndex = 0;
    }

    public String getBareName() {
        return this.bareName;
    }

    public void setBareName(String bareName) {
        this.bareName = bareName;
    }

    public byte getType() {
        return this.type;
    }

    public void addScheme(IXScheme scheme) {
        this.schemes.add(scheme);
    }

    public void addChildSequence(int child) {
        if (this.childSequenceIndex >= this.childSequence.length) {
            int[] newChildSequence = new int[this.childSequence.length + 5];
            System.arraycopy(this.childSequence, 0, newChildSequence, 0, this.childSequence.length);
            this.childSequence = newChildSequence;
        }
        this.childSequence[this.childSequenceIndex++] = child - 1;
    }

    public Object evaluate(Object context) throws BadContextException, BadExpressionException {
        return this.evaluate(null, context);
    }

    public Node evaluate(NamespaceContext namespaceContext, Object context) throws BadContextException, BadExpressionException {
        if (!(context instanceof Node)) {
            throw new BadContextException(SMLValidationMessages.errorBadContext);
        }
        if (namespaceContext != null) {
            int i = 0;
            int schemeCount = this.schemes.size();
            while (i < schemeCount) {
                IXScheme scheme = this.schemes.get(i);
                scheme.setNamespaceContext(namespaceContext);
                ++i;
            }
        }
        Node contextNode = (Node)context;
        if (this.type == 0) {
            return this.retrieveNodeByBareName(contextNode);
        }
        if (1 == this.type) {
            Node node;
            Node node2 = node = this.getBareName() == null ? (Node)context : this.retrieveNodeByBareName(contextNode);
            if (node == null) {
                return null;
            }
            NodeList childNodes = null;
            int[] childSequence = this.getChildSequence();
            int i = 0;
            while (i < childSequence.length) {
                NodeList nodeList = childNodes = node == null ? null : node.getChildNodes();
                if (childNodes == null || childSequence[i] < 0) {
                    return null;
                }
                int currentInx = 0;
                int inxWithoutWhiteSpace = 0;
                String nodeValue = null;
                while (inxWithoutWhiteSpace <= childSequence[i]) {
                    if (currentInx >= childNodes.getLength()) {
                        return null;
                    }
                    node = childNodes.item(currentInx);
                    if (3 != node.getNodeType() || (nodeValue = node.getNodeValue()) != null && nodeValue.trim().length() > 0) {
                        ++inxWithoutWhiteSpace;
                    }
                    ++currentInx;
                }
                ++i;
            }
            return node;
        }
        if (2 == this.type) {
            Object ctx = context;
            int i = 0;
            int schemeCount = this.schemes.size();
            while (i < schemeCount) {
                IXScheme scheme = this.schemes.get(i);
                ctx = scheme.evaluate(ctx);
                ++i;
            }
            if (ctx == null) {
                return null;
            }
            if (!(ctx instanceof NodeList[])) {
                throw new BadExpressionException(SMLValidationMessages.errorWrongReturnType);
            }
            NodeList[] nodeListArray = (NodeList[])ctx;
            NodeList nodeList = null;
            if (nodeListArray.length <= 0) {
                return null;
            }
            if (nodeListArray.length > 1 || (nodeList = nodeListArray[0]).getLength() > 1) {
                throw new BadExpressionException(SMLValidationMessages.errorWrongReturnScope);
            }
            return nodeList.getLength() == 0 ? null : nodeList.item(0);
        }
        return null;
    }

    private Node retrieveNodeByBareName(Node context) {
        Document document = context.getOwnerDocument();
        return document == null ? null : document.getElementById(this.getBareName());
    }

    public List<IXScheme> getSchemes() {
        return this.schemes;
    }

    public int[] getChildSequence() {
        int[] childSeq = new int[this.childSequenceIndex];
        System.arraycopy(this.childSequence, 0, childSeq, 0, childSeq.length);
        return childSeq;
    }
}

