/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Set;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MaterializeResultSetNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ProjectRestrictNode
extends SingleChildResultSetNode {
    public ValueNode restriction;
    ValueNode constantRestriction = null;
    public PredicateList restrictionList;
    SubqueryList projectSubquerys;
    SubqueryList restrictSubquerys;
    private boolean accessPathModified;
    private boolean accessPathConsidered;
    private boolean childResultOptimized;
    private boolean materialize;
    private boolean getTableNumberHere;

    public void init(Object childResult, Object projection, Object restriction, Object restrictionList, Object projectSubquerys, Object restrictSubquerys, Object tableProperties) {
        super.init(childResult, tableProperties);
        this.resultColumns = (ResultColumnList)projection;
        this.restriction = (ValueNode)restriction;
        this.restrictionList = (PredicateList)restrictionList;
        this.projectSubquerys = (SubqueryList)projectSubquerys;
        this.restrictSubquerys = (SubqueryList)restrictSubquerys;
        if (tableProperties != null && childResult instanceof Optimizable) {
            ((Optimizable)childResult).setProperties(this.getProperties());
            this.setProperties(null);
        }
    }

    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).nextAccessPath(optimizer, this.restrictionList, rowOrdering);
        }
        return super.nextAccessPath(optimizer, predList, rowOrdering);
    }

    public void rememberAsBest(int planType, Optimizer optimizer) throws StandardException {
        super.rememberAsBest(planType, optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberAsBest(planType, optimizer);
        }
    }

    void printRememberingBestAccessPath(int planType, AccessPath bestPath) {
    }

    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).startOptimizing(optimizer, rowOrdering);
        } else {
            this.accessPathConsidered = false;
            super.startOptimizing(optimizer, rowOrdering);
        }
    }

    public int getTableNumber() {
        if (this.getTableNumberHere) {
            return super.getTableNumber();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTableNumber();
        }
        return super.getTableNumber();
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        this.costEstimate = this.getCostEstimate(optimizer);
        this.updateBestPlanMap((short)1, this);
        if (this.childResult instanceof Optimizable) {
            CostEstimate childCost = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, this.restrictionList, outerCost, rowOrdering);
            this.costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        } else if (!this.accessPathModified) {
            if (!(this.childResult instanceof SelectNode) && !(this.childResult instanceof RowResultSetNode)) {
                SanityManager.THROWASSERT("childResult is expected to be instanceof SelectNode or RowResultSetNode - it is a " + this.childResult.getClass().getName());
            }
            this.childResult = this.childResult.optimize(optimizer.getDataDictionary(), this.restrictionList, outerCost.rowCount());
            CostEstimate childCost = this.childResult.costEstimate;
            this.costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
            optimizer.considerCost(this, this.restrictionList, this.getCostEstimate(), outerCost);
        }
        return this.costEstimate;
    }

    public boolean feasibleJoinStrategy(OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList);
            }
            return ((Optimizable)((Object)this.childResult)).feasibleJoinStrategy(this.restrictionList, optimizer);
        }
        return super.feasibleJoinStrategy(this.restrictionList, optimizer);
    }

    public AccessPath getCurrentAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getCurrentAccessPath();
        }
        return super.getCurrentAccessPath();
    }

    public AccessPath getBestAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestAccessPath();
        }
        return super.getBestAccessPath();
    }

    public AccessPath getBestSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestSortAvoidancePath();
        }
        return super.getBestSortAvoidancePath();
    }

    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    public void rememberSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberSortAvoidancePath();
        } else {
            super.rememberSortAvoidancePath();
        }
    }

    public boolean considerSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).considerSortAvoidancePath();
        }
        return super.considerSortAvoidancePath();
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT(optimizablePredicate instanceof Predicate, "optimizablePredicate expected to be instanceof Predicate");
        SanityManager.ASSERT(!optimizablePredicate.hasSubquery() && !optimizablePredicate.hasMethodCall(), "optimizablePredicate either has a subquery or a method call");
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        Predicate pred = (Predicate)optimizablePredicate;
        if (!pred.remapScopedPred()) {
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            pred.getAndNode().accept(rcrv);
        }
        return true;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        if (this.restrictionList != null) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList);
            }
            RemapCRsVisitor rcrv = new RemapCRsVisitor(false);
            for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
                OptimizablePredicate optPred = this.restrictionList.getOptPredicate(i);
                ((Predicate)optPred).getAndNode().accept(rcrv);
                optimizablePredicates.addOptPredicate(optPred);
                this.restrictionList.removeOptPredicate(i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        boolean hashJoinWithThisPRN;
        boolean origChildOptimizable = true;
        if (this.accessPathModified) {
            return this;
        }
        boolean alreadyPushed = false;
        if (!(this.childResult instanceof Optimizable)) {
            origChildOptimizable = false;
            this.childResult = this.childResult.modifyAccessPaths(this.restrictionList);
            if (this.childResult instanceof ProjectRestrictNode) {
                ProjectRestrictNode prn = (ProjectRestrictNode)this.childResult;
                if (prn.childResult.getResultColumns().containsWindowFunctionResultColumn()) {
                    this.resultColumns.genVirtualColumnNodes(prn.childResult, prn.childResult.getResultColumns());
                }
            }
            this.hasTrulyTheBestAccessPath = true;
            if (!this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(outerTables));
            SanityManager.ASSERT(this.restrictionList != null, "restrictionList expected to be non-null");
            SanityManager.ASSERT(this.restrictionList.size() != 0, "restrictionList.size() expected to be non-zero");
            this.getTableNumberHere = true;
        } else if (!(this.childResult instanceof FromBaseTable)) {
            if (this.trulyTheBestAccessPath.getJoinStrategy() == null) {
                this.trulyTheBestAccessPath = (AccessPathImpl)((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
            }
            if (this.childResult instanceof SetOperatorNode) {
                this.childResult = (ResultSetNode)((Object)((SetOperatorNode)this.childResult).modifyAccessPath(outerTables, this.restrictionList));
                alreadyPushed = true;
            } else {
                this.childResult = (ResultSetNode)((Object)((FromTable)this.childResult).modifyAccessPath(outerTables));
            }
        }
        boolean bl = hashJoinWithThisPRN = this.hasTrulyTheBestAccessPath && this.trulyTheBestAccessPath.getJoinStrategy() != null && this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin();
        if (this.restrictionList != null && !alreadyPushed && !hashJoinWithThisPRN) {
            this.restrictionList.pushUsefulPredicates((Optimizable)((Object)this.childResult));
        }
        if (origChildOptimizable) {
            this.childResult = this.childResult.changeAccessPath();
        }
        this.accessPathModified = true;
        if (this.trulyTheBestAccessPath.getJoinStrategy() == null || !this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(outerTables));
        return this.replaceWithHashTableNode();
    }

    private Optimizable replaceWithHashTableNode() throws StandardException {
        int i;
        if (this.hasTrulyTheBestAccessPath) {
            ((FromTable)this.childResult).trulyTheBestAccessPath = (AccessPathImpl)this.getTrulyTheBestAccessPath();
            if (this.childResult instanceof SingleChildResultSetNode) {
                ((SingleChildResultSetNode)this.childResult).hasTrulyTheBestAccessPath = this.hasTrulyTheBestAccessPath;
                this.childResult.getReferencedTableMap().set(this.tableNumber);
            }
        }
        PredicateList searchRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        PredicateList joinQualifierList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        PredicateList requalificationRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.trulyTheBestAccessPath.getJoinStrategy().divideUpPredicateLists(this, this.restrictionList, searchRestrictionList, joinQualifierList, requalificationRestrictionList, this.getDataDictionary());
        this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        for (i = 0; i < searchRestrictionList.size(); ++i) {
            requalificationRestrictionList.removeOptPredicate((Predicate)searchRestrictionList.elementAt(i));
        }
        for (i = 0; i < joinQualifierList.size(); ++i) {
            requalificationRestrictionList.removeOptPredicate((Predicate)joinQualifierList.elementAt(i));
        }
        joinQualifierList.transferNonQualifiers(this, this.restrictionList);
        requalificationRestrictionList.copyPredicatesToOtherList(this.restrictionList);
        ResultColumnList htRCList = this.childResult.getResultColumns();
        this.childResult.setResultColumns(htRCList.copyListAndObjects());
        htRCList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns(), false);
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        searchRestrictionList.accept(rcrv);
        this.childResult = (ResultSetNode)this.getNodeFactory().getNode(148, this.childResult, this.tableProperties, htRCList, searchRestrictionList, joinQualifierList, this.trulyTheBestAccessPath, this.getCostEstimate(), this.projectSubquerys, this.restrictSubquerys, this.hashKeyColumns(), this.getContextManager());
        return this;
    }

    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).verifyProperties(dDictionary);
        } else {
            super.verifyProperties(dDictionary);
        }
    }

    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).legalJoinOrder(assignedTableMap);
        }
        return true;
    }

    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).uniqueJoin(predList);
        }
        return super.uniqueJoin(predList);
    }

    PredicateList getRestrictionList() {
        return this.restrictionList;
    }

    String getUserSpecifiedJoinStrategy() {
        if (this.childResult instanceof FromTable) {
            return ((FromTable)this.childResult).getUserSpecifiedJoinStrategy();
        }
        return this.userSpecifiedJoinStrategy;
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.restriction != null) {
            this.printLabel(depth, "restriction: ");
            this.restriction.treePrint(depth + 1);
        }
        if (this.restrictionList != null) {
            this.printLabel(depth, "restrictionList: ");
            this.restrictionList.treePrint(depth + 1);
        }
        if (this.projectSubquerys != null) {
            this.printLabel(depth, "projectSubquerys: ");
            this.projectSubquerys.treePrint(depth + 1);
        }
        if (this.restrictSubquerys != null) {
            this.printLabel(depth, "restrictSubquerys: ");
            this.restrictSubquerys.treePrint(depth + 1);
        }
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(numTables, gbl, fromList);
        this.referencedTableMap = (JBitSet)this.childResult.getReferencedTableMap().clone();
        return this;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        PredicateList pushPList = null;
        SanityManager.ASSERT(predicateList != null, "predicateList is expected to be non-null");
        if (this.childResult instanceof JoinNode) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
        if ((pushPList = predicateList.getPushablePredicates(this.referencedTableMap)) != null && this.childResult instanceof SelectNode && !this.resultColumns.containsWindowFunctionResultColumn()) {
            pushPList.pushExpressionsIntoSelect((SelectNode)this.childResult, false);
        }
        if (pushPList != null && this.childResult instanceof UnionNode) {
            ((UnionNode)this.childResult).pushExpressions(pushPList);
        }
        if (this.restrictionList == null) {
            this.restrictionList = pushPList;
        } else if (pushPList != null && pushPList.size() != 0) {
            this.restrictionList.destructiveAppend(pushPList);
        }
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate(predicate);
        return this;
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, this.restrictionList, outerRows);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicates, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    public CostEstimate getCostEstimate() {
        if (this.costEstimate == null) {
            return this.childResult.getCostEstimate();
        }
        return this.costEstimate;
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.childResult instanceof Optimizable ? this.childResult.getFinalCostEstimate() : this.getTrulyTheBestAccessPath().getCostEstimate();
        return this.finalCostEstimate;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.resultColumns != null, "Tree structure bad");
        this.generateMinion(acb, mb, false);
    }

    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateMinion(acb, mb, true);
    }

    private void generateMinion(ExpressionClassBuilder acb, MethodBuilder mb, boolean genChildResultSet) throws StandardException {
        if (this.restrictionList != null && this.restrictionList.size() > 0) {
            this.restrictionList.eliminateBooleanTrueAndBooleanTrue();
        }
        if (this.nopProjectRestrict()) {
            this.generateNOPProjectRestrict();
            if (genChildResultSet) {
                this.childResult.generateResultSet(acb, mb);
            } else {
                this.childResult.generate((ActivationClassBuilder)acb, mb);
            }
            this.costEstimate = this.childResult.getFinalCostEstimate();
            return;
        }
        if (this.restrictionList != null) {
            this.constantRestriction = this.restrictionList.restoreConstantPredicates();
            this.restrictionList.removeRedundantPredicates();
            this.restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int[] mapArray = this.resultColumns.mapSourceColumns();
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        boolean doesProjection = true;
        if (!this.reflectionNeededForProjection() && mapArray != null && mapArray.length == this.childResult.getResultColumns().size()) {
            int index;
            for (index = 0; index < mapArray.length && mapArray[index] == index + 1; ++index) {
            }
            if (index == mapArray.length) {
                doesProjection = false;
            }
        }
        acb.pushGetResultSetFactoryExpression(mb);
        if (genChildResultSet) {
            this.childResult.generateResultSet(acb, mb);
        } else {
            this.childResult.generate((ActivationClassBuilder)acb, mb);
        }
        this.assignResultSetNumber();
        if (this.projectSubquerys != null && this.projectSubquerys.size() > 0) {
            this.projectSubquerys.setPointOfAttachment(this.resultSetNumber);
        }
        if (this.restrictSubquerys != null && this.restrictSubquerys.size() > 0) {
            this.restrictSubquerys.setPointOfAttachment(this.resultSetNumber);
        }
        this.costEstimate = this.getFinalCostEstimate();
        if (this.restriction == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this.restriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        if (this.reflectionNeededForProjection()) {
            this.resultColumns.generateCore(acb, mb, false);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.resultSetNumber);
        if (this.constantRestriction == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this.constantRestriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(mapArrayItem);
        mb.push(this.resultColumns.reusableResult());
        mb.push(doesProjection);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getProjectRestrictResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 10);
    }

    boolean nopProjectRestrict() {
        if (this.restriction != null || this.restrictionList != null && this.restrictionList.size() > 0) {
            return false;
        }
        ResultColumnList childColumns = this.childResult.getResultColumns();
        ResultColumnList PRNColumns = this.getResultColumns();
        return PRNColumns.nopProjection(childColumns);
    }

    public void generateNOPProjectRestrict() throws StandardException {
        this.getResultColumns().setRedundant();
    }

    public ResultSetNode considerMaterialization(JBitSet outerTables) throws StandardException {
        this.childResult = this.childResult.considerMaterialization(outerTables);
        if (this.childResult.performMaterialization(outerTables)) {
            boolean emptyRestrictionList;
            ReferencedTablesVisitor rtv = new ReferencedTablesVisitor((JBitSet)this.childResult.getReferencedTableMap().clone());
            boolean bl = emptyRestrictionList = this.restrictionList == null || this.restrictionList.size() == 0;
            if (!emptyRestrictionList) {
                this.restrictionList.accept(rtv);
            }
            if (emptyRestrictionList || this.childResult.getReferencedTableMap().contains(rtv.getTableMap())) {
                ResultColumnList prRCList = this.resultColumns;
                this.setResultColumns(this.resultColumns.copyListAndObjects());
                prRCList.genVirtualColumnNodes(this, this.resultColumns);
                MaterializeResultSetNode mrsn = (MaterializeResultSetNode)this.getNodeFactory().getNode(121, this, prRCList, this.tableProperties, this.getContextManager());
                if (this.referencedTableMap != null) {
                    mrsn.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
                }
                return mrsn;
            }
            ResultColumnList prRCList = this.childResult.getResultColumns();
            this.childResult.setResultColumns(prRCList.copyListAndObjects());
            prRCList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns());
            MaterializeResultSetNode mrsn = (MaterializeResultSetNode)this.getNodeFactory().getNode(121, this.childResult, prRCList, this.tableProperties, this.getContextManager());
            if (this.childResult.getReferencedTableMap() != null) {
                mrsn.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
            }
            this.childResult = mrsn;
        }
        return this;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.childResult.getFromTableByName(name, schemaName, exactMatch);
    }

    public int updateTargetLockMode() {
        if (this.restriction != null || this.constantRestriction != null) {
            return 6;
        }
        return this.childResult.updateTargetLockMode();
    }

    boolean isPossibleDistinctScan(Set distinctColumns) {
        if (this.restriction != null || this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<BaseColumnNode> columns = new HashSet<BaseColumnNode>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            BaseColumnNode bc = rc.getBaseColumnNode();
            if (bc == null) {
                return false;
            }
            columns.add(bc);
        }
        return columns.equals(distinctColumns) && this.childResult.isPossibleDistinctScan(distinctColumns);
    }

    void markForDistinctScan() {
        this.childResult.markForDistinctScan();
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.restriction != null && !v.stopTraversal()) {
            this.restriction = (ValueNode)this.restriction.accept(v);
        }
        if (this.restrictionList != null && !v.stopTraversal()) {
            this.restrictionList = (PredicateList)this.restrictionList.accept(v);
        }
        return returnNode;
    }

    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.childResult.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    public void setRestriction(ValueNode restriction) {
        this.restriction = restriction;
    }
}

