/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;

class RowCountResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    final NoPutResultSet source;
    private final boolean runTimeStatsOn;
    private long offset;
    private long fetchFirst;

    RowCountResultSet(NoPutResultSet s, Activation a, int resultSetNumber, long offset, long fetchFirst, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "RowCountResultSet not open, cannot reopen");
        this.source.reopenCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.offset > 0L) {
            while (true) {
                result = this.source.getNextRowCore();
                --this.offset;
                if (result == null || this.offset < 0L) break;
                ++this.rowsFiltered;
            }
            this.offset = 0L;
        } else {
            result = this.fetchFirst != -1L && (long)this.rowsSeen >= this.fetchFirst ? null : this.source.getNextRowCore();
        }
        if (result != null) {
            ++this.rowsSeen;
        }
        this.setCurrentRow(result);
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return result;
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of RowCountResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public final void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
        this.source.clearCurrentRow();
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getCurrentRow();
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public ProjectRestrictResultSet getUnderlyingProjectRestrictRS() {
        if (this.source instanceof ProjectRestrictResultSet) {
            return (ProjectRestrictResultSet)this.source;
        }
        return null;
    }
}

