/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.QueryMetadataTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IDialect;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IQueryCapabilities;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IQueryServiceMetadata;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.MapParameterImpl;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SessionResolveFixedTreeIDs;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuidlerServiceMetatData
extends AbstractOutputter {
    public static final String MDREPR = "epr";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SOAPVERSION = "soapversion";
    protected String rootId;

    @Override
    public void render(PrintWriter output, IParameters input) throws Exception {
        String mdrEPR = input.getParameter(MDREPR);
        String username = input.getParameter(USERNAME);
        String password = input.getParameter(PASSWORD);
        String soapversion = input.getParameter(SOAPVERSION);
        if (mdrEPR != null) {
            IQueryServiceMetadata serviceMetatData = this.getServiceMetatData(mdrEPR, username, password, soapversion);
            this.renderServiceMetaData(output, serviceMetatData);
        }
    }

    protected IQueryServiceMetadata getServiceMetatData(String mdrEPR, String username, String password, String soapversion) throws Exception {
        Element result;
        QueryServiceClient queryService = new QueryServiceClient(mdrEPR);
        if (username != null) {
            queryService.setUsername(username);
        }
        if (password != null) {
            queryService.setPassword(password);
        }
        if (soapversion != null) {
            queryService.setSoapVersion(Integer.parseInt(soapversion));
        }
        if ((result = queryService.getQueryServiceMetadata()) == null) {
            return null;
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        trans.transform(new DOMSource(result), new StreamResult(bout));
        ByteArrayInputStream is = new ByteArrayInputStream(bout.toByteArray());
        IQueryServiceMetadata queryServiceMetadata = QueryMetadataTransformer.transform((InputStream)is);
        return queryServiceMetadata;
    }

    protected void renderServiceMetaData(PrintWriter pw, IQueryServiceMetadata serviceMetatData) {
        int x;
        DocumentBuilderFactory.newInstance();
        boolean serviceMetaDataSupport = false;
        boolean relationshipSupport = false;
        boolean relationshipDepthLimitSupport = false;
        boolean relationshipMinMaxSupport = false;
        boolean contentSelectorSupport = false;
        boolean csRecordTypeSelector = false;
        boolean csPropertySelector = false;
        boolean xPathSupport = false;
        boolean recordConstraintSuport = false;
        boolean rcsRecordTypeConstraintSupport = false;
        boolean rcsPropertyConstraintSupport = false;
        boolean propertyValuesOpSuport = false;
        ArrayList<String> operators = new ArrayList<String>();
        ArrayList<String> xDialect = new ArrayList<String>();
        ArrayList<String> namespace = new ArrayList<String>();
        ArrayList<String> recordTypes = new ArrayList<String>();
        if (serviceMetatData != null && serviceMetatData.getQueryCapabilities() != null) {
            IQueryCapabilities queryCapabilities = serviceMetatData.getQueryCapabilities();
            if (queryCapabilities.getRelationshipTemplateSupport() != null) {
                relationshipSupport = true;
                relationshipDepthLimitSupport = queryCapabilities.getRelationshipTemplateSupport().isDepthLimit();
                relationshipMinMaxSupport = queryCapabilities.getRelationshipTemplateSupport().isMinimumMaximum();
            }
            if (queryCapabilities.getContentSelectorSupport() != null) {
                contentSelectorSupport = true;
                csRecordTypeSelector = queryCapabilities.getContentSelectorSupport().isRecordTypeSelector();
                csPropertySelector = queryCapabilities.getContentSelectorSupport().isPropertySelector();
            }
            if (queryCapabilities.getRecordConstraintSupport() != null) {
                recordConstraintSuport = true;
                rcsRecordTypeConstraintSupport = queryCapabilities.getRecordConstraintSupport().isRecordTypeConstraint();
                rcsPropertyConstraintSupport = queryCapabilities.getRecordConstraintSupport().isPropertyValueConstraint();
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isEqual()) {
                    operators.add("=");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isLessOrEqual()) {
                    operators.add("<=");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isLess()) {
                    operators.add("<");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isGreater()) {
                    operators.add(">");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isGreaterOrEqual()) {
                    operators.add(">=");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isContains()) {
                    operators.add("contains");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isLike()) {
                    operators.add("like");
                }
                if (queryCapabilities.getRecordConstraintSupport().getPropertyValueOperators().isNull()) {
                    operators.add("isNull");
                }
                boolean bl = propertyValuesOpSuport = operators.size() > 0;
            }
            if (queryCapabilities.getXpathSupport() != null) {
                xPathSupport = true;
                IDialect[] dialectList = queryCapabilities.getXpathSupport().getDialects();
                int z = 0;
                while (z < dialectList.length) {
                    IDialect dialectNode = dialectList[z];
                    xDialect.add(dialectNode.getDialect());
                    ++z;
                }
            }
            if (serviceMetatData.getRecordTypeList() != null) {
                IRecordTypes[] types = serviceMetatData.getRecordTypeList().getRecordTypes();
                x = 0;
                while (x < types.length) {
                    namespace.add(types[x].getNamespace());
                    IRecordType[] recordTypeList = types[x].getRecordType();
                    int y = 0;
                    while (y < recordTypeList.length) {
                        recordTypes.add(recordTypeList[y].getLocalName());
                        ++y;
                    }
                    ++x;
                }
            }
        }
        boolean bl = serviceMetaDataSupport = relationshipSupport || relationshipDepthLimitSupport || relationshipMinMaxSupport || contentSelectorSupport || csRecordTypeSelector || csPropertySelector || xPathSupport || recordConstraintSuport || rcsRecordTypeConstraintSupport || rcsPropertyConstraintSupport || propertyValuesOpSuport;
        if (serviceMetaDataSupport) {
            StringBuffer buffer = new StringBuffer("{ identifier: \"nodeClass\",  label: \"title\",  items:[");
            ArrayList<String> children = new ArrayList<String>();
            this.generateRules(false, children, "", relationshipSupport, relationshipDepthLimitSupport, relationshipMinMaxSupport, contentSelectorSupport, csRecordTypeSelector, csPropertySelector, xPathSupport, recordConstraintSuport, rcsRecordTypeConstraintSupport, rcsPropertyConstraintSupport, propertyValuesOpSuport);
            if (relationshipSupport) {
                this.generateRules(true, children, "rel", relationshipSupport, relationshipDepthLimitSupport, relationshipMinMaxSupport, contentSelectorSupport, csRecordTypeSelector, csPropertySelector, xPathSupport, recordConstraintSuport, rcsRecordTypeConstraintSupport, rcsPropertyConstraintSupport, propertyValuesOpSuport);
            }
            x = 0;
            while (x < children.size()) {
                if (x != 0) {
                    buffer.append("\n,");
                }
                buffer.append((String)children.get(x));
                ++x;
            }
            buffer.append("]}");
            StringBuffer nodeBuffer = new StringBuffer("{ identifier: \"nodeClass\",  label: \"title\",  items:[");
            ArrayList<String> nodes = new ArrayList<String>();
            this.generateNodes(false, nodes, "", relationshipSupport, relationshipDepthLimitSupport, relationshipMinMaxSupport, contentSelectorSupport, csRecordTypeSelector, csPropertySelector, xPathSupport, recordConstraintSuport, rcsRecordTypeConstraintSupport, rcsPropertyConstraintSupport, propertyValuesOpSuport, xDialect, operators, namespace, recordTypes);
            int x2 = 0;
            while (x2 < nodes.size()) {
                if (x2 != 0) {
                    nodeBuffer.append("\n,");
                }
                nodeBuffer.append((String)nodes.get(x2));
                ++x2;
            }
            nodeBuffer.append("]}");
            StringBuffer parentBuffer = new StringBuffer("{");
            parentBuffer.append("menuRules:").append(buffer).append(",factory:").append(nodeBuffer).append(",supportRel:").append(relationshipSupport).append("}");
            pw.println(parentBuffer.toString());
        } else {
            pw.println("{capabilityUnknown: true}");
        }
    }

    protected void generateNodes(boolean isRel, List<String> children, String prefix, boolean relationshipSupport, boolean relationshipDepthLimitSupport, boolean relationshipMinMaxSupport, boolean contentSelectorSupport, boolean csRecordTypeSelector, boolean csPropertySelector, boolean xPathSupport, boolean recordConstraintSuport, boolean rcsRecordTypeConstraintSupport, boolean rcsPropertyConstraintSupport, boolean propertyValuesOpSuport, List<String> xDialect, List<String> opList, List<String> namespace, List<String> recordTypes) {
        int x;
        String namespaceString = "";
        int x2 = 0;
        while (x2 < namespace.size()) {
            if (x2 != 0) {
                namespaceString = String.valueOf(namespaceString) + ",";
            }
            namespaceString = String.valueOf(namespaceString) + "'" + namespace.get(x2) + "'";
            ++x2;
        }
        String recordTypesString = "";
        int x3 = 0;
        while (x3 < recordTypes.size()) {
            if (x3 != 0) {
                recordTypesString = String.valueOf(recordTypesString) + ",";
            }
            recordTypesString = String.valueOf(recordTypesString) + "'" + recordTypes.get(x3) + "'";
            ++x3;
        }
        children.add("{nodeLbl:'itemTemplate',nodeClass:'itemTemplate',factoryType:'dojox.grid.data.Table',factory: [[ 'id', ''],[ 'suppressFromResult', false]]}");
        children.add("{nodeLbl:'any',nodeClass:'any',factoryType:'dojo.data.ItemFileWriteStore'}");
        children.add("{nodeLbl:'instanceIdConstraint',nodeClass:'instanceIdConstraint',addChild:['instanceId']}");
        children.add("{nodeLbl:'instanceId',nodeClass:'instanceId',factoryType:'dojox.grid.data.Table',pop:true,factory: [[ 'mdrId', ''],[ 'localId', '']]}");
        if (relationshipSupport) {
            children.add("{nodeLbl:'relationshipTemplate',nodeClass:'relationshipTemplate',factoryType:'dojox.grid.data.Table',factory: [[ 'id', ''],[ 'suppressFromResult', false]]}");
            children.add("{nodeLbl:'any',nodeClass:'relany',factoryType:'dojo.data.ItemFileWriteStore'}");
            children.add("{nodeLbl:'instanceId',nodeClass:'relinstanceId',factoryType:'dojox.grid.data.Table',pop:true,factory: [[ 'mdrId', ''],[ 'localId', '']]}");
            children.add("{nodeLbl:'instanceIdConstraint',nodeClass:'relinstanceIdConstraint',addChild:['relinstanceId']}");
            children.add("{nodeLbl:'sourceTemplate',nodeClass:'sourceTemplate',factoryType:'dojox.grid.data.Table',factory: [[ 'ref', '']" + (relationshipMinMaxSupport ? ",[ 'minimum', ''],[ 'maximum', '']" : "") + "]}");
            children.add("{nodeLbl:'targetTemplate',nodeClass:'targetTemplate',factoryType:'dojox.grid.data.Table',factory: [[ 'ref', '']" + (relationshipMinMaxSupport ? ",[ 'minimum', ''],[ 'maximum', '']" : "") + "]}");
            if (relationshipDepthLimitSupport) {
                children.add("{nodeLbl:'depthLimit',nodeClass:'depthLimit',factoryType:'dojox.grid.data.Table',factory: [[ 'maxIntermediateItems', '0'],[ 'intermediateItemTemplate', '']]}");
            }
        }
        if (contentSelectorSupport) {
            children.add("{nodeLbl:'contentSelector',nodeClass:'contentSelector',factoryType:'dojox.grid.data.Table',factory: [[ 'matchedRecords', true]]}");
            if (relationshipSupport) {
                children.add("{nodeLbl:'contentSelector',nodeClass:'relcontentSelector',factoryType:'dojox.grid.data.Table',factory: [[ 'matchedRecords', true]]}");
            }
            if (csRecordTypeSelector) {
                children.add("{nodeLbl:'selectedRecordType',nodeClass:'selectedRecordType',factoryType:'dojox.grid.data.Table',factory: [[ 'namespace', ''],[ 'localName', '']], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]]}");
                if (relationshipSupport) {
                    children.add("{nodeLbl:'selectedRecordType',nodeClass:'relselectedRecordType',factoryType:'dojox.grid.data.Table',factory: [[ 'namespace', ''],[ 'localName', '']], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]]}");
                }
                if (csPropertySelector) {
                    children.add("{nodeLbl:'selectedProperty',nodeClass:'selectedProperty',factoryType:'dojox.grid.data.Table',factory: [[ 'namespace', ''],[ 'localName', '']], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]]}");
                    if (relationshipSupport) {
                        children.add("{nodeLbl:'selectedProperty',nodeClass:'relselectedProperty',factoryType:'dojox.grid.data.Table',factory: [[ 'namespace', ''],[ 'localName', '']], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]]}");
                    }
                }
            }
        }
        if (recordConstraintSuport) {
            children.add("{nodeLbl:'recordConstraint',nodeClass:'recordConstraint'}");
            if (relationshipSupport) {
                children.add("{nodeLbl:'recordConstraint',nodeClass:'relrecordConstraint'}");
            }
            if (rcsRecordTypeConstraintSupport) {
                children.add("{nodeLbl:'recordType',nodeClass:'recordType',factoryType:'dojox.grid.data.Table',factory: [[ 'namespace', ''],[ 'localName', '']], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]]}");
                if (relationshipSupport) {
                    children.add("{nodeLbl:'recordType',nodeClass:'relrecordType',factoryType:'dojox.grid.data.Table',factory: [[ 'namespace', ''],[ 'localName', '']], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]]}");
                }
            }
            if (rcsPropertyConstraintSupport) {
                String opString = "";
                x = 0;
                while (x < opList.size()) {
                    if (x != 0) {
                        opString = String.valueOf(opString) + ",";
                    }
                    opString = String.valueOf(opString) + "'" + opList.get(x) + "'";
                    ++x;
                }
                children.add("{nodeLbl:'propertyValue',nodeClass:'propertyValue',factoryType:'org.eclipse.cosmos.provisional.dr.ps.components.widget.PropValueDataStore', params:[[{datao:[[ 'namespace', ''],[ 'localName', '' ]], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]],opOptions:[[" + opString + "]]}]]}");
                if (relationshipSupport) {
                    children.add("{nodeLbl:'propertyValue',nodeClass:'relpropertyValue',factoryType:'org.eclipse.cosmos.provisional.dr.ps.components.widget.PropValueDataStore', params:[[{datao:[[ 'namespace', ''],[ 'localName', '' ]], metadata:[[{type:'Select', options:[" + namespaceString + "]},{type:'Select', options:[" + recordTypesString + "]}]],opOptions:[[" + opString + "]]}]]}");
                }
            }
        }
        if (xPathSupport) {
            String dialectString = "";
            x = 0;
            while (x < xDialect.size()) {
                if (x != 0) {
                    dialectString = String.valueOf(dialectString) + ",";
                }
                dialectString = String.valueOf(dialectString) + "'" + xDialect.get(x) + "'";
                ++x;
            }
            children.add("{nodeLbl:'expression',nodeClass:'expression',factoryType:'dojo.data.ItemFileWriteStore'}");
            children.add("{nodeLbl:'prefixMapping',nodeClass:'prefixMapping',factoryType:'dojox.grid.data.Table',factory: [[ 'prefix', ''],[ 'namespace', '']]}");
            children.add("{nodeLbl:'xpathExpression',nodeClass:'xpathExpression',addChild:['expression'],factoryType:'dojox.grid.data.Table',factory: [[ 'dialect', '']], metadata:[[{type:'Select', options:[" + dialectString + "]}]]}");
            if (relationshipSupport) {
                children.add("{nodeLbl:'expression',nodeClass:'relexpression',factoryType:'dojo.data.ItemFileWriteStore'}");
                children.add("{nodeLbl:'prefixMapping',nodeClass:'relprefixMapping',factoryType:'dojox.grid.data.Table',factory: [[ 'prefix', ''],[ 'namespace', '']]}");
                children.add("{nodeLbl:'xpathExpression',nodeClass:'relxpathExpression',addChild:['relexpression'],factoryType:'dojox.grid.data.Table',factory: [[ 'dialect', '']], metadata:[[{type:'Select', options:[" + dialectString + "]}]]}");
            }
        }
    }

    protected void generateRules(boolean isRel, List<String> children, String prefix, boolean relationshipSupport, boolean relationshipDepthLimitSupport, boolean relationshipMinMaxSupport, boolean contentSelectorSupport, boolean csRecordTypeSelector, boolean csPropertySelector, boolean xPathSupport, boolean recordConstraintSuport, boolean rcsRecordTypeConstraintSupport, boolean rcsPropertyConstraintSupport, boolean propertyValuesOpSuport) {
        String contentRefSelectStr = "";
        String recordConstraint = "";
        String xpathExpressionStr = "";
        if (contentSelectorSupport) {
            contentRefSelectStr = "{_reference:'" + prefix + "contentSelector'},";
            String csRecordTypeElem = "";
            if (csRecordTypeSelector) {
                csRecordTypeElem = ",children:[{_reference:'" + prefix + "selectedRecordType'}";
                String csPropertyTypeElem = "";
                if (csPropertySelector) {
                    csPropertyTypeElem = ",children:[{_reference:'" + prefix + "selectedProperty'}";
                    children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " selectedProperty',nodeClass:'" + prefix + "selectedProperty',children:[{_reference:'" + prefix + "delete'}]}");
                }
                children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " selectedRecordType',nodeClass:'" + prefix + "selectedRecordType'" + csPropertyTypeElem + ",{_reference:'" + prefix + "delete'}]}");
            }
            children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " contentSelector',nodeClass:'" + prefix + "contentSelector', menuRules:['" + prefix + "contentSelector','" + prefix + "xpathExpression'] " + csRecordTypeElem + ",{_reference:'" + prefix + "delete'}]}");
        }
        if (recordConstraintSuport) {
            recordConstraint = "{_reference:'" + prefix + "recordConstraint'},";
            String rcsRecordType = "";
            if (rcsRecordTypeConstraintSupport) {
                rcsRecordType = "{_reference:'" + prefix + "recordType'},";
                children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " recordType',nodeClass:'" + prefix + "recordType',children:[{_reference:'" + prefix + "delete'}]}");
            }
            String rcsPropertyValue = "";
            if (rcsPropertyConstraintSupport) {
                rcsPropertyValue = "{_reference:'" + prefix + "propertyValue'},";
                children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " propertyValue',nodeClass:'" + prefix + "propertyValue',children:[{_reference:'" + prefix + "delete'}]}");
            }
            children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " recordConstraint',nodeClass:'" + prefix + "recordConstraint',menuRules:['" + prefix + "xpathExpression'],children:[" + rcsRecordType + rcsPropertyValue + "{_reference:'" + prefix + "any'},{_reference:'" + prefix + "delete'}]}");
        }
        if (xPathSupport) {
            xpathExpressionStr = "{_reference:'" + prefix + "xpathExpression'},";
            children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " expression',nodeClass:'" + prefix + "expression',children:[{_reference:'" + prefix + "delete'}]}");
            children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " prefixMapping',nodeClass:'" + prefix + "prefixMapping',children:[{_reference:'" + prefix + "delete'}]}");
            children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " xpathExpression',nodeClass:'" + prefix + "xpathExpression',menuRules:['" + prefix + "instanceIdConstraint','" + prefix + "contentSelector','" + prefix + "recordConstraint'],children:[{_reference:'" + prefix + "prefixMapping'},{_reference:'" + prefix + "expression'},{_reference:'" + prefix + "delete'}]}");
        }
        children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " instanceIdContraint',nodeClass:'" + prefix + "instanceIdConstraint',menuRules:['" + prefix + "instanceIdConstraint','" + prefix + "xpathExpression'],children:[{_reference:'" + prefix + "instanceId'},{_reference:'" + prefix + "delete'}]}");
        children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " instanceId',nodeClass:'" + prefix + "instanceId',children:[{_reference:'" + prefix + "delete'}]}");
        children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " any',nodeClass:'" + prefix + "any',children:[{_reference:'" + prefix + "delete'}]}");
        children.add("{title:'delete',nodeClass:'" + prefix + "delete'}");
        if (isRel) {
            if (relationshipSupport) {
                String depthLimit = "";
                if (relationshipDepthLimitSupport) {
                    depthLimit = "{_reference:'depthLimit'},";
                    children.add("{title:'" + Messages.getString("QueryBuidlerServiceMetatData.48") + " depthLimit',nodeClass:'depthLimit',menuRules:['depthLimit']}");
                }
                children.add("{title:'',nodeClass:'relationshipTemplate',children:[" + contentRefSelectStr + recordConstraint + xpathExpressionStr + depthLimit + "{_reference:'" + prefix + "instanceIdConstraint'},{_reference:'" + prefix + "any'}]}");
            }
        } else {
            children.add("{title:'',nodeClass:'" + prefix + "itemTemplate',children:[" + contentRefSelectStr + recordConstraint + xpathExpressionStr + "{_reference:'" + prefix + "instanceIdConstraint'},{_reference:'" + prefix + "any'}]}");
        }
    }

    protected boolean extractXSResult(Element elem, String attribute) {
        return "true" == elem.getAttribute(attribute) || "1" == elem.getAttribute(attribute);
    }

    public static final void main(String[] argv) throws Exception {
        QueryBuidlerServiceMetatData out = new QueryBuidlerServiceMetatData();
        out.setIdResolver(new SessionResolveFixedTreeIDs());
        HashMap<String, String> input = new HashMap<String, String>();
        input.put(MDREPR, "tests");
        MapParameterImpl param = new MapParameterImpl(input);
        PrintWriter ps = new PrintWriter(System.out);
        out.render(ps, param);
        ps.flush();
    }
}

