/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.reference;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.eclipse.cosmos.rm.internal.validation.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.reference.BadContextException;
import org.eclipse.cosmos.rm.internal.validation.reference.BadExpressionException;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.eclipse.cosmos.rm.internal.validation.reference.XPointer;
import org.eclipse.cosmos.rm.internal.validation.reference.XPointerExpression;
import org.eclipse.cosmos.rm.internal.validation.reference.XPointerSyntaxException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerefXPathFunction
implements XPathFunction {
    public static final int ARITY = 1;
    private static DerefXPathFunction instance;
    private NamespaceContext namespaceContext;
    private Node documentNode;

    public Object evaluate(List arguments) throws XPathFunctionException {
        if (arguments == null || arguments.size() <= 0) {
            throw new XPathFunctionException(SMLValidationMessages.errorInvalidArgument);
        }
        ArrayNodeList result = new ArrayNodeList();
        if (arguments.get(0) instanceof String) {
            int i = 0;
            int argCount = arguments.size();
            while (i < argCount) {
                this.evaluateExpression(result, SMLValidatorUtil.removeLineBreaks((String)arguments.get(i)), null);
                ++i;
            }
            return result;
        }
        SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, "org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
        if (identity == null) {
            throw new XPathFunctionException(SMLValidationMessages.errorMissingStructure);
        }
        NodeList nodeList = null;
        nodeList = (NodeList)arguments.get(0);
        if (nodeList.getLength() <= 0) {
            throw new XPathFunctionException(SMLValidationMessages.errorInvalidArgument);
        }
        int i = 0;
        int nodeCount = nodeList.getLength();
        while (i < nodeCount) {
            int[] indices;
            Node node;
            Node currentNode = nodeList.item(i);
            if (this.documentNode != null && (node = SMLValidatorUtil.findNode(this.documentNode, indices = this.findIndex(currentNode))) != null && node.getNamespaceURI().equals(currentNode.getNamespaceURI()) && node.getLocalName().equals(currentNode.getLocalName())) {
                currentNode = node;
            }
            String localName = currentNode.getLocalName();
            String uri = currentNode.getNamespaceURI();
            String string = uri = uri == null ? "" : uri;
            if (localName == null) {
                throw new XPathFunctionException(SMLValidationMessages.errorDetermineName);
            }
            if (!SMLValidatorUtil.isReference(currentNode)) {
                throw new XPathFunctionException(NLS.bind((String)SMLValidationMessages.errorWrongType, (Object)localName));
            }
            if (!SMLValidatorUtil.isNullified(currentNode)) {
                NodeList currentChildNodes = currentNode.getChildNodes();
                if (nodeList != null) {
                    ArrayList<StringBuffer> expressions = new ArrayList<StringBuffer>();
                    int j = 0;
                    int childNodeCount = currentChildNodes.getLength();
                    while (j < childNodeCount) {
                        Node currentChildNode = currentChildNodes.item(j);
                        if ("http://www.w3.org/ns/sml".equals(currentChildNode.getNamespaceURI()) && "uri".equals(currentChildNode.getLocalName())) {
                            NodeList uriNodes = currentChildNode.getChildNodes();
                            StringBuffer expression = new StringBuffer();
                            int k = 0;
                            int uriNodeCount = uriNodes.getLength();
                            while (k < uriNodeCount) {
                                Node uriNode = uriNodes.item(k);
                                if (3 == uriNode.getNodeType() && uriNode.getNodeValue() != null) {
                                    expression.append(SMLValidatorUtil.removeLineBreaks(uriNode.getNodeValue(), false));
                                }
                                ++k;
                            }
                            if (expression.length() > 0) {
                                expressions.add(expression);
                            }
                        }
                        ++j;
                    }
                    ArrayNodeList previousResult = new ArrayNodeList();
                    int j2 = 0;
                    int expressionCount = expressions.size();
                    while (j2 < expressionCount) {
                        ArrayNodeList currentResult = new ArrayNodeList();
                        this.evaluateExpression(currentResult, ((StringBuffer)expressions.get(j2)).toString(), currentNode);
                        if (j2 != 0 && !previousResult.equals(currentResult)) {
                            throw new XPathFunctionException(NLS.bind((String)SMLValidationMessages.errorInconsistentReference, (Object[])new String[]{((StringBuffer)expressions.get(j2 - 1)).toString(), ((StringBuffer)expressions.get(j2)).toString()}));
                        }
                        previousResult = currentResult;
                        ++j2;
                    }
                    j2 = 0;
                    int itemCount = previousResult.getLength();
                    while (j2 < itemCount) {
                        result.add((Node)previousResult.get(j2));
                        ++j2;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private void evaluateExpression(ArrayNodeList result, String referenceExp, Node contextNode) throws XPathFunctionException {
        Exception exception = null;
        if (referenceExp == null || referenceExp.length() <= 0) {
            return;
        }
        try {
            Node docNode = this.documentNode == null ? (contextNode == null ? null : contextNode.getOwnerDocument().getDocumentElement()) : this.documentNode;
            SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, "org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            URIReference uriReference = new URIReference(docNode, referenceExp, identity.convertBaseURI());
            Node context = uriReference.retrieveDocumentDOM();
            if (context == null) {
                return;
            }
            String fragmentExpression = uriReference.getFragment();
            if (fragmentExpression == null) {
                result.add(context);
                return;
            }
            XPointerExpression xpointerExpression = XPointer.compile(fragmentExpression);
            if (this.getNamespaceContext() == null && this.documentNode != null && contextNode != null) {
                int[] nodeIndex = this.findIndex(contextNode);
                this.setNamespaceContext(SMLValidatorUtil.buildNamespaceContext(this.documentNode, nodeIndex));
            }
            result.add(xpointerExpression.evaluate(this.getNamespaceContext(), context));
        }
        catch (XPointerSyntaxException e) {
            exception = e;
        }
        catch (URISyntaxException e) {
            exception = e;
        }
        catch (BadContextException e) {
            exception = e;
        }
        catch (BadExpressionException e) {
            exception = e;
        }
        if (exception != null) {
            throw new XPathFunctionException(exception);
        }
    }

    private int[] findIndex(Node node) {
        ArrayList<Integer> index = new ArrayList<Integer>();
        this.findIndex(index, node);
        int[] result = new int[index.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)index.get(i);
            ++i;
        }
        return result;
    }

    private void findIndex(List<Integer> indices, Node node) {
        Node parentNode = node.getParentNode();
        if (parentNode.getNodeType() != 1) {
            indices.add(0, 0);
            return;
        }
        NodeList children = parentNode.getChildNodes();
        int index = 0;
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (node.equals(child)) {
                indices.add(0, index);
                break;
            }
            if (child.getNodeType() == 1) {
                ++index;
            }
            ++i;
        }
        this.findIndex(indices, parentNode);
    }

    public Object evaluate(Node context, String reference, URI baseURI) throws XPathFunctionException {
        Node documentNode;
        URIReference uriReference;
        Exception exception;
        block10: {
            SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, "org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            if (identity == null) {
                throw new XPathFunctionException(SMLValidationMessages.errorMissingStructure);
            }
            exception = null;
            if (reference == null) {
                return null;
            }
            uriReference = new URIReference(context, reference, identity.convertBaseURI());
            documentNode = uriReference.retrieveDocumentDOM();
            if (documentNode != null) break block10;
            return null;
        }
        try {
            String fragmentExpression = uriReference.getFragment();
            if (fragmentExpression == null) {
                return documentNode;
            }
            XPointerExpression xpointerExpression = XPointer.compile(fragmentExpression);
            return xpointerExpression.evaluate(this.getNamespaceContext(), documentNode);
        }
        catch (XPointerSyntaxException e) {
            exception = e;
        }
        catch (URISyntaxException e) {
            exception = e;
        }
        catch (BadContextException e) {
            exception = e;
        }
        catch (BadExpressionException e) {
            exception = e;
        }
        if (exception != null) {
            throw new XPathFunctionException(exception);
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public static DerefXPathFunction instance() {
        if (instance == null) {
            instance = new DerefXPathFunction();
        }
        instance.setNamespaceContext(null);
        return instance;
    }

    public Node getDocumentNode() {
        return this.documentNode;
    }

    public void setDocumentNode(Node documentNode) {
        this.documentNode = documentNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayNodeList
    extends ArrayList<Node>
    implements NodeList {
        private static final long serialVersionUID = 7992097730072474662L;

        private ArrayNodeList() {
        }

        @Override
        public int getLength() {
            return super.size();
        }

        @Override
        public Node item(int index) {
            return (Node)super.get(index);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            ArrayNodeList other = null;
            if (!(o instanceof ArrayNodeList) || (other = (ArrayNodeList)o).getLength() != this.getLength()) {
                return false;
            }
            int i = 0;
            int size = this.getLength();
            while (i < size) {
                if (!this.item(i).equals(other.item(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

