/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.core;

/**
 * The implementation of this interface will provide the scheme to validate the 
 * SML extensions that the standards adds for reference and identitify constraints.
 * Clients are encouraged to extend {@link AbstractSMLValidator} instead of 
 * providing an implementation for this interface.
 * 
 * @see AbstractSMLValidator
 * @author Ali Mehregani
 */
public interface ISMLValidator extends IValidator
{
	/**
	 * The acyclic scope
	 */
	public static final String SCOPE_ACYCLIC = "sml:acyclic";
	
	/**
	 * The target element scope
	 */
	public static final String SCOPE_TARGET_ELEMENT = "sml:targetElement";
	
	/**
	 * The target type scope
	 */
	public static final String SCOPE_TARGET_TYPE = "sml:targetType";
	
	/**
	 * The key scope
	 */
	public static final String SCOPE_KEY = "sml:key";
	
	/**
	 * The unique scope
	 */
	public static final String SCOPE_UNIQUE = "sml:unique";
	
	/**
	 * The keyref scope
	 */
	public static final String SCOPE_KEY_REF = "sml:keyref";
	
	/**
	 * Groups all extensions into one group
	 */
	public static final String[] SCOPE_GRP_ALL = new String[]
	{
		ISMLValidator.SCOPE_ACYCLIC,
		ISMLValidator.SCOPE_TARGET_ELEMENT,
		ISMLValidator.SCOPE_TARGET_TYPE,
		ISMLValidator.SCOPE_KEY,
		ISMLValidator.SCOPE_KEY_REF,
		ISMLValidator.SCOPE_UNIQUE
	};
	
	/**
	 * Groups the reference constraints
	 */
	public static final String[] SCOPE_GRP_REF_CONSTRAINTS = new String[]
	{
		ISMLValidator.SCOPE_ACYCLIC,
		ISMLValidator.SCOPE_TARGET_ELEMENT,
		ISMLValidator.SCOPE_TARGET_TYPE,
	};

	/**
	 * Groups the identity constraints
	 */
	public static final String[] SCOPE_GRP_ID_CONSTRAINTS = new String[]
	{
		ISMLValidator.SCOPE_KEY,
		ISMLValidator.SCOPE_KEY_REF,
		ISMLValidator.SCOPE_UNIQUE
	};

	
	/**
	 * Retrieve the scope of the validation.  See the SCOPE_* constants
	 * defined.
	 * 
	 * @return The scope of the validation class
	 */
	public String[] getScope();
	
	
	/**
	 * Set the scope for this validation.  See the SCOPE_* constants
	 * defined.
	 *  
	 * @param scope The scope of the validation
	 */
	public void setScope(String[] scope);	
}
