/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.application;

/**
 * The base API used by the elements of the data center model
 * 
 * @author Ali Mehregani
 */
public interface ISMLResourceBase
{
	/**
	 * Indicates whether this item is a reference or not
	 * 
	 * @return true if this item is a reference; false otherwise
	 */
    public boolean isReference();
    
    
    /**
     * Retrieves and returns the name of this item
     * 
     * @return The name of this item
     */
    public String retrieveName();
    
    
    /**
     * Retrieves and returns the display name of this item
     * 
     * @return The display name of this item
     */
    public String retrieveDisplayName();
    
    
    /**
     * Retrieves and returns the description of this item
     * 
     * @return The description of this item
     */
    public String retrieveDescription();
}
