/**********************************************************************
 * Copyright (c) 2007 IBM Corporation
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * Declares the CMDBf constants
 * 
 * @author Ali Mehregani
 */
public class CMDBfConstants
{
	/**
	 * The MDR ID of the SML repository
	 */
	public static final String REPOSITORY_MDRID = "http://cosmos.org/rm/sml/repository";
	
	
	/**
	 * The MDR ID of the SML repository in the form of an URI
	 */
	public static URI REPOSITORY_MDRID_URI;
	
	static
	{
		try
		{
			REPOSITORY_MDRID_URI = new URI(REPOSITORY_MDRID);
		} 
		catch (URISyntaxException e)
		{
			// Will not happen
		}
	}
	
	
	/**
	 * Key used to retrieve the SML repository
	 */
	public static final String DATA_PROVIDER = "org.eclipse.cosmos.rm.internal.repository.operations.cmdbf.DATA_PROVIDER";
}
