/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfMessages;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLMetadata;

/**
 * The item instance id constraint handler for the SML repository
 * 
 * @author Ali Mehregani
 */
public class ItemInstanceHandler extends AbstractSMLConstraintHandler
{
	/** 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl.AbstractItemConstraintHandler#handle(org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes, org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IConstraint)
	 */
	public INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException
	{
		IInstanceIdConstraint instanceConstraint = (IInstanceIdConstraint)constraint;
		INodes result = QueryOutputArtifactFactory.getInstance().createNodes(context.getId());
		
		IInstanceId[] instanceIds = instanceConstraint.getInstanceIds();
		for (int i = 0; i < instanceIds.length; i++) 
		{
			// Make sure the MDR ID is the same as the SML MDR
			if (!CMDBfConstants.REPOSITORY_MDRID.equals(instanceIds[i].getMdrId().toString()))
			{
				continue;
			}
			try 
			{
				ISMLDocument[] returnedSet = getRepository().fetchDocuments(
						new SMLFileMetadata(instanceIds[i].getLocalId().toString(), 
						ISMLMetadata.DOCUMENT_TYPE_NONE,
						null, null, null));
				
				if (returnedSet != null && returnedSet.length == 1) 
				{
					result.addItem((IItemConvertible) returnedSet[0]);
				}
				
			} 
			catch (RepositoryOperationException e) 
			{
				throw new CMDBfServiceException(
						CMDBfServiceException.RECIEVER,
						CMDBfServiceException.QUERY_ERROR,
						CMDBfMessages.faultsQueryError,
						CMDBfInternalUtility.createTextNode(e.getLocalizedMessage()),
						e);
			}
		}
		return result;
	}
}
