/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import java.util.Map;

import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfMessages;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl.AbstractItemTemplateHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.rm.internal.repository.RepositoryMessages;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLMetadata;

/**
 * The item template handler
 * 
 * @author Ali Mehregani
 */
public class ItemTemplateHandler extends AbstractItemTemplateHandler
{
	@Override
	public void initialize(Map<String, Object> init) throws CMDBfServiceException
	{
		// Make sure the SML repository is included in the initialization data 
		if (!(init.get(CMDBfConstants.DATA_PROVIDER) instanceof ISMLRepository))
		{
			throw new CMDBfServiceException(
					CMDBfServiceException.RECIEVER,
					CMDBfServiceException.QUERY_ERROR,
					CMDBfMessages.faultsQueryError,
					CMDBfInternalUtility.createTextNode(RepositoryMessages.errorBadInitData));
		}
		super.initialize(init);
	}
	

	@Override
	protected void appendAllItems(INodes nodes) throws CMDBfServiceException
	{
		ISMLRepository repository = (ISMLRepository)getValue(CMDBfConstants.DATA_PROVIDER);
		try
		{
			ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(null, ISMLMetadata.DOCUMENT_TYPE_INSTANCE, null, null, null));
			if (documents != null)
			{
				for (int i = 0; i < documents.length; i++)
				{
					nodes.addItem(((SMLFileInstanceDocument)documents[i]).toItem(nodes));
				}
			}
		} 
		catch (RepositoryOperationException e)
		{
			throw new CMDBfServiceException(
					CMDBfServiceException.RECIEVER,
					CMDBfServiceException.QUERY_ERROR,
					CMDBfMessages.faultsQueryError,
					CMDBfInternalUtility.createTextNode(e.getMessage()));
		}
	}
}
