/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.impl;

import java.io.InputStream;
import java.io.Reader;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.AbstractNotificationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.ICMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.RegistrationInputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegistrationServiceOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.RegisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.TransformerException;

/**
 * This is the default implementation of {@link ICMDBfRegistrationOperation}.  Contributors
 * can choose to use this default implementation or provide a direct implementation
 * of {@link ICMDBfRegistrationOperation}.
 * 
 * 
 * @author Ali Mehregani
 */
public class CMDBfRegistrationOperation extends AbstractNotificationOperation implements ICMDBfRegistrationOperation
{
	/**
	 * The constructor
	 * 
	 * @param factory The factory class that will be used to create 
	 * registration handlers
	 */
	public CMDBfRegistrationOperation (INotificationHandlerFactory factory, IRegisterOutputArtifactFactory outputArtifactFactory)
	{
		super(factory, outputArtifactFactory);
	}

	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.ICMDBfRegistrationOperation#execute(java.io.Reader)
	 */
	public IRegisterResponse execute(Reader registration) throws CMDBfServiceException
	{	
		return execute ((Object)registration);
	}
	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.ICMDBfRegistrationOperation#execute(java.io.InputStream)
	 */
	public IRegisterResponse execute(InputStream registration) throws CMDBfServiceException
	{		
		return execute ((Object)registration);
	}
	
	
	private IRegisterResponse execute(Object registration) throws CMDBfServiceException
	{		
		try
		{
			IRegisterResponse response = (IRegisterResponse) getOutputArtifactFactory().createResponse();
			super.execute (registration instanceof Reader ? RegistrationInputTransformer.transform((Reader)registration) : RegistrationInputTransformer.transform((InputStream)registration), response, INotificationHandler.REGISTRATION);
			return response;
		}
		catch (TransformerException te)
		{
			throw new IllegalArgumentException(te);
		}
	}

	@Override
	protected IRegistrationServiceOutputArtifactFactory createArtifactFactory() {
		return RegisterOutputArtifactFactory.getInstance();
	}
}
