/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;
import java.net.URISyntaxException;

import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfMessages;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.IQueryTransformerConstants;

/**
 * A base representation of {@link IProperty}.  Clients can either
 * extend this function to implement a subset of the operators or implement
 * the interface to provide an implementation of all operators.
 * 
 * 
 * @author Ali Mehregani
 */
public class BaseProperty implements IProperty {
	/**
	 * The identifier for this property
	 */
	private IPropertyId propertyId;
	
	/**
	 * Default constructor
	 */
	public BaseProperty()
	{
		
	}
		
	/**
	 * Constructor
	 * 
	 * @param namespace The name space
	 * @param localName The local name of the property
	 */
	public BaseProperty(String namespace, String localName)
	{
		try
		{
			this.propertyId = QueryInputArtifactFactory.getInstance().createPropertyId();
			propertyId.setLocalName(localName);			
			propertyId.setNamespace(namespace == null ? new URI("") : new URI(namespace));
		} 
		catch (URISyntaxException e)
		{
			propertyId.setNamespace(null);
			e.printStackTrace();
		}		
	}
	
	/**
	 * Constructor
	 * 
	 * @param namespace
	 *            The name space
	 * @param localName
	 *            The local name of the property
	 */
	public BaseProperty(URI namespace, String localName) {
		this.propertyId = QueryInputArtifactFactory.getInstance().createPropertyId();
		propertyId.setLocalName(localName);
		propertyId.setNamespace(namespace);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#contains(java.lang.String,
	 *      boolean)
	 */
	public boolean contains(String str, boolean caseSensitive)
			throws CMDBfServiceException {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#equals(java.lang.Object,
	 *      boolean)
	 */
	public boolean equals(Object o, boolean caseSensitive)
			throws CMDBfServiceException {
		return this.equals(o);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#greater(java.lang.Object)
	 */
	public boolean greater(Object o) throws CMDBfServiceException {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#greaterOrEqual(java.lang.Object)
	 */
	public boolean greaterOrEqual(Object o) throws CMDBfServiceException {
		return greater(o) || equals(o, false);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#isNull()
	 */
	public boolean isNull() throws CMDBfServiceException {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#less(java.lang.Object)
	 */
	public boolean less(Object o) throws CMDBfServiceException {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#lessOrEqual(java.lang.Object)
	 */
	public boolean lessOrEqual(Object o) throws CMDBfServiceException {
		return less(o) || equals(o, false);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IProperty#like(java.lang.String,
	 *      boolean)
	 */
	public boolean like(String str, boolean caseSensitive) throws CMDBfServiceException {
		return false;
	}

	public IPropertyId getPropertyId() {
		return propertyId;
	}
	
	/**
	 * Set the local name for this property
	 */
	public void setPropertyId(IPropertyId propertyId) {
		this.propertyId = propertyId;
	}

	protected CMDBfServiceException propertyTypeMismatch()
	{
		return new CMDBfServiceException(
				CMDBfServiceException.SENDER,
				CMDBfServiceException.INVALID_PROPERTY_TYPE,
				CMDBfMessages.faultsQueryInvalidProperty,
				CMDBfInternalUtility.createElement(
						ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE, 
						ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.PROPERTY_NAME,
						new String[][]
						{
							new String[] {ICMDBfServicesConstants.NAMESPACE_ATTRIBUTE, getPropertyId().getNamespace().toString()},
							new String[] {ICMDBfServicesConstants.LOCAL_NAME_ATTRIBUTE, getPropertyId().getLocalName()},
						}
				));
	}
}
