/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a property identifier being added to a property subset directive
 * 
 * 
 * @author David Whiteman
 */
public interface IPropertyId extends IXMLWritable
{
	/**
	 * Answer the URI for the property's namespace
	 * 
	 * @return
	 */
	public URI getNamespace();

	/**
	 * Answer the local name for the property
	 * 
	 * @return
	 */
	public String getLocalName();

	/**
	 * Set the namespace for the property
	 * 
	 * @param createURI
	 */
	public void setNamespace(URI namespace);

	/**
	 * Set the local name for the property
	 * 
	 * @param locName
	 */
	public void setLocalName(String locName);
}
