/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.ITemplate;

/**
 * Represents a relationship template in a query construct
 * 
 * 
 * @author David Whiteman
 */
public interface IRelationshipTemplate extends ITemplate {
	/**
	 * Answer an item reference to the endpoint representing the source role of
	 * the relationship
	 * 
	 * @return
	 */
	public IRelationshipEndpoint getSourceElement();

	/**
	 * Set an item reference to the endpoint representing the source role of the
	 * relationship
	 * 
	 * @param sourceElement
	 */
	public void setSourceElement(IRelationshipEndpoint sourceElement);

	/**
	 * Answer an item reference to the endpoint representing the target role of
	 * the relationship
	 * 
	 * @return
	 */
	public IRelationshipEndpoint getTargetElement();

	/**
	 * Set an item reference to the endpoint representing the target role of the
	 * relationship
	 * 
	 * @param targetElement
	 */
	public void setTargetElement(IRelationshipEndpoint targetElement);

	/**
	 * Returns the depth limit associated with this relationship template
	 * 
	 * @return The depth limit of this relationship template or null if none is
	 *         associated
	 */
	public IDepthLimit getDepthLimit();

	/**
	 * Sets the depth limit of this relationship.
	 * 
	 * @param depthLimit A depth limit
	 */
	public void setDepthLimit(IDepthLimit depthLimit);
}
