/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents the <xpathExpression> element in the query structure
 * 
 * 
 * @author David Whiteman
 */
public interface IXPathExpression extends IConstraint, IXMLWritable
{
	/**
	 * Answer the xpath expression for the constraint
	 * 
	 * @return
	 */
	public String getExpression();

	/**
	 * Set the xpath expression for the constraint
	 * 
	 * @param xpathExpression
	 */
	public void setExpression(String expression);

	/**
	 * Answer all prefix mappings for the constraint
	 * 
	 * @return
	 */
	public IPrefixMapping[] getPrefixMappings();

	/**
	 * Add a prefix mapping to the constraint
	 * 
	 * @param mapping
	 * @return
	 */
	public boolean addPrefixMapping(IPrefixMapping mapping);
	
	/**
	 * Answer the dialect for the XPath expression
	 * 
	 * @return
	 */
	public URI getDialect();

	/**
	 * Set the URI for the XPath dialect used in this XPath expression
	 * 
	 * @param dialectUri
	 */
	public void setDialect(URI dialectUri);
}
