/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SMLImages.java,v 1.1 2008/05/14 19:26:49 dwhiteman Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.internal.smlif;

import org.eclipse.cosmos.rm.internal.smlif.editor.ImageManager;

/**
 * The images of this plug-in can be access via this image manager
 * 
 * @author Ali Mehregani
 */
public class SMLImages extends ImageManager
{
	public static final SMLImages INSTANCE = new SMLImages();
	
	/* obj16 */			
	public static final String VALIDATE							= "validate.gif";
	public static final String DEFINITIONS							= "genics.gif";
	public static final String INSTANCES							= "phenics.gif";
	public static final String DOCUMENTS						= "doc.gif";
	public static final String ELEMENT							= "element.gif";
	public static final String RESOURCE							= "resource.gif";
	public static final String PROJECT							= "project.gif";
	public static final String FOLDER							= "folder.gif";
	public static final String RULEBINDING						= "rule-binding.gif";
		
	/* lcl16 */
	public static final String ADD								= "add.gif";
	public static final String REMOVE							= "remove.gif";
	
	protected void addImages() 
	{	
		/* obj16 */		
		add(T_OBJ, VALIDATE);			
		add(T_OBJ, DEFINITIONS);			
		add(T_OBJ, INSTANCES);			
		add(T_OBJ, DOCUMENTS);	
		add(T_OBJ, ELEMENT);
		add(T_OBJ, RESOURCE);
		add(T_OBJ, PROJECT);
		add(T_OBJ, FOLDER);
		add(T_OBJ, RULEBINDING);
		
		/* lcl16 */
		add("c", T_LCL, ADD);
		add("d", T_LCL, ADD);
		
		add("c", T_LCL, REMOVE);
		add("d", T_LCL, REMOVE);
	}
}
