/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.RequiredBaseConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.VersionConstraintCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredBaseConstraintCompare {
    public static Collection<? extends RequiredBaseConstraintType> merge(List<RequiredBaseConstraintType> bc, List<RequiredBaseConstraintType> bc2) {
        Vector<RequiredBaseConstraintType> toRemove = new Vector<RequiredBaseConstraintType>();
        for (RequiredBaseConstraintType o1 : bc) {
            for (RequiredBaseConstraintType o2 : bc2) {
                if (toRemove.contains(o2) || !RequiredBaseConstraintCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = RequiredBaseConstraintCompare.merge(o1, o2);
            }
        }
        bc2.removeAll(toRemove);
        Vector<RequiredBaseConstraintType> finals = new Vector<RequiredBaseConstraintType>();
        finals.addAll(bc);
        finals.addAll(bc2);
        return finals;
    }

    protected static RequiredBaseConstraintType merge(RequiredBaseConstraintType o1, RequiredBaseConstraintType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        RequiredBaseConstraintType rc = objectFactory.createRequiredBaseConstraintType();
        rc.setDescription(DisplayTextCompare.merge(o1.getDescription(), o2.getDescription()));
        rc.setDisplayName(DisplayTextCompare.merge(o1.getDisplayName(), o2.getDisplayName()));
        rc.setId(o1.getId());
        rc.setName(StringCompare.merge(o1.getName(), o2.getName()));
        rc.setShortDescription(DisplayTextCompare.merge(o1.getShortDescription(), o2.getShortDescription()));
        rc.setTestValue(Boolean.valueOf(o1.isTestValue()));
        rc.setResourceRef(o1.getResourceRef());
        rc.setVersionConstraint(VersionConstraintCompare.merge(o1.getVersionConstraint(), o2.getVersionConstraint()));
        return rc;
    }

    protected static boolean equals(RequiredBaseConstraintType rc, RequiredBaseConstraintType rc2) {
        if (!ResourceCompare.equals((ResourceType)rc.getResourceRef(), (ResourceType)rc2.getResourceRef())) {
            return false;
        }
        return rc.isTestValue() == rc2.isTestValue();
    }
}

