/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.common.validation.plugin;

import org.eclipse.cosmos.me.sdd.common.validation.SDDManager;
import org.eclipse.cosmos.me.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.sdd.common.validation.ValidationFactory;
import org.eclipse.cosmos.me.sdd.common.validation.XML_DAS;

public class ValidationFactoryImpl implements ValidationFactory {	
	private static ValidationFactoryImpl defaultInstance = null;
	
	public static ValidationFactory getDefaultInstance() {
		if (defaultInstance == null) {
			defaultInstance = new ValidationFactoryImpl();
		}
		
		return defaultInstance;
	}

	public SDDManager createSDDManager() {
		return new SDDManagerImpl();
	}

	public SDD_DAS createSDD_DAS() {
		return new SDD_DASImpl();
	}

	public XML_DAS createXML_DAS() {
		return new XML_DASImpl();
	}
}
