/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalDataManagerClient;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalObservation;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalTuple;
import org.eclipse.cosmos.dc.internal.stat.datamgr.common.DataSourceKeyset;
import org.eclipse.cosmos.examples.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class StatDataSourceOutputter
extends AbstractOutputter {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public void render(PrintWriter output, IParameters input) throws Exception {
        String title = input.getParameter("title");
        String prop = input.getParameter("prop");
        String eprparm = input.getParameter("epr");
        StatisticalDataManagerClient dmc = new StatisticalDataManagerClient(eprparm);
        if (prop != null && prop.equalsIgnoreCase("true")) {
            boolean err = false;
            Collection st_coll = null;
            try {
                st_coll = dmc.getStatDataForSource(title, "TomcatSet", 0, 1000);
            }
            catch (CosmosException ex) {
                err = true;
                throw new CosmosException(Messages.getString("StatDataSourceOutputter.5"), (Throwable)ex);
            }
            if (!err) {
                if (st_coll != null) {
                    Iterator I_st = st_coll.iterator();
                    output.print("[");
                    while (I_st.hasNext()) {
                        StatisticalTuple st = (StatisticalTuple)I_st.next();
                        StatisticalObservation[] so_arr = st.getObservations();
                        Date st_date = st.getTimeStamp();
                        output.print("\t[ \"Date\", '" + st_date + "'],");
                        int so_count = 0;
                        StatisticalObservation[] statisticalObservationArray = so_arr;
                        int n = so_arr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StatisticalObservation so = statisticalObservationArray[n2];
                            output.print("\t[ \"Name\", '" + so.getName() + "'],");
                            if (so.isContinuousObservation()) {
                                output.print("\t[ \"Value\", '" + so.getContinuousValue() + "']");
                            } else if (so.isIntegralObservation()) {
                                output.print("\t[ \"Value\", '" + so.getIntegralValue() + "']");
                            } else {
                                output.print("\t[ \"Value\", '" + so.getStringValue() + "']");
                            }
                            if (so_count++ < so_arr.length) {
                                output.print(",");
                            }
                            ++n2;
                        }
                        if (I_st.hasNext()) {
                            output.print(",");
                        }
                        System.out.println(st.toString());
                    }
                    output.print("]");
                } else {
                    this.logger.info((Object)Messages.getString("StatDataSourceOutputter.20"));
                }
            }
        } else {
            Collection dsk_coll = null;
            try {
                if (dmc != null) {
                    dsk_coll = dmc.getDatasourceKeyset();
                }
            }
            catch (CosmosException ex) {
                throw new CosmosException(Messages.getString("StatDataSourceOutputter.21"), (Throwable)ex);
            }
            if (dsk_coll != null) {
                Iterator I_dsk = null;
                output.print("{ identifier: \"object\",  label: \"title\",  items:[");
                I_dsk = dsk_coll.iterator();
                while (I_dsk.hasNext()) {
                    DataSourceKeyset dsk = (DataSourceKeyset)I_dsk.next();
                    output.print("{nodeClass:\"statdatasource\", title:\"" + dsk.getDataSet() + "\", datasource:\"" + dsk.getDataSet() + "\", keyset:\"" + dsk.getKeySet() + "\", epr:'" + eprparm + "', classification:\"TomcatSet\"");
                    output.print(", store:[");
                    output.print("['epr', '" + eprparm + "']");
                    output.print(",['datasource', '" + dsk.getDataSet() + "']");
                    output.print(",['keyset', '" + dsk.getKeySet() + "']");
                    output.print("]}");
                    if (!I_dsk.hasNext()) continue;
                    output.print(",");
                }
                output.print("]}");
            }
        }
    }
}

