/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.artifacts.ITemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;

/**
 * Root object of a query submitted to the query service
 * 
 * @author David Whiteman
 */
public class Query implements IQuery 
{
	private Map<String, IItemTemplate> itemTemplates; // 0 or more
	private Map<String, IRelationshipTemplate> relationshipTemplates; // 0 or more

	public Query()
	{
		itemTemplates = new HashMap<String, IItemTemplate>();
		relationshipTemplates = new HashMap<String, IRelationshipTemplate>();
	}
	
	public IItemTemplate[] getItemTemplates() 
	{
		return itemTemplates.values().toArray(new ItemTemplate[itemTemplates.size()]);
	}
	
	public IItemTemplate getItemTemplate(String id)
	{
		return itemTemplates.get(id);
	}
	
	public IRelationshipTemplate[] getRelationshipTemplates() 
	{
		return relationshipTemplates.values().toArray(new IRelationshipTemplate[relationshipTemplates.size()]);
	}

	public IRelationshipTemplate getRelationshipTemplate(String id)
	{
		return relationshipTemplates.get(id);
	}
	
	public void addItemTemplate(IItemTemplate itemTemplate) 
	{
		itemTemplates.put(itemTemplate.getId(), itemTemplate);
	}

	public void addRelationshipTemplate(IRelationshipTemplate relationshipTemplate) 
	{
		relationshipTemplates.put(relationshipTemplate.getId(), relationshipTemplate);
	}
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.QUERY_ELEMENT+" xmlns:" + ICMDBfServicesConstants.CMDBF_PREFIX_RAW +"=\""+ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE+ICMDBfServicesConstants.DOUBLE_QUOTE+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, new ArrayList<ITemplate>(itemTemplates.values()));
		CMDBfServicesUtil.outputListToXML(writer, indent+1, new ArrayList<ITemplate>(relationshipTemplates.values()));
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.QUERY_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result +
				((itemTemplates == null) ? 0 : itemTemplates.hashCode());
		result = prime *
				result +
				((relationshipTemplates == null) ? 0 : relationshipTemplates
						.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Query other = (Query) obj;
		if (itemTemplates == null) {
			if (other.itemTemplates != null)
				return false;
		} else if (!itemTemplates.equals(other.itemTemplates))
			return false;
		if (relationshipTemplates == null) {
			if (other.relationshipTemplates != null)
				return false;
		} else if (!relationshipTemplates.equals(other.relationshipTemplates))
			return false;
		return true;
	}
	
	
	public int getItemTemplateCount()
	{
		return itemTemplates.size();
	}
	
	public int getRelationshipTemplateCount()
	{
		return relationshipTemplates.size();
	}

}
