/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui.viewer;

import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.dr.internal.web.ui.ILauncher;

public class WebLauncher implements ILauncher {

	public void launchCOSMOSUI(String name, String queryService){
		try {
			
			Activator.getDefault().updateActivatorPreference();
			HashMap<String, String> map = new HashMap<String,String>();
			map.put("name", name); //$NON-NLS-1$
			map.put("queryservice", queryService); //$NON-NLS-1$
			WebViewer.display(map);
		} catch (CoreException e) {
			Activator.getDefault().getLog( ).log( e.getStatus() );
		}
	}


}
