/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui.viewer.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.servlet.http.HttpServletRequest;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SessionOutputterContextImpl;

public class WorkspaceOutputterContextImpl extends SessionOutputterContextImpl {

	public WorkspaceOutputterContextImpl(HttpServletRequest request) {
		super(request);
	}

	@Override
	public String getRealPath(String path) {
		try {
			URL propFile = getResource("/"); //$NON-NLS-1$
			return(FileLocator.toFileURL(propFile).getFile().substring(1)) + "../"+path; //$NON-NLS-1$
		} catch (MalformedURLException e) {
		} catch (IOException e) {
		}
		return super.getRealPath(path);
	}

}
