/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui.viewer.handler;

import javax.servlet.http.HttpServletRequest;

import org.eclipse.cosmos.internal.dr.drs.service.handler.common.OutputterDelegator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;

public class WorkspaceOutputterDelegator extends OutputterDelegator {

	@Override
	protected IOutputterContext createOutputterContext(HttpServletRequest req) {
		return new WorkspaceOutputterContextImpl(req);
	}

}
