/**********************************************************************
 * Copyright (c) 2008 IBM Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: DataSourceRepositoryImpl.java,v 1.1 2008/08/20 19:42:13 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;

import org.eclipse.cosmos.provisional.dr.ps.common.IConstants;

public class DataSourceRepositoryImpl {

	public static void  saveResponse(String response, String uuid, String rootDir) throws Exception{		
		String uuidDirname = rootDir+File.separator+uuid;

		File responseFile = new File(uuidDirname+"."+IConstants.RESPONSEEXT); //$NON-NLS-1$
		//create the directory if it doesn not exist
		FileWriter writer = null;
		try {
			//write query file
			writer = new FileWriter(responseFile);
			writer.write(response);
		} finally  {
			if (writer != null)
				writer.close();
		}		
	}
	
	public static void readResponse(String uuid, String rootDir, Writer response) throws Exception{
		String uuidDirname = rootDir+File.separator+uuid;

		File responseFile = new File(uuidDirname+"."+IConstants.RESPONSEEXT); //$NON-NLS-1$
		//create the directory if it doesn not exist
		FileReader reader = null;
		try {
			//write query file
			reader = new FileReader(responseFile);
			BufferedReader br = new BufferedReader(reader);
			String s;
			while((s = br.readLine()) != null) {
				response.write(s);
			}
			
		} finally  {
			if (reader != null)
				reader.close();
		}		
	}
	
	public static boolean deleteResponse(String uuid, String rootDir) throws Exception{		
		String uuidDirname = rootDir+File.separator+IConstants.RESPONSEDIR+File.separator+uuid;

		File responseFile = new File(uuidDirname+"."+IConstants.RESPONSEEXT); //$NON-NLS-1$
		return responseFile.delete();
	}	
}
