/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.eclipse.cosmos.internal.dr.ps.common.Configuration;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IStore;
import org.eclipse.cosmos.provisional.dr.ps.common.IConstants;

public class SessionOutputterContextImpl implements IOutputterContext {

	protected ServletContext context;
	protected IStore store;
	protected Locale locale;
	protected Configuration configuration;
	private static ILogger logger = LoggerWrapper.getLogger(SessionOutputterContextImpl.class);
	
	
	public SessionOutputterContextImpl(HttpServletRequest request){
		context = request.getSession().getServletContext();
		store = new SessionStoreImpl(request.getSession());
		locale = request.getLocale();
		configuration = new Configuration();
		try {
			String configPath = context.getInitParameter(IConstants.COSMOSUI_CONFIGURATION_PATH);
			if (configPath == null)
				configPath = "/config"; //$NON-NLS-1$
			
			configuration.load(getRealPath(configPath+"/configuration.properties")); //$NON-NLS-1$
		} catch (Exception e) {
			logger.error(e);
		}
		
	}
	class IteratorWrapper implements Enumeration {
		Iterator iterator;

		public IteratorWrapper(Iterator iterator) {
			this.iterator = iterator;
		}

		public boolean hasMoreElements() {
			return iterator.hasNext();
		}

		public Object nextElement() {
			return iterator.next();
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getContext(java.lang.String)
	 */
	public ServletContext getContext(String arg0) {
		return context.getContext(arg0);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getInitParameter(java.lang.String)
	 */
	public String getInitParameter(String arg0) {
		return configuration.getValue(arg0);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getInitParameterNames()
	 */
	public Enumeration getInitParameterNames() {
		return new IteratorWrapper(configuration.keySet().iterator());
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getResource(java.lang.String)
	 */
	public URL getResource(String arg0) throws MalformedURLException {
		return context.getResource(arg0);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getResourceAsStream(java.lang.String)
	 */
	public InputStream getResourceAsStream(String arg0) {
		return context.getResourceAsStream(arg0);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getResourcePaths(java.lang.String)
	 */
	public Set getResourcePaths(String arg0) {
		return context.getResourcePaths(arg0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#log(java.lang.String, java.lang.Throwable)
	 */
	public void log(String arg0, Throwable arg1) {
		context.log(arg0, arg1);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#log(java.lang.String)
	 */
	public void log(String arg0) {
		context.log(arg0);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.internal.dr.drs.service.handler.common.IOutputterContext#getRealPath(java.lang.String)
	 */
	public String getRealPath(String path) {
		return context.getRealPath(path);
	}
	public IStore getStore() {
		return store;
	}
	public Locale getLocale() {
		return locale;
	}

}
