/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;

/**
 * Abstract class providing common methods for all project config types
 * 
 * @author David Whiteman
 */
public abstract class AbstractProjectConfig implements IProjectConfig {

	private String packageName = null;
	private String name = null;
	private IProject project;

	public AbstractProjectConfig() {
		super();
	}

	public String getPackageName() {
		if (packageName == null) {
			packageName = defaultPackageName();
		}
		return packageName;
	}

	protected String defaultPackageName() {
		return Messages.projectConfigPackageNameDefault;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public String getName() {
		if (name == null) {
			name = defaultDataManagerName();
		}
		return name;
	}
	
	public abstract String getGeneratedClassName();

	public void setName(String name) {
		this.name = name;
	}

	public abstract List<String> getWsdlFilesToCopy();
	
	protected abstract String defaultDataManagerName();

	public abstract String getProjectTypeName();

	public abstract String getClassSource() throws CoreException;

	public boolean isQueryServiceConfig() {
		return false;
	}

	public boolean isRegistrationServiceConfig() {
		return false;
	}

	/**
	 * Answer the parent class from which the data manager class derives.
	 * 
	 * @return
	 */
	public String getParentClassName() {
		String fullName = getParentClassNameFull();
		return fullName.substring(fullName.lastIndexOf('.')+1);
	}

	protected abstract String getParentClassNameFull();
	
	public abstract String getServiceSpecificSource() throws CoreException;

	public void createSupportCode() throws CoreException {
		// Do nothing by default.  Override as needed.
	}

	public void setProject(IProject project) {
		this.project = project;
	}

	public IProject getProject() {
		return project;
	}
}