/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice;

import java.util.Map;

/**
 * An abstract class that implements the {@link IQueryHandler}
 * interface.
 * 
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractServiceHandler implements IQueryHandler
{
	/**
	 * The initialization data
	 */
	private Map<String, Object> init;
	
	/**
	 * The runtime options
	 */
	private Map<String, Object> runtimeOptions;
	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.ICMDBfService#initialize(org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IDataProvider)
	 */
	public void initialize(Map<String, Object> init)
	{
		this.init = init;
	}
	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler#isInitialized()
	 */
	public boolean isInitialized()
	{
		return init != null;
	}
	
	/**
	 * Returns the initialization data
	 * 
	 * @return The initialization data
	 */
	protected Map<String, Object> getInit()
	{
		return init;
	}
	
	
	/**
	 * Sets the runtime options for this handler
	 * 
	 * @param options The runtime options
	 */
	public void setRuntimeOptions(Map<String, Object> options)
	{
		this.runtimeOptions = options;
	}
	
	/**
	 * Returns the runtime options for this handler
	 * 
	 * @return The runtime options for this handler
	 */
	public Map<String, Object> getRuntimeOptions()
	{
		return runtimeOptions;
	}
}
