/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.common;

import org.w3c.dom.Node;

/**
 * A CMDBfServiceException is thrown when any of the fault conditions
 * specified in sections 4.3.3, 5.2.3, and 5.2.6 of CMDBf1.0 is reached.
 * 
 * 
 * @author Ali Mehregani
 */
public class CMDBfServiceException extends Exception
{
	/**
	 * The serial version UID
	 */
	private static final long serialVersionUID = -4615291176754188494L;
	
	/**
	 * Constants representing the fault code
	 */
	public static final int SENDER = 0x00;	
	public static final int RECIEVER = 0x01;
	
	
	/**
	 * Constants representing the fault sub-code for the 
	 * query/registration service
	 */
	public static final int UNKNOWN_TEMPLATE_ID = 0x00;
	public static final int INVALID_PROPERTY_TYPE = 0x01;
	public static final int XPATH_ERROR = 0x02;
	public static final int UNSUPPORTED_CONSTRAINT = 0x03;
	public static final int UNSUPPORTED_SELECTOR = 0x04;
	public static final int QUERY_ERROR = 0x05;
	public static final int INVALID_RECORD = 0x06;
	public static final int UNSUPPORTED_RECORD_TYPE = 0x07;
	public static final int INVALID_MDR = 0x08;
	public static final int REGISTRATION_ERROR = 0x09;
	public static final int DEREGISTRATION_ERROR = 0x10;		
	
	
	/**
	 * The fault code
	 */
	private int code;
	
	/**
	 * The fault sub-code
	 */
	private int subCode;
	
	/**
	 * Detail nodes associated with the exception
	 */
	private Node[] details;
	
	
	/**
	 * Convenience constructor
	 */
	public CMDBfServiceException()
	{
		
	}
	
	/**
	 * The constructor that should be commonly used by clients
	 * 
	 * @param code The code of the exception
	 * @param subCode The sub-code of the exception
	 * @param reason A descriptive reason for the exception
	 * @param details An nodes that should be associated with the exception
	 */
	public CMDBfServiceException(int code, int subCode, String reason, Node[] details, Throwable cause)
	{
		super(reason, cause);
		this.code = code;
		this.subCode = subCode;
		this.details = details;
	}
	
	
	public CMDBfServiceException(int code, int subCode, String reason, Node detail, Throwable cause)
	{	
		this(code, subCode, reason, detail == null ? null : new Node[]{detail}, cause);
	}

	
	public CMDBfServiceException(int code, int subCode, String reason, Throwable cause)
	{	
		this(code, subCode, reason, (Node[])null, cause);
	}
	
	
	public CMDBfServiceException(int code, int subCode, String reason, Node[] details)
	{
		this(code, subCode, reason, details, null);
	}
	
	
	public CMDBfServiceException(int code, int subCode, String reason, Node detail)
	{
		this(code, subCode, reason, detail == null ? null : new Node[]{detail}, null);
	}
	
	
	public CMDBfServiceException(int code, int subCode, String reason)
	{
		this(code, subCode, reason, (Node[]) null, null);
	}


	/**
	 * @return the code
	 */
	public int getCode()
	{
		return code;
	}


	/**
	 * @param code the code to set
	 */
	public void setCode(int code)
	{
		this.code = code;
	}


	/**
	 * @return the subCode
	 */
	public int getSubCode()
	{
		return subCode;
	}


	/**
	 * @param subCode the subCode to set
	 */
	public void setSubCode(int subCode)
	{
		this.subCode = subCode;
	}


	/**
	 * @return the details
	 */
	public Node[] getDetails()
	{
		return details;
	}


	/**
	 * @param details the details to set
	 */
	public void setDetails(Node[] details)
	{
		this.details = details;
	}	
}
