/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.text.MessageFormat;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdGetDataManagerById
extends CommandEntry {
    private String sid = null;

    CmdGetDataManagerById(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("GetDataManagerById");
        this._usage_entry = new String("USAGE_GETDMS_BYID_INFO");
    }

    public boolean validateArguments(Tokenizer st, String line) {
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_DM_ID_ERR"));
            return false;
        }
        this.sid = st.nextToken();
        return true;
    }

    public void performAction() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        DataManager dm = null;
        try {
            dm = brokerclient.getDataManagerById(this.sid);
        }
        catch (Exception e) {
            if (e.getMessage().equals("unknown")) {
                this._cli.logMessage(MessageFormat.format(Messages.getString("DMID_NOT_FOUND_ERR"), this.sid));
                return;
            }
            throw e;
        }
        this._cli.printDataManager(dm);
    }
}

