/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.CloseFilterInputStream;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LOBStateTracker;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Utils;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class ResultSet
implements java.sql.ResultSet,
ResultSetCallbackInterface {
    public Statement statement_;
    public ColumnMetaData resultSetMetaData_;
    private SqlWarning warnings_;
    public Cursor cursor_;
    private LOBStateTracker lobState = null;
    protected Agent agent_;
    public Section generatedSection_ = null;
    private CloseFilterInputStream is_;
    public final Connection connection_;
    public static final int scrollOrientation_relative__ = 1;
    public static final int scrollOrientation_absolute__ = 2;
    public static final int scrollOrientation_after__ = 3;
    public static final int scrollOrientation_before__ = 4;
    public static final int scrollOrientation_prior__ = 5;
    public static final int scrollOrientation_first__ = 6;
    public static final int scrollOrientation_last__ = 7;
    public static final int scrollOrientation_current__ = 8;
    public static final int scrollOrientation_next__ = 0;
    public static final int updatability_unknown__ = 0;
    public static final int updatability_readOnly__ = 1;
    public static final int updatability_delete__ = 2;
    public static final int updatability_update__ = 4;
    public static final int sensitivity_unknown__ = 0;
    public static final int sensitivity_insensitive__ = 1;
    public static final int sensitivity_sensitive_static__ = 2;
    public static final int sensitivity_sensitive_dynamic__ = 3;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;
    public static final int NEXT_ROWSET = 1;
    public static final int PREVIOUS_ROWSET = 2;
    public static final int ABSOLUTE_ROWSET = 3;
    public static final int FIRST_ROWSET = 4;
    public static final int LAST_ROWSET = 5;
    public static final int RELATIVE_ROWSET = 6;
    public static final int REFRESH_ROWSET = 7;
    public static final byte DDM_RETURN_CALLER = 1;
    public static final byte DDM_RETURN_CLIENT = 2;
    private int wasNull_ = 0;
    protected byte rsReturnability_ = (byte)2;
    boolean openOnClient_ = true;
    public boolean openOnServer_ = true;
    public Sqlca queryTerminatingSqlca_;
    boolean autoCommitted_ = false;
    public boolean isValidCursorPosition_ = false;
    public boolean cursorHold_;
    public long queryInstanceIdentifier_ = 0L;
    public int resultSetType_;
    public int resultSetConcurrency_;
    public int resultSetHoldability_;
    public boolean scrollable_ = false;
    public int sensitivity_;
    public boolean isRowsetCursor_ = false;
    public boolean isBeforeFirst_ = true;
    public boolean isAfterLast_ = false;
    public boolean isFirst_ = false;
    public boolean isLast_ = false;
    public boolean rowsetContainsLastRow_ = false;
    public Sqlca[] rowsetSqlca_;
    protected int suggestedFetchSize_;
    public int fetchSize_;
    public int fetchDirection_;
    public long rowCount_ = -1L;
    protected long absolutePosition_ = 0L;
    protected long firstRowInRowset_ = 0L;
    protected long lastRowInRowset_ = 0L;
    protected long currentRowInRowset_ = -1L;
    protected long absoluteRowNumberForTheIntendedRow_;
    private boolean isOnInsertRow_ = false;
    protected boolean isOnCurrentRow_ = true;
    public int rowsReceivedInCurrentRowset_ = 0;
    public int rowsYetToBeReceivedForRowset_ = 0;
    private Object[] updatedColumns_;
    private boolean[] columnUpdated_;
    private PreparedStatement preparedStatementForUpdate_;
    private PreparedStatement preparedStatementForDelete_;
    private PreparedStatement preparedStatementForInsert_;
    public int nestingLevel_ = -1;
    public boolean cursorUnpositionedOnServer_ = false;
    private int maxRows_;
    private boolean[] streamUsedFlags_;
    boolean listenToUnitOfWork_ = false;

    protected ResultSet(Agent agent, Statement statement, Cursor cursor, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.agent_ = agent;
        this.statement_ = statement;
        this.connection_ = this.statement_.connection_;
        this.cursor_ = cursor;
        if (this.cursor_ != null) {
            this.cursor_.maxFieldSize_ = this.statement_.maxFieldSize_;
        }
        this.resultSetType_ = resultSetType;
        this.resultSetConcurrency_ = resultSetConcurrency;
        this.resultSetHoldability_ = resultSetHoldability;
        this.fetchDirection_ = this.statement_.fetchDirection_;
        this.suggestedFetchSize_ = this.statement_.fetchSize_;
        this.maxRows_ = this.statement_.maxRows_;
        if (this.resultSetType_ < this.statement_.resultSetType_) {
            this.statement_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J08"), (Object)new Integer(this.statement_.resultSetType_), new Integer(this.resultSetType_)));
        }
        if (this.resultSetConcurrency_ < this.statement_.resultSetConcurrency_) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J06")));
        }
        this.listenToUnitOfWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean next() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "next");
                }
                boolean isValidCursorPosition = this.nextX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "next", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    boolean nextX() throws SqlException {
        this.checkForClosedResultSet();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreams();
        if (this.resultSetType_ == 1003) {
            boolean bl = this.isValidCursorPosition_ = this.cursor_ == null ? false : this.cursor_.next();
            if (this.fetchSize_ != 0) {
                if (this.rowsYetToBeReceivedForRowset_ == 0) {
                    this.rowsYetToBeReceivedForRowset_ = this.fetchSize_;
                }
                if (this.isValidCursorPosition_) {
                    --this.rowsYetToBeReceivedForRowset_;
                }
            }
            if (!this.isValidCursorPosition_ && this.cursor_ != null || this.maxRows_ > 0 && this.cursor_.rowsRead_ > this.maxRows_) {
                this.isValidCursorPosition_ = false;
                SqlException sqlException = null;
                if (!this.openOnServer_) {
                    int sqlcode = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
                    if (sqlcode > 0 && sqlcode != 100) {
                        this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
                    } else if (sqlcode < 0) {
                        sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
                    }
                }
                try {
                    this.statement_.resultSetCommitting(this);
                }
                catch (SqlException sqle) {
                    sqlException = Utils.accumulateSQLException(sqle, sqlException);
                }
                if (sqlException != null) {
                    throw sqlException;
                }
            }
        } else {
            this.isAfterLast_ = false;
            this.isLast_ = false;
            if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ + 1L, 0)) {
                this.isValidCursorPosition_ = true;
                ++this.currentRowInRowset_;
            } else {
                this.checkAndThrowReceivedQueryTerminatingException();
                this.isValidCursorPosition_ = this.getNextRowset();
            }
            if (this.isValidCursorPosition_) {
                this.updateColumnInfoFromCache();
                this.checkRowsetSqlca();
                if (this.isBeforeFirst_) {
                    this.isFirst_ = true;
                }
                this.isBeforeFirst_ = false;
            } else {
                this.isFirst_ = false;
                return this.isValidCursorPosition_;
            }
        }
        if (!this.openOnClient_) {
            this.isValidCursorPosition_ = false;
        } else if (this.sensitivity_ != 3 && this.maxRows_ > 0 && this.firstRowInRowset_ + this.currentRowInRowset_ > (long)this.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close");
                }
                this.closeX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        this.closeCloseFilterInputStream();
        if (this.isValidCursorPosition_ && !this.isOnInsertRow_) {
            this.lobState.checkCurrentRow(this.cursor_);
        }
        this.preClose_();
        try {
            if (this.openOnServer_) {
                this.flowCloseAndAutoCommitIfNotAutoCommitted();
            } else {
                this.statement_.resultSetCommitting(this);
            }
        }
        finally {
            this.markClosed(true);
        }
        if (this.statement_.openOnClient_ && this.statement_.isCatalogQuery_) {
            this.statement_.closeX();
        }
        this.nullDataForGC();
    }

    public void nullDataForGC() {
        if (this.cursor_ != null && !this.statement_.isPreparedStatement_) {
            this.cursor_.nullDataForGC();
        }
        this.cursor_ = null;
        this.resultSetMetaData_ = null;
    }

    void flowCloseAndAutoCommitIfNotAutoCommitted() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        boolean performedAutoCommit = this.writeCloseAndAutoCommit();
        this.agent_.flow(this.statement_);
        this.readCloseAndAutoCommit(performedAutoCommit);
        this.agent_.endReadChain();
    }

    private boolean writeCloseAndAutoCommit() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.section_);
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
        return this.statement_.resultSetCommitting(this, true);
    }

    private void readCloseAndAutoCommit(boolean readAutoCommit) throws SqlException {
        this.readCursorClose_();
        if (readAutoCommit) {
            this.readAutoCommitIfNotAutoCommitted();
        }
    }

    void writeClose() throws SqlException {
        this.autoCommitted_ = false;
        if (this.generatedSection_ == null) {
            this.writeCursorClose_(this.statement_.section_);
        } else {
            this.writeCursorClose_(this.generatedSection_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readClose() throws SqlException {
        try {
            if (this.generatedSection_ == null) {
                this.readCursorClose_();
            } else {
                this.readCursorClose_();
            }
        }
        finally {
            this.markClosed();
        }
    }

    private void writeAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.writeAutoCommit();
        }
    }

    private void readAutoCommitIfNotAutoCommitted() throws SqlException {
        if (this.connection_.autoCommit_ && !this.autoCommitted_) {
            this.connection_.readAutoCommit();
            this.markAutoCommitted();
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull");
            }
            this.checkForClosedResultSet();
            if (this.wasNull_ == 0) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"));
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", this.wasNull_ == 1);
            }
            return this.wasNull_ == 1;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean getBoolean(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", column);
            }
            this.checkGetterPreconditions(column);
            boolean result = false;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? false : this.agent_.crossConverters_.setBooleanFromObject(this.updatedColumns_[column - 1], this.resultSetMetaData_.types_[column - 1]);
            } else {
                boolean bl = result = this.isNull(column) ? false : this.cursor_.getBoolean(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBoolean", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public byte getByte(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getByte", column);
            }
            this.checkGetterPreconditions(column);
            byte result = 0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? (byte)0 : this.agent_.crossConverters_.setByteFromObject(this.updatedColumns_[column - 1], this.resultSetMetaData_.types_[column - 1]);
            } else {
                byte by = result = this.isNull(column) ? (byte)0 : this.cursor_.getByte(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getByte", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public short getShort(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getShort", column);
            }
            this.checkGetterPreconditions(column);
            short result = 0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? (short)0 : (Short)this.agent_.crossConverters_.setObject(5, this.updatedColumns_[column - 1]);
            } else {
                short s = result = this.isNull(column) ? (short)0 : this.cursor_.getShort(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getShort", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getInt(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getInt", column);
            }
            this.checkGetterPreconditions(column);
            int result = 0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0 : (Integer)this.agent_.crossConverters_.setObject(4, this.updatedColumns_[column - 1]);
            } else {
                int n = result = this.isNull(column) ? 0 : this.cursor_.getInt(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getInt", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public long getLong(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getLong", column);
            }
            this.checkGetterPreconditions(column);
            long result = 0L;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0L : (Long)this.agent_.crossConverters_.setObject(-5, this.updatedColumns_[column - 1]);
            } else {
                long l = result = this.isNull(column) ? 0L : this.cursor_.getLong(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getLong", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public float getFloat(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getFloat", column);
            }
            this.checkGetterPreconditions(column);
            float result = 0.0f;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0.0f : ((Float)this.agent_.crossConverters_.setObject(7, this.updatedColumns_[column - 1])).floatValue();
            } else {
                float f = result = this.isNull(column) ? 0.0f : this.cursor_.getFloat(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFloat", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public double getDouble(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDouble", column);
            }
            this.checkGetterPreconditions(column);
            double result = 0.0;
            if (this.wasNonNullSensitiveUpdate(column) || this.isOnInsertRow_) {
                result = this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 0.0 : (Double)this.agent_.crossConverters_.setObject(8, this.updatedColumns_[column - 1]);
            } else {
                double d = result = this.isNull(column) ? 0.0 : this.cursor_.getDouble(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDouble", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", column, scale);
            }
            this.checkGetterPreconditions(column);
            BigDecimal result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = ((BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[column - 1])).setScale(scale, 1);
            } else {
                BigDecimal bigDecimal = result = this.isNull(column) ? null : this.cursor_.getBigDecimal(column).setScale(scale, 1);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getBigDecimal", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", column);
            }
            this.checkGetterPreconditions(column);
            BigDecimal result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (BigDecimal)this.agent_.crossConverters_.setObject(3, this.updatedColumns_[column - 1]);
            } else {
                BigDecimal bigDecimal = result = this.isNull(column) ? null : this.cursor_.getBigDecimal(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Date getDate(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", column);
            }
            this.checkGetterPreconditions(column);
            Date result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Date)this.agent_.crossConverters_.setObject(91, this.updatedColumns_[column - 1]);
            } else {
                Date date = result = this.isNull(column) ? null : this.cursor_.getDate(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Date getDate(int column, Calendar calendar) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", column, (Object)calendar);
            }
            Date date = this.getDate(column);
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"));
            }
            if (date != null) {
                Calendar targetCalendar = Calendar.getInstance(calendar.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(date);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(date);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                date.setTime(date.getTime() - timeZoneOffset);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
            }
            return date;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Time getTime(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", column);
            }
            this.checkGetterPreconditions(column);
            Time result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Time)this.agent_.crossConverters_.setObject(92, this.updatedColumns_[column - 1]);
            } else {
                Time time = result = this.isNull(column) ? null : this.cursor_.getTime(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Time getTime(int column, Calendar calendar) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", column, (Object)calendar);
            }
            Time time = this.getTime(column);
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"));
            }
            if (time != null) {
                Calendar targetCalendar = Calendar.getInstance(calendar.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(time);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(time);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                time.setTime(time.getTime() - timeZoneOffset);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
            }
            return time;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Timestamp getTimestamp(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", column);
            }
            this.checkGetterPreconditions(column);
            Timestamp result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (Timestamp)this.agent_.crossConverters_.setObject(93, this.updatedColumns_[column - 1]);
            } else {
                Timestamp timestamp = result = this.isNull(column) ? null : this.cursor_.getTimestamp(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Timestamp getTimestamp(int column, Calendar calendar) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", column, (Object)calendar);
            }
            Timestamp timestamp = this.getTimestamp(column);
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"));
            }
            if (timestamp != null) {
                int nano = timestamp.getNanos();
                Calendar targetCalendar = Calendar.getInstance(calendar.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(timestamp);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(timestamp);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                timestamp.setTime(timestamp.getTime() - timeZoneOffset);
                timestamp.setNanos(nano);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
            }
            return timestamp;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public String getString(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getString", column);
            }
            this.checkGetterPreconditions(column);
            String result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[column - 1]);
            } else {
                String string = result = this.isNull(column) ? null : this.cursor_.getString(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getString", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public byte[] getBytes(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBytes", column);
            }
            this.checkGetterPreconditions(column);
            byte[] result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[column - 1]);
            } else {
                byte[] byArray = result = this.isNull(column) ? null : this.cursor_.getBytes(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBytes", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public InputStream getBinaryStream(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBinaryStream", column);
            }
            this.checkGetterPreconditions(column);
            this.useStream(column);
            InputStream result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = new ByteArrayInputStream((byte[])this.agent_.crossConverters_.setObject(-2, this.updatedColumns_[column - 1]));
            } else {
                InputStream inputStream = result = this.isNull(column) ? null : this.cursor_.getBinaryStream(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBinaryStream", result);
            }
            this.setWasNull(column);
            return this.createCloseFilterInputStream(result);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public InputStream getAsciiStream(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getAsciiStream", column);
            }
            this.checkGetterPreconditions(column);
            this.useStream(column);
            InputStream result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = new AsciiStream((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[column - 1]));
            } else {
                InputStream inputStream = result = this.isNull(column) ? null : this.cursor_.getAsciiStream(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", result);
            }
            this.setWasNull(column);
            return this.createCloseFilterInputStream(result);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public InputStream getUnicodeStream(int column) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getUnicodeStream", column);
        }
        throw SQLExceptionFactory.notImplemented("getUnicodeStream");
    }

    public Reader getCharacterStream(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", column);
            }
            this.checkGetterPreconditions(column);
            this.useStream(column);
            Reader result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = new StringReader((String)this.agent_.crossConverters_.setObject(1, this.updatedColumns_[column - 1]));
            } else {
                Reader reader = result = this.isNull(column) ? null : this.cursor_.getCharacterStream(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public java.sql.Blob getBlob(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBlob", column);
            }
            this.checkGetterPreconditions(column);
            java.sql.Blob result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (java.sql.Blob)this.agent_.crossConverters_.setObject(2004, this.updatedColumns_[column - 1]);
            } else {
                java.sql.Blob blob = result = this.isNull(column) ? null : this.cursor_.getBlob(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBlob", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public java.sql.Clob getClob(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getClob", column);
            }
            this.checkGetterPreconditions(column);
            java.sql.Clob result = null;
            if (this.wasNonNullSensitiveUpdate(column)) {
                result = (java.sql.Clob)this.agent_.crossConverters_.setObject(2005, this.updatedColumns_[column - 1]);
            } else {
                java.sql.Clob clob = result = this.isNull(column) ? null : this.cursor_.getClob(column);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getClob", result);
            }
            this.setWasNull(column);
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Ref getRef(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getRef", column);
            }
            this.checkGetterPreconditions(column);
            Ref result = this.isNull(column) ? null : this.cursor_.getRef(column);
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Array getArray(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getArray", column);
            }
            this.checkGetterPreconditions(column);
            Array result = this.isNull(column) ? null : this.cursor_.getArray(column);
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Object getObject(int column) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getObject", column);
            }
            Object result = this.getObjectX(column);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getObject", result);
            }
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    Object getObjectX(int column) throws SqlException {
        this.checkGetterPreconditions(column);
        Object result = null;
        result = this.wasNonNullSensitiveUpdate(column) ? this.updatedColumns_[column - 1] : (this.isNull(column) ? null : this.cursor_.getObject(column));
        this.setWasNull(column);
        return result;
    }

    public Object getObject(int column, Map map) throws SQLException {
        try {
            this.closeCloseFilterInputStream();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getObject", column, (Object)map);
            }
            this.checkGetterPreconditions(column);
            Object result = null;
            result = this.wasNonNullSensitiveUpdate(column) ? this.updatedColumns_[column - 1] : (this.isNull(column) ? null : this.cursor_.getObject(column));
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean wasNonNullSensitiveUpdate(int column) {
        return this.updatedColumns_ != null && this.updatedColumns_[column - 1] != null;
    }

    private boolean wasNullSensitiveUpdate(int column) {
        return this.updatedColumns_ != null && this.updatedColumns_[column - 1] == null && this.columnUpdated_[column - 1];
    }

    private void setWasNull(int column) {
        this.wasNull_ = this.wasNullSensitiveUpdate(column) || this.isOnInsertRow_ && this.updatedColumns_[column - 1] == null ? 1 : (this.cursor_.isNull_ == null || this.cursor_.isNull_[column - 1] ? 1 : 2);
    }

    private boolean isNull(int column) {
        if (this.wasNullSensitiveUpdate(column)) {
            return true;
        }
        return this.cursor_.isUpdateDeleteHole_ || this.cursor_.isNull_[column - 1];
    }

    public final boolean getBoolean(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", columnName);
            }
            return this.getBoolean(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final byte getByte(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getByte", columnName);
            }
            return this.getByte(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final short getShort(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getShort", columnName);
            }
            return this.getShort(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final int getInt(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getInt", columnName);
            }
            return this.getInt(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final long getLong(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getLong", columnName);
            }
            return this.getLong(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final float getFloat(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getFloat", columnName);
            }
            return this.getFloat(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final double getDouble(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDouble", columnName);
            }
            return this.getDouble(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", columnName, scale);
            }
            return this.getBigDecimal(this.findColumnX(columnName), scale);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final BigDecimal getBigDecimal(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", columnName);
            }
            return this.getBigDecimal(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Date getDate(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", columnName);
            }
            return this.getDate(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Date getDate(String columnName, Calendar cal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", (Object)columnName, (Object)cal);
            }
            return this.getDate(this.findColumnX(columnName), cal);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Time getTime(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", columnName);
            }
            return this.getTime(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Time getTime(String columnName, Calendar cal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", (Object)columnName, (Object)cal);
            }
            return this.getTime(this.findColumnX(columnName), cal);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Timestamp getTimestamp(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", columnName);
            }
            return this.getTimestamp(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", (Object)columnName, (Object)cal);
            }
            return this.getTimestamp(this.findColumnX(columnName), cal);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final String getString(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getString", columnName);
            }
            return this.getString(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final byte[] getBytes(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBytes", columnName);
            }
            return this.getBytes(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final InputStream getBinaryStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBinaryStream", columnName);
            }
            return this.getBinaryStream(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final InputStream getAsciiStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getAsciiStream", columnName);
            }
            return this.getAsciiStream(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getUnicodeStream", columnName);
            }
            return this.getUnicodeStream(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Reader getCharacterStream(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", columnName);
            }
            return this.getCharacterStream(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final java.sql.Blob getBlob(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBlob", columnName);
            }
            return this.getBlob(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final java.sql.Clob getClob(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getClob", columnName);
            }
            return this.getClob(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Array getArray(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getArray", columnName);
            }
            return this.getArray(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Ref getRef(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getRef", columnName);
            }
            return this.getRef(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Object getObject(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getObject", columnName);
            }
            return this.getObject(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final Object getObject(String columnName, Map map) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getObject", (Object)columnName, (Object)map);
            }
            return this.getObject(this.findColumnX(columnName), map);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForClosedResultSet();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearWarnings() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings");
            }
            try {
                this.checkForClosedResultSet();
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    public final void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCursorName");
                }
                this.checkForClosedResultSet();
                if (this.generatedSection_ != null) {
                    return "stored procedure generated cursor:" + this.generatedSection_.getServerCursorName();
                }
                if (this.statement_.cursorName_ == null) {
                    this.statement_.cursorName_ = this.statement_.section_.getServerCursorName();
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCursorName", this.statement_.cursorName_);
                }
                return this.statement_.cursorName_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMetaData");
            }
            ColumnMetaData resultSetMetaData = this.getMetaDataX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", (Object)resultSetMetaData);
            }
            return resultSetMetaData;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    ColumnMetaData getMetaDataX() throws SqlException {
        this.checkForClosedResultSet();
        return this.resultSetMetaData_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int findColumn(String columnName) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "findColumn", columnName);
                }
                int column = this.findColumnX(columnName);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "findColumn", column);
                }
                return column;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private final int findColumnX(String columnName) throws SqlException {
        this.checkForClosedResultSet();
        return this.resultSetMetaData_.findColumnX(columnName);
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isBeforeFirst");
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            boolean isBeforeFirst = this.isBeforeFirstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isBeforeFirst", isBeforeFirst);
            }
            return isBeforeFirst;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isBeforeFirstX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isBeforeFirst_;
        }
        return this.currentRowInRowset_ == -1L && !this.resultSetContainsNoRows();
    }

    public boolean isAfterLast() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isAfterLast");
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            boolean isAfterLast = this.isAfterLastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isAfterLast", isAfterLast);
            }
            return isAfterLast;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isAfterLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isAfterLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ == this.currentRowInRowset_ && this.currentRowInRowset_ == this.lastRowInRowset_ && this.lastRowInRowset_ == 0L && this.absolutePosition_ == (this.maxRows_ == 0 ? this.rowCount_ + 1L : (long)(this.maxRows_ + 1));
    }

    public boolean isFirst() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isFirst");
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            boolean isFirst = this.isFirstX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isFirst", isFirst);
            }
            return isFirst;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isFirstX() {
        if (this.sensitivity_ == 3) {
            return this.isFirst_;
        }
        return this.firstRowInRowset_ == 1L && this.currentRowInRowset_ == 0L;
    }

    public boolean isLast() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "isLast");
            }
            this.checkForClosedResultSet();
            this.checkThatResultSetTypeIsScrollable();
            boolean isLast = this.isLastX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isLast", isLast);
            }
            return isLast;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean isLastX() throws SqlException {
        if (this.sensitivity_ == 3) {
            return this.isLast_;
        }
        return this.resultSetContainsNoRows() ? false : this.firstRowInRowset_ + this.currentRowInRowset_ == this.rowCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "beforeFirst");
                }
                this.checkForClosedResultSet();
                this.checkThatResultSetTypeIsScrollable();
                this.clearWarningsX();
                this.beforeFirstX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void beforeFirstX() throws SqlException {
        this.resetRowsetFlags();
        this.unuseStreams();
        this.moveToCurrentRowX();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServersCursorPositionBeforeFirst()) {
            this.moveToBeforeFirst();
        }
        this.isBeforeFirst_ = true;
        this.setRowsetBeforeFirstEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "afterLast");
                }
                this.checkForClosedResultSet();
                this.checkThatResultSetTypeIsScrollable();
                this.clearWarningsX();
                this.afterLastX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void afterLastX() throws SqlException {
        this.resetRowsetFlags();
        this.unuseStreams();
        this.moveToCurrentRowX();
        if (this.sensitivity_ == 3 || !this.resultSetContainsNoRows() && !this.isServerCursorPositionAfterLast()) {
            this.moveToAfterLast();
        }
        this.isAfterLast_ = true;
        this.setRowsetAfterLastEvent();
        this.cursor_.resetDataBuffer();
        this.resetRowsetSqlca();
        this.isValidCursorPosition_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "first");
                }
                boolean isValidCursorPosition = this.firstX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "first", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean firstX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreams();
        if (this.rowIsInCurrentRowset(1L, 6)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = 0L;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getFirstRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isFirst_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "last");
                }
                boolean isValidCursorPosition = this.lastX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "last", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean lastX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreams();
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        long row = this.rowCount_;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0 && this.rowCount_ > (long)this.maxRows_) {
            row = this.maxRows_;
        }
        if (this.rowIsInCurrentRowset(row, 7)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = row - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getLastRowset(row);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.isLast_ = true;
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getRow");
                }
                int row = this.getRowX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getRow", row);
                }
                return row;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private int getRowX() throws SqlException {
        long row;
        this.checkForClosedResultSet();
        this.checkThatResultSetIsNotDynamic();
        if (this.resultSetType_ == 1003) {
            row = this.cursor_.allRowsReceivedFromServer() && this.cursor_.currentRowPositionIsEqualToNextRowPosition() ? 0L : (long)this.cursor_.rowsRead_;
        } else {
            if (this.rowCountIsUnknown()) {
                this.getRowCount();
            }
            row = this.rowCount_ == 0L || this.currentRowInRowset_ < 0L ? 0L : this.firstRowInRowset_ + this.currentRowInRowset_;
        }
        if (row > Integer.MAX_VALUE) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J13"), new Long(row)));
        }
        return (int)row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int row) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "absolute", row);
                }
                boolean isValidCursorPosition = this.absoluteX(row);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "absolute", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean absoluteX(int row) throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.resetRowsetFlags();
        this.unuseStreams();
        if (this.maxRows_ > 0) {
            if (row > 0 && row > this.maxRows_) {
                this.afterLastX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            if (row <= 0 && Math.abs(row) > this.maxRows_) {
                this.beforeFirstX();
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
        }
        int fetchAbsoluteRow = 0;
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        if (this.sensitivity_ == 3) {
            fetchAbsoluteRow = row;
        } else {
            int n = fetchAbsoluteRow = row >= 0 ? row : (int)(this.rowCount_ + (long)row + 1L);
        }
        if (this.rowIsInCurrentRowset(fetchAbsoluteRow, 2)) {
            this.isValidCursorPosition_ = true;
            this.currentRowInRowset_ = (long)fetchAbsoluteRow - this.firstRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getAbsoluteRowset(fetchAbsoluteRow);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            if (row == 1) {
                this.isFirst_ = true;
            }
            if (row == -1) {
                this.isLast_ = true;
            }
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int rows) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "relative", rows);
                }
                boolean isValidCursorPosition = this.relativeX(rows);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "relative", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean relativeX(int rows) throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreams();
        if (this.resultSetContainsNoRows()) {
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (rows == 0) {
            this.isValidCursorPosition_ = this.resultSetConcurrency_ == 1008 && this.resultSetType_ == 1004 ? this.getAbsoluteRowset(this.absolutePosition_) : !this.isBeforeFirstX() && !this.isAfterLastX();
            return this.isValidCursorPosition_;
        }
        if (this.isBeforeFirstX()) {
            if (rows > 0) {
                this.nextX();
                return this.relativeX(rows - 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.isAfterLastX()) {
            if (rows < 0) {
                this.previousX();
                return this.relativeX(rows + 1);
            }
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        this.resetRowsetFlags();
        long currentAbsoluteRowNumber = this.firstRowInRowset_ + this.currentRowInRowset_;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0 && rows > 0 && currentAbsoluteRowNumber + (long)rows > (long)this.maxRows_) {
            this.afterLastX();
            this.isValidCursorPosition_ = false;
            return this.isValidCursorPosition_;
        }
        if (this.rowIsInCurrentRowset(currentAbsoluteRowNumber + (long)rows, 1)) {
            this.currentRowInRowset_ += (long)rows;
            this.isValidCursorPosition_ = true;
        } else {
            long rowNumber;
            this.checkAndThrowReceivedQueryTerminatingException();
            long l = rowNumber = this.sensitivity_ == 3 ? this.currentRowInRowset_ + (long)rows : currentAbsoluteRowNumber + (long)rows - this.absolutePosition_;
            if ((long)this.maxRows_ < Math.abs(rowNumber) && this.maxRows_ != 0) {
                if (rowNumber > 0L) {
                    this.afterLastX();
                } else {
                    this.beforeFirstX();
                }
                this.isValidCursorPosition_ = false;
                return this.isValidCursorPosition_;
            }
            this.isValidCursorPosition_ = this.getRelativeRowset(rowNumber);
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "previous");
                }
                boolean isValidCursorPosition = this.previousX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "previous", isValidCursorPosition);
                }
                return isValidCursorPosition;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean previousX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.clearWarningsX();
        this.moveToCurrentRowX();
        this.wasNull_ = 0;
        this.resetUpdatedColumns();
        this.unuseStreams();
        this.isBeforeFirst_ = false;
        this.isFirst_ = false;
        if (this.rowIsInCurrentRowset(this.firstRowInRowset_ + this.currentRowInRowset_ - 1L, 5)) {
            this.isValidCursorPosition_ = true;
            --this.currentRowInRowset_;
        } else {
            this.checkAndThrowReceivedQueryTerminatingException();
            this.isValidCursorPosition_ = this.getPreviousRowset();
        }
        if (this.isValidCursorPosition_) {
            this.updateColumnInfoFromCache();
            this.checkRowsetSqlca();
            if (this.isAfterLast_) {
                this.isLast_ = true;
            }
        } else {
            return this.isValidCursorPosition_;
        }
        this.isAfterLast_ = false;
        if (this.sensitivity_ != 3 && this.maxRows_ > 0 && this.firstRowInRowset_ + this.currentRowInRowset_ > (long)this.maxRows_) {
            this.isValidCursorPosition_ = false;
        }
        return this.isValidCursorPosition_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFetchDirection", direction);
                }
                this.checkForClosedResultSet();
                this.checkThatResultSetTypeIsScrollable();
                switch (direction) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = direction;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), new Integer(direction));
                    }
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedResultSet();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFetchSize", rows);
                }
                this.checkForClosedResultSet();
                if (rows < 0 || this.maxRows_ != 0 && rows > this.maxRows_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ062.S"), new Integer(rows)).getSQLException();
                }
                this.setFetchSize_(rows);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            this.checkForClosedResultSet();
            return this.suggestedFetchSize_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getType() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getType", this.resultSetType_);
            }
            this.checkForClosedResultSet();
            return this.resultSetType_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConcurrency", this.resultSetConcurrency_);
            }
            this.checkForClosedResultSet();
            return this.resultSetConcurrency_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            this.checkForClosedResultSet();
            this.checkPositionedOnPlainRow();
            boolean rowUpdated = this.cursor_.getIsRowUpdated();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowUpdated", rowUpdated);
            }
            return rowUpdated;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            this.checkForClosedResultSet();
            this.checkPositionedOnPlainRow();
            boolean rowInserted = false;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowInserted", rowInserted);
            }
            return rowInserted;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            boolean rowDeleted;
            this.checkForClosedResultSet();
            this.checkPositionedOnPlainRow();
            boolean bl = rowDeleted = this.resultSetType_ == 1004 ? this.cursor_.getIsUpdateDeleteHole() : false;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "rowDeleted", rowDeleted);
            }
            return rowDeleted;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int column) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateNull", column);
                }
                this.checkUpdatePreconditions(column, "updateNull");
                if (!this.resultSetMetaData_.nullable_[column - 1]) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("23502"), new Integer(column));
                }
                this.updateColumn(column, null);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(int column, boolean x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateBoolean", column, x);
                }
                this.checkUpdatePreconditions(column, "updateBoolean");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(int column, byte x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateByte", column, x);
                }
                this.checkUpdatePreconditions(column, "updateByte");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int column, short x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateShort", column, x);
                }
                this.checkUpdatePreconditions(column, "updateShort");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int column, int x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateInt", column, x);
                }
                this.checkUpdatePreconditions(column, "updateInt");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(int column, long x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateLong", column, x);
                }
                this.checkUpdatePreconditions(column, "updateLong");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int column, float x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateFloat", column, x);
                }
                this.checkUpdatePreconditions(column, "updateFloat");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int column, double x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateDouble", column, x);
                }
                this.checkUpdatePreconditions(column, "updateDouble");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(int column, BigDecimal x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateBigDecimal", column, (Object)x);
                }
                this.checkUpdatePreconditions(column, "updateBigDecimal");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(int column, Date x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateDate", column, (Object)x);
                }
                this.checkUpdatePreconditions(column, "updateDate");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(int column, Time x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateTime", column, (Object)x);
                }
                this.checkUpdatePreconditions(column, "updateTime");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int column, Timestamp x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateTimestamp", column, (Object)x);
                }
                this.checkUpdatePreconditions(column, "updateTimestamp");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int column, String x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateString", column, (Object)x);
                }
                this.checkUpdatePreconditions(column, "updateString");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(int column, byte[] x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateBytes", column, x);
                }
                this.checkUpdatePreconditions(column, "updateBytes");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int column, InputStream x, int length) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "", column, (Object)x, length);
                }
                this.checkUpdatePreconditions(column, "updateBinaryStream");
                this.updateColumn(column, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[column - 1], x, length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int column, InputStream x, int length) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateAsciiStream", column, (Object)x, length);
                }
                this.checkUpdatePreconditions(column, "updateAsciiStream");
                this.updateColumn(column, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[column - 1], x, "ISO-8859-1", length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int column, Reader x, int length) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateCharacterStream", column, (Object)x, length);
                }
                this.checkUpdatePreconditions(column, "updateCharacterStream");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x, length));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int column, Object x, int scale) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateObject", column, x, scale);
                }
                this.checkUpdatePreconditions(column, "updateObject");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int column, Object x) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateObject", column, x);
                }
                this.checkUpdatePreconditions(column, "updateObject");
                this.updateColumn(column, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[column - 1], x));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public void updateNull(String columnName) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateNull", columnName);
            }
            this.updateNull(this.findColumnX(columnName));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBoolean", (Object)columnName, x);
            }
            this.updateBoolean(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateByte", (Object)columnName, x);
            }
            this.updateByte(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateShort(String columnName, short x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateShort", (Object)columnName, x);
            }
            this.updateShort(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateInt(String columnName, int x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateInt", (Object)columnName, x);
            }
            this.updateInt(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateLong(String columnName, long x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateLong", (Object)columnName, x);
            }
            this.updateLong(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateFloat", (Object)columnName, x);
            }
            this.updateFloat(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateDouble", (Object)columnName, x);
            }
            this.updateDouble(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBigDecimal", (Object)columnName, (Object)x);
            }
            this.updateBigDecimal(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateDate", (Object)columnName, (Object)x);
            }
            this.updateDate(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateTime", (Object)columnName, (Object)x);
            }
            this.updateTime(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateTimestamp", (Object)columnName, (Object)x);
            }
            this.updateTimestamp(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateString(String columnName, String x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateString", (Object)columnName, (Object)x);
            }
            this.updateString(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBytes", (Object)columnName, (Object)x);
            }
            this.updateBytes(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBinaryStream", (Object)columnName, (Object)x, length);
            }
            this.updateBinaryStream(this.findColumnX(columnName), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateAsciiStream", (Object)columnName, (Object)x, length);
            }
            this.updateAsciiStream(this.findColumnX(columnName), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateCharacterStream", (Object)columnName, (Object)x, length);
            }
            this.updateCharacterStream(this.findColumnX(columnName), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateObject", (Object)columnName, x, scale);
            }
            this.updateObject(this.findColumnX(columnName), x, scale);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateObject", (Object)columnName, x);
            }
            this.updateObject(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public void updateNClob(String columnName, Reader reader) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "insertRow");
                }
                this.insertRowX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void insertRowX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkForUpdatableResultSet("insertRow");
        if (this.isOnCurrentRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ086.S"));
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"));
        }
        this.getPreparedStatementForInsert();
        int paramNumber = 0;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            if (this.resultSetMetaData_.sqlxUpdatable_[i] != 1 || !this.columnUpdated_[i]) continue;
            ++paramNumber;
            if (this.updatedColumns_[i] == null && (this.updatedColumns_[i] != null || !this.columnUpdated_[i])) continue;
            this.preparedStatementForInsert_.setInput(paramNumber, this.updatedColumns_[i]);
        }
        this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "updateRow");
                }
                if (this.updateRowX() && this.getType() == 1003) {
                    this.isValidCursorPosition_ = false;
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRowX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkForUpdatableResultSet("updateRow");
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"));
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"));
        }
        if (this.updatedColumns_ == null) {
            return false;
        }
        boolean didAnyColumnGetUpdated = false;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            if (!this.columnUpdated_[i]) continue;
            didAnyColumnGetUpdated = true;
            break;
        }
        if (!didAnyColumnGetUpdated) {
            return false;
        }
        this.getPreparedStatementForUpdate();
        int paramNumber = 0;
        for (int i = 0; i < this.updatedColumns_.length; ++i) {
            Object originalObj;
            if (this.resultSetMetaData_.sqlxUpdatable_[i] != 1 || !this.columnUpdated_[i]) continue;
            ++paramNumber;
            if (this.updatedColumns_[i] != null || this.updatedColumns_[i] == null && this.columnUpdated_[i]) {
                this.preparedStatementForUpdate_.setInput(paramNumber, this.updatedColumns_[i]);
                continue;
            }
            try {
                originalObj = this.getObject(i + 1);
            }
            catch (SQLException se) {
                throw new SqlException(se);
            }
            if (originalObj == null) {
                this.preparedStatementForUpdate_.setInput(paramNumber, null);
                continue;
            }
            this.preparedStatementForUpdate_.setInput(paramNumber, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[i], originalObj));
        }
        try {
            if (this.isRowsetCursor_ || this.sensitivity_ == 3 || this.sensitivity_ == 2) {
                this.update();
            } else {
                this.positionToCurrentRowAndUpdate();
            }
        }
        finally {
            this.resetUpdatedColumns();
        }
        if (this.resultSetType_ == 1004 && this.preparedStatementForUpdate_.updateCount_ > 0) {
            this.getAbsoluteRowset(this.absolutePosition_);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "deleteRow");
                }
                this.deleteRowX();
                this.isValidCursorPosition_ = false;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void deleteRowX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkForUpdatableResultSet("deleteRow");
        this.resetUpdatedColumns();
        if (this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"));
        }
        if (this.preparedStatementForDelete_ == null) {
            this.getPreparedStatementForDelete();
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3 || this.sensitivity_ == 2) {
            this.delete();
        } else {
            this.positionToCurrentRowAndDelete();
        }
        if (this.resultSetType_ == 1003) {
            this.cursor_.isUpdateDeleteHole_ = true;
        } else if (this.preparedStatementForDelete_.updateCount_ > 0) {
            this.cursor_.isUpdateDeleteHoleCache_.set((int)this.currentRowInRowset_, Cursor.ROW_IS_NULL);
            this.cursor_.isUpdateDeleteHole_ = (Boolean)this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "refreshRow");
                }
                this.refreshRowX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void refreshRowX() throws SqlException {
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.checkForUpdatableResultSet("refreshRow");
        if (this.isBeforeFirstX() || this.isAfterLastX() || this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"));
        }
        if (this.resultSetType_ == 1005) {
            this.isValidCursorPosition_ = this.getRefreshRowset();
            try {
                this.cancelRowUpdates();
            }
            catch (SQLException sqle) {
                throw new SqlException(sqle);
            }
            this.unuseStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "cancelRowUpdates");
                }
                this.checkForClosedResultSet();
                this.checkForUpdatableResultSet("cancelRowUpdates");
                if (this.isOnInsertRow_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ086.S"));
                }
                if (!this.isValidCursorPosition_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"));
                }
                this.resetUpdatedColumns();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "moveToInsertRow");
                }
                this.checkForClosedResultSet();
                this.checkForUpdatableResultSet("moveToInsertRow");
                this.resetUpdatedColumnsForInsert();
                this.isOnInsertRow_ = true;
                this.isOnCurrentRow_ = false;
                this.isValidCursorPosition_ = true;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "moveToCurrentRow");
                }
                this.checkForClosedResultSet();
                this.checkForUpdatableResultSet("moveToCurrentRow");
                this.moveToCurrentRowX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void moveToCurrentRowX() throws SqlException {
        if (this.isOnInsertRow_) {
            this.resetUpdatedColumns();
            this.isOnInsertRow_ = false;
            this.isOnCurrentRow_ = true;
            if (this.currentRowInRowset_ > 0L) {
                this.updateColumnInfoFromCache();
            }
            this.isValidCursorPosition_ = true;
        }
        if (this.isValidCursorPosition_) {
            SanityManager.ASSERT(!this.isOnInsertRow_, "Cannot check current row if positioned on insert row");
            this.lobState.checkCurrentRow(this.cursor_);
        }
    }

    public java.sql.Statement getStatement() throws SQLException {
        try {
            this.checkForClosedResultSet();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getStatement", this.statement_);
        }
        if (this.statement_.getOwner() != null) {
            return this.statement_.getOwner();
        }
        return this.statement_;
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public URL getURL(String columnName) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int columnIndex, java.sql.Blob x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBlob", columnIndex, (Object)x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBlob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], x));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateBlob(String columnName, java.sql.Blob x) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBlob", columnIndex, (Object)x, (int)length);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBlob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new Blob(this.agent_, x, (int)length)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(columnName), x, length);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw this.jdbc3MethodNotSupported();
    }

    public boolean repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete() throws SqlException {
        boolean repositionedCursor = false;
        long rowToFetch = this.getRowUncast() - this.absolutePosition_;
        if (rowToFetch != 0L) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, 1, rowToFetch);
            this.absolutePosition_ += rowToFetch;
            repositionedCursor = true;
        }
        return repositionedCursor;
    }

    public void flowPositioningFetch(int scrollOrientation, int rowToFetch) throws DisconnectException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, scrollOrientation, rowToFetch);
            this.agent_.flow(this.statement_);
            this.readPositioningFetch_();
            this.agent_.endReadChain();
        }
        catch (SqlException e) {
            throw new DisconnectException(this.agent_, e);
        }
    }

    protected void positionToCurrentRowAndUpdate() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long currentRowPosRelativeToAbsoluteRowPos = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, 1, currentRowPosRelativeToAbsoluteRowPos);
        }
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writePrepare_(this.preparedStatementForUpdate_.sql_, this.preparedStatementForUpdate_.section_);
        }
        try {
            this.writeUpdateRow(false);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += currentRowPosRelativeToAbsoluteRowPos;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.readPrepare_();
        }
        this.readUpdateRow();
        this.agent_.endReadChain();
    }

    protected void insert() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        if (!this.preparedStatementForInsert_.openOnServer_) {
            this.preparedStatementForInsert_.materialPreparedStatement_.writePrepare_(this.preparedStatementForInsert_.sql_, this.preparedStatementForInsert_.section_);
        }
        try {
            this.writeInsertRow(false);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        this.agent_.flow(this.statement_);
        if (!this.preparedStatementForInsert_.openOnServer_) {
            this.preparedStatementForInsert_.materialPreparedStatement_.readPrepare_();
        }
        this.readInsertRow();
        this.agent_.endReadChain();
    }

    protected void update() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writePrepare_(this.preparedStatementForUpdate_.sql_, this.preparedStatementForUpdate_.section_);
        }
        if (this.isRowsetCursor_) {
            try {
                this.preparedStatementForUpdate_.setInt(this.updatedColumns_.length + 1, (int)(this.currentRowInRowset_ + 1L));
            }
            catch (SQLException se) {
                throw new SqlException(se);
            }
        }
        boolean chainAutoCommit = this.connection_.willAutoCommitGenerateFlow();
        try {
            this.writeUpdateRow(chainAutoCommit);
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        if (chainAutoCommit) {
            this.connection_.writeCommit();
        }
        this.agent_.flow(this.statement_);
        if (!this.preparedStatementForUpdate_.openOnServer_) {
            this.preparedStatementForUpdate_.materialPreparedStatement_.readPrepare_();
        }
        this.readUpdateRow();
        if (chainAutoCommit) {
            this.connection_.readCommit();
        }
        this.agent_.endReadChain();
    }

    protected void positionToCurrentRowAndDelete() throws SqlException {
        this.agent_.beginWriteChain(this.statement_);
        long currentRowPosRelativeToAbsoluteRowPos = this.getRowUncast() - this.absolutePosition_;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.writePositioningFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, 1, currentRowPosRelativeToAbsoluteRowPos);
        }
        if (!this.preparedStatementForDelete_.openOnServer_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.writePrepare_(this.preparedStatementForDelete_.sql_, this.preparedStatementForDelete_.section_);
        }
        try {
            this.writeDeleteRow();
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        this.agent_.flow(this.statement_);
        this.absolutePosition_ += currentRowPosRelativeToAbsoluteRowPos;
        if (this.resultSetType_ != 1003 && (currentRowPosRelativeToAbsoluteRowPos != 0L || currentRowPosRelativeToAbsoluteRowPos == 0L && this.cursorUnpositionedOnServer_)) {
            this.readPositioningFetch_();
            this.cursorUnpositionedOnServer_ = false;
            this.listenToUnitOfWork();
        }
        if (!this.preparedStatementForDelete_.openOnServer_) {
            this.preparedStatementForDelete_.materialPreparedStatement_.readPrepare_();
        }
        this.readDeleteRow();
        this.agent_.endReadChain();
    }

    protected void delete() throws SqlException {
        try {
            this.agent_.beginWriteChain(this.statement_);
            if (!this.preparedStatementForDelete_.openOnServer_) {
                this.preparedStatementForDelete_.materialPreparedStatement_.writePrepare_(this.preparedStatementForDelete_.sql_, this.preparedStatementForDelete_.section_);
            }
            if (this.isRowsetCursor_) {
                this.preparedStatementForDelete_.setInt(1, (int)(this.currentRowInRowset_ + 1L));
            }
            this.writeDeleteRow();
            if (this.connection_.autoCommit_) {
                this.connection_.writeAutoCommit();
            }
            this.agent_.flow(this.statement_);
            if (!this.preparedStatementForDelete_.openOnServer_) {
                this.preparedStatementForDelete_.materialPreparedStatement_.readPrepare_();
            }
            this.readDeleteRow();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
            this.agent_.endReadChain();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
    }

    public void setRowsetAfterLastEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = this.maxRows_ == 0 ? this.rowCount_ + 1L : (long)(this.maxRows_ + 1);
        this.currentRowInRowset_ = 0L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    public void setRowsetBeforeFirstEvent() throws SqlException {
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    public void setRowsetNoRowsEvent() {
        this.rowCount_ = 0L;
        this.firstRowInRowset_ = 0L;
        this.lastRowInRowset_ = 0L;
        this.absolutePosition_ = 0L;
        this.currentRowInRowset_ = -1L;
        this.rowsReceivedInCurrentRowset_ = 0;
    }

    private boolean isServersCursorPositionBeforeFirst() throws SqlException {
        return this.isBeforeFirstX() && this.firstRowInRowset_ == 0L && this.lastRowInRowset_ == 0L && this.absolutePosition_ == 0L;
    }

    private boolean isServerCursorPositionAfterLast() throws SqlException {
        return this.absolutePosition_ == this.rowCount_ + 1L;
    }

    public void setValidCursorPosition(boolean isValidCursorPosition) {
        this.isValidCursorPosition_ = isValidCursorPosition;
    }

    protected void moveToAfterLast() throws DisconnectException {
        this.flowPositioningFetch(3, 0);
    }

    protected void moveToBeforeFirst() throws DisconnectException {
        this.flowPositioningFetch(4, 0);
    }

    public void flowFetch() throws DisconnectException, SqlException {
        this.agent_.beginWriteChain(this.statement_);
        this.writeFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_);
        this.agent_.flow(this.statement_);
        this.readFetch_();
        this.agent_.endReadChain();
    }

    public void writeInsertRow(boolean chainedWritesFollowingSetLob) throws SQLException {
        try {
            this.preparedStatementForInsert_.materialPreparedStatement_.writeExecute_(this.preparedStatementForInsert_.section_, this.preparedStatementForInsert_.parameterMetaData_, this.preparedStatementForInsert_.parameters_, this.preparedStatementForInsert_.parameterMetaData_ == null ? 0 : this.preparedStatementForInsert_.parameterMetaData_.getColumnCount(), false, chainedWritesFollowingSetLob);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void writeUpdateRow(boolean chainedWritesFollowingSetLob) throws SQLException {
        try {
            this.preparedStatementForUpdate_.materialPreparedStatement_.writeExecute_(this.preparedStatementForUpdate_.section_, this.preparedStatementForUpdate_.parameterMetaData_, this.preparedStatementForUpdate_.parameters_, this.preparedStatementForUpdate_.parameterMetaData_.getColumnCount(), false, chainedWritesFollowingSetLob);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void writeDeleteRow() throws SQLException {
        try {
            if (this.isRowsetCursor_) {
                this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.section_, this.preparedStatementForDelete_.parameterMetaData_, this.preparedStatementForDelete_.parameters_, this.preparedStatementForDelete_.parameterMetaData_.getColumnCount(), false, false);
            } else {
                this.preparedStatementForDelete_.materialPreparedStatement_.writeExecute_(this.preparedStatementForDelete_.section_, null, null, 0, false, false);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void readInsertRow() throws DisconnectException, SqlException {
        this.preparedStatementForInsert_.materialPreparedStatement_.readExecute_();
    }

    public void readUpdateRow() throws DisconnectException, SqlException {
        this.preparedStatementForUpdate_.materialPreparedStatement_.readExecute_();
        this.accumulateWarning(this.preparedStatementForUpdate_.getSqlWarnings());
    }

    public void readDeleteRow() throws DisconnectException, SqlException {
        this.preparedStatementForDelete_.materialPreparedStatement_.readExecute_();
        this.accumulateWarning(this.preparedStatementForDelete_.getSqlWarnings());
    }

    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.put(this, null);
        }
    }

    public void completeLocalCommit(Iterator listenerIterator) {
        this.cursorUnpositionedOnServer_ = true;
        this.lobState.discardState();
        this.markAutoCommitted();
        if (!this.cursorHold_) {
            this.markClosed();
            this.nullOutReferenceInStatement();
            listenerIterator.remove();
            this.listenToUnitOfWork_ = false;
        }
    }

    public void completeLocalRollback(Iterator listenerIterator) {
        this.lobState.discardState();
        this.markAutoCommitted();
        this.markClosed();
        this.nullOutReferenceInStatement();
        listenerIterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    private void nullOutReferenceInStatement() {
        if (this.statement_.resultSet_ == this) {
            this.statement_.resultSet_ = null;
        }
        if (this.statement_.resultSetList_ != null) {
            for (int i = 0; i < this.statement_.resultSetList_.length; ++i) {
                if (this.statement_.resultSetList_[i] != this) continue;
                this.statement_.resultSetList_[i] = null;
            }
        }
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean removeListener) {
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.statement_.resetCursorNameAndRemoveFromWhereCurrentOfMappings();
        this.statement_.removeClientCursorNameFromCache();
        this.markPositionedUpdateDeletePreparedStatementsClosed();
        if (removeListener) {
            this.connection_.CommitAndRollbackListeners_.remove(this);
        }
    }

    public void markClosedOnServer() {
        this.openOnServer_ = false;
    }

    void markAutoCommitted() {
        this.autoCommitted_ = true;
    }

    public void earlyCloseComplete(Sqlca sqlca) {
        this.markClosedOnServer();
        this.queryTerminatingSqlca_ = sqlca;
        this.cursor_.setAllRowsReceivedFromServer(true);
    }

    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode == 100 || sqlcode == 20237) {
            this.cursor_.setAllRowsReceivedFromServer(true);
        } else if (sqlcode < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (sqlcode > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return sqlcode;
    }

    public void setRowCountEvent(long rowCount) throws DisconnectException {
        if (this.rowCount_ == -1L) {
            this.rowCount_ = rowCount;
        }
    }

    public void accumulateWarning(SqlWarning e) {
        if (this.warnings_ == null) {
            this.warnings_ = e;
        } else {
            this.warnings_.setNextException(e);
        }
    }

    protected boolean rowCountIsUnknown() {
        if (this.sensitivity_ == 3) {
            return false;
        }
        return this.rowCount_ == -1L;
    }

    protected boolean rowCountIsKnown() {
        return this.rowCount_ != -1L;
    }

    private void updateColumn(int column, Object value) {
        if (this.updatedColumns_ == null) {
            this.updatedColumns_ = new Object[this.resultSetMetaData_.columns_];
        }
        if (this.columnUpdated_ == null) {
            this.columnUpdated_ = new boolean[this.resultSetMetaData_.columns_];
        }
        this.updatedColumns_[column - 1] = value;
        this.columnUpdated_[column - 1] = true;
    }

    private String buildInsertString() throws SqlException {
        boolean foundOneUpdatedColumnAlready = false;
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ");
        StringBuffer valuesSQL = new StringBuffer("VALUES (");
        insertSQL.append(this.getTableName());
        insertSQL.append(" (");
        for (int column = 1; column <= this.resultSetMetaData_.columns_; ++column) {
            if (foundOneUpdatedColumnAlready) {
                insertSQL.append(",");
                valuesSQL.append(",");
            }
            try {
                insertSQL.append(this.quoteSqlIdentifier(this.resultSetMetaData_.getColumnName(column)));
            }
            catch (SQLException sqle) {
                throw new SqlException(sqle);
            }
            if (this.columnUpdated_[column - 1]) {
                valuesSQL.append("?");
            } else {
                valuesSQL.append("DEFAULT");
            }
            foundOneUpdatedColumnAlready = true;
        }
        insertSQL.append(") ");
        valuesSQL.append(") ");
        insertSQL.append(valuesSQL.toString());
        return insertSQL.toString();
    }

    private String buildUpdateString() throws SqlException {
        int numColumns = 0;
        boolean foundOneUpdatedColumnAlready = false;
        String updateString = "UPDATE " + this.getTableName() + " SET ";
        for (int column = 1; column <= this.resultSetMetaData_.columns_; ++column) {
            if (!this.columnUpdated_[column - 1]) continue;
            if (foundOneUpdatedColumnAlready) {
                updateString = updateString + ",";
            }
            try {
                updateString = updateString + this.quoteSqlIdentifier(this.resultSetMetaData_.getColumnName(column)) + " = ? ";
            }
            catch (SQLException sqle) {
                throw new SqlException(sqle);
            }
            ++numColumns;
            foundOneUpdatedColumnAlready = true;
        }
        if (!foundOneUpdatedColumnAlready) {
            return null;
        }
        updateString = updateString + " WHERE CURRENT OF " + this.getServerCursorName();
        if (this.isRowsetCursor_) {
            updateString = updateString + " FOR ROW ? OF ROWSET";
        }
        return updateString;
    }

    private String buildDeleteString() throws SqlException {
        String deleteString = "DELETE FROM ";
        deleteString = deleteString + this.getTableName() + " WHERE CURRENT OF \"" + this.getServerCursorName() + "\"";
        if (this.isRowsetCursor_) {
            deleteString = deleteString + " FOR ROW ? OF ROWSET";
        }
        return deleteString;
    }

    private String getTableName() throws SqlException {
        int baseTableColumn;
        int totalColumns;
        String tableName = "";
        try {
            totalColumns = this.resultSetMetaData_.getColumnCount();
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        for (baseTableColumn = 0; baseTableColumn < totalColumns && this.resultSetMetaData_.sqlxBasename_[baseTableColumn] == null; ++baseTableColumn) {
        }
        if (baseTableColumn == totalColumns) {
            baseTableColumn = 0;
        }
        if (this.resultSetMetaData_.sqlxSchema_[baseTableColumn] != null && !this.resultSetMetaData_.sqlxSchema_[baseTableColumn].equals("")) {
            tableName = tableName + this.quoteSqlIdentifier(this.resultSetMetaData_.sqlxSchema_[baseTableColumn]) + ".";
        }
        if (this.resultSetMetaData_.sqlxBasename_[baseTableColumn] != null) {
            tableName = tableName + this.quoteSqlIdentifier(this.resultSetMetaData_.sqlxBasename_[baseTableColumn]);
        }
        return tableName;
    }

    private String quoteSqlIdentifier(String orgValue) {
        int i = 0;
        int start = 0;
        String retValue = "";
        while ((i = orgValue.indexOf("\"", start) + 1) > 0) {
            retValue = retValue + orgValue.substring(start, i) + "\"";
            start = i;
        }
        retValue = retValue + orgValue.substring(start, orgValue.length());
        return "\"" + retValue + "\"";
    }

    private String getServerCursorName() throws SqlException {
        return this.statement_.section_.getServerCursorName();
    }

    private void getPreparedStatementForInsert() throws SqlException {
        String insertString = this.buildInsertString();
        try {
            this.preparedStatementForInsert_ = (PreparedStatement)this.statement_.connection_.prepareStatement(insertString);
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
    }

    private void getPreparedStatementForUpdate() throws SqlException {
        String updateString = this.buildUpdateString();
        if (updateString == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ122.S"));
        }
        this.preparedStatementForUpdate_ = this.statement_.connection_.preparePositionedUpdateStatement(updateString, this.statement_.section_.getPositionedUpdateSection());
    }

    private void getPreparedStatementForDelete() throws SqlException {
        String deleteString = this.buildDeleteString();
        this.preparedStatementForDelete_ = this.statement_.connection_.preparePositionedUpdateStatement(deleteString, this.statement_.section_.getPositionedUpdateSection());
    }

    private final void resetUpdatedColumnsForInsert() {
        int i;
        if (this.updatedColumns_ == null) {
            this.updatedColumns_ = new Object[this.resultSetMetaData_.columns_];
        }
        if (this.columnUpdated_ != null) {
            this.columnUpdated_ = new boolean[this.resultSetMetaData_.columns_];
        }
        for (i = 0; i < this.updatedColumns_.length; ++i) {
            this.updateColumn(i + 1, null);
        }
        for (i = 0; i < this.columnUpdated_.length; ++i) {
            this.columnUpdated_[i] = false;
        }
    }

    private final void resetUpdatedColumns() {
        int i;
        if (this.updatedColumns_ != null) {
            for (i = 0; i < this.updatedColumns_.length; ++i) {
                this.updatedColumns_[i] = null;
            }
        }
        if (this.columnUpdated_ != null) {
            for (i = 0; i < this.columnUpdated_.length; ++i) {
                this.columnUpdated_[i] = false;
            }
        }
    }

    private final long getRowUncast() {
        return this.firstRowInRowset_ + this.currentRowInRowset_;
    }

    private final void checkGetterPreconditions(int column) throws SqlException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(column);
        this.checkForValidCursorPosition();
    }

    private final void checkUpdatePreconditions(int column, String operation) throws SqlException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(column);
        this.checkForUpdatableResultSet(operation);
        if (!this.isOnCurrentRow_ && !this.isOnInsertRow_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ123.S"));
        }
        if (this.resultSetMetaData_.sqlxUpdatable_ == null || this.resultSetMetaData_.sqlxUpdatable_[column - 1] != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ124.S"));
        }
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"));
        }
    }

    final void checkForValidColumnIndex(int column) throws SqlException {
        if (column < 1 || column > this.resultSetMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL14.S"), (Object)new Integer(column), new Integer(this.resultSetMetaData_.columns_));
        }
    }

    protected final void checkForClosedResultSet() throws SqlException {
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL16.S.1"));
        }
        this.agent_.checkForDeferredExceptions();
    }

    private final void checkForUpdatableResultSet(String operation) throws SqlException {
        if (this.resultSetConcurrency_ == 1007) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ083.U"), operation);
        }
    }

    private final void checkForValidCursorPosition() throws SqlException {
        if (!this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ121.S"));
        }
    }

    private final void checkPositionedOnPlainRow() throws SqlException {
        if (this.isOnInsertRow_ || !this.isValidCursorPosition_) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("24000"));
        }
    }

    private final void checkThatResultSetTypeIsScrollable() throws SqlException {
        if (this.resultSetType_ == 1003) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ125.S"));
        }
    }

    private final void checkThatResultSetIsNotDynamic() throws SqlException {
        if (this.sensitivity_ == 3) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ126.S"));
        }
    }

    private boolean resultSetContainsNoRows() throws SqlException {
        if (this.rowCountIsUnknown()) {
            this.getRowCount();
        }
        return this.rowCount_ == 0L;
    }

    private boolean rowIsInCurrentRowset(long rowNumber, int orientation) throws SqlException {
        if (this.sensitivity_ == 3) {
            switch (orientation) {
                case 0: {
                    if (this.isAfterLast_) {
                        return false;
                    }
                    return this.currentRowInRowset_ + 1L < (long)this.rowsReceivedInCurrentRowset_;
                }
                case 5: {
                    if (this.isBeforeFirst_) {
                        return false;
                    }
                    return this.currentRowInRowset_ - 1L >= 0L;
                }
                case 1: {
                    return rowNumber < (long)this.rowsReceivedInCurrentRowset_ && rowNumber >= 0L;
                }
                case 2: 
                case 6: 
                case 7: {
                    return false;
                }
            }
            return false;
        }
        return this.rowIsInCurrentRowset(rowNumber);
    }

    private boolean rowIsInCurrentRowset(long rowNumber) throws SqlException {
        if (this.firstRowInRowset_ == this.lastRowInRowset_ && this.firstRowInRowset_ == 0L) {
            return false;
        }
        return rowNumber >= this.firstRowInRowset_ && rowNumber <= this.lastRowInRowset_;
    }

    private void markPositionedUpdateDeletePreparedStatementsClosed() {
        if (this.preparedStatementForUpdate_ != null) {
            this.preparedStatementForUpdate_.markClosed();
            this.preparedStatementForUpdate_ = null;
        }
        if (this.preparedStatementForDelete_ != null) {
            this.preparedStatementForDelete_.markClosed();
            this.preparedStatementForDelete_ = null;
        }
    }

    protected void updateColumnInfoFromCache() {
        this.cursor_.columnDataPosition_ = (int[])this.cursor_.columnDataPositionCache_.get((int)this.currentRowInRowset_);
        this.cursor_.columnDataComputedLength_ = (int[])this.cursor_.columnDataLengthCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isNull_ = (boolean[])this.cursor_.columnDataIsNullCache_.get((int)this.currentRowInRowset_);
        this.cursor_.isUpdateDeleteHole_ = (Boolean)this.cursor_.isUpdateDeleteHoleCache_.get((int)this.currentRowInRowset_);
    }

    protected final void checkAndThrowReceivedQueryTerminatingException() throws SqlException {
        if (!this.openOnServer_) {
            SqlException sqlException = null;
            int sqlcode = Utils.getSqlcodeFromSqlca(this.queryTerminatingSqlca_);
            if (sqlcode < 0) {
                sqlException = new SqlException(this.agent_.logWriter_, this.queryTerminatingSqlca_);
            } else if (sqlcode > 0 && sqlcode != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, this.queryTerminatingSqlca_));
            }
            try {
                this.closeX();
            }
            catch (SqlException e) {
                sqlException.setNextException(e);
            }
            if (sqlException != null) {
                throw sqlException;
            }
        }
    }

    public void parseScrollableRowset() throws SqlException {
        if (this.cursor_.dataBufferHasUnprocessedData() && this.scrollable_) {
            this.parseRowset_();
            this.adjustFirstRowset();
            if (this.cursor_.allRowsReceivedFromServer() && this.rowsReceivedInCurrentRowset_ == 0) {
                this.setRowsetNoRowsEvent();
            }
        }
    }

    public byte getRSReturnability() {
        return this.rsReturnability_;
    }

    public void setRSReturnability(byte rsReturnability) {
        this.rsReturnability_ = rsReturnability == 1 || rsReturnability == 2 ? rsReturnability : (byte)1;
    }

    protected void getRowCount() throws SqlException {
        this.checkAndThrowReceivedQueryTerminatingException();
        this.agent_.beginWriteChain(this.statement_);
        Section section = this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_;
        this.writePositioningFetch_(section, 3, 0L);
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.writePositioningFetch_(section, 2, this.firstRowInRowset_);
        }
        this.agent_.flow(this.statement_);
        this.readPositioningFetch_();
        if (this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L) {
            this.readPositioningFetch_();
        }
        this.agent_.endReadChain();
        if (this.rowCount_ == -1L) {
            this.checkAndThrowReceivedQueryTerminatingException();
        }
        this.absolutePosition_ = this.isRowsetCursor_ && this.sensitivity_ != 3 && this.firstRowInRowset_ != 0L ? this.firstRowInRowset_ : (this.maxRows_ == 0 ? this.rowCount_ + 1L : (long)(this.maxRows_ + 1));
    }

    private void flowGetRowset(int orientation, long rowNumber) throws SqlException {
        this.cursor_.clearLobData_();
        this.cursor_.resetDataBuffer();
        this.agent_.beginWriteChain(this.statement_);
        this.writeScrollableFetch_(this.generatedSection_ == null ? this.statement_.section_ : this.generatedSection_, this.fetchSize_, orientation, rowNumber, true);
        this.rowsReceivedInCurrentRowset_ = 0;
        this.agent_.flow(this.statement_);
        this.readScrollableFetch_();
        this.agent_.endReadChain();
    }

    private boolean getNextRowset() throws SqlException {
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            int sqlcode = this.checkRowsetSqlca((int)this.currentRowInRowset_ + 2);
            if (sqlcode == 100) {
                this.isAfterLast_ = true;
                return false;
            }
            this.flowGetRowset(0, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isAfterLastX()) {
                return false;
            }
            if (this.firstRowInRowset_ + this.currentRowInRowset_ == this.lastRowInRowset_ && this.cursor_.allRowsReceivedFromServer()) {
                this.isAfterLast_ = true;
                this.setRowsetAfterLastEvent();
                return false;
            }
            long rowNumber = 1L;
            int orientation = 1;
            if (this.absolutePosition_ < this.lastRowInRowset_) {
                rowNumber = this.lastRowInRowset_ - this.absolutePosition_ + 1L;
                this.absolutePosition_ = this.lastRowInRowset_;
            } else if (this.absolutePosition_ > this.lastRowInRowset_) {
                rowNumber = this.lastRowInRowset_ + 1L;
                orientation = 2;
            }
            this.flowGetRowset(orientation, rowNumber);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustNextRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustNextRowset() {
        this.firstRowInRowset_ = this.lastRowInRowset_ + 1L;
        this.lastRowInRowset_ += (long)this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getPreviousRowset() throws SqlException {
        int orientation = 1;
        long rowNumber = 0L;
        boolean isAfterLast = false;
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            if (this.currentRowInRowset_ == 0L && this.rowsetSqlca_ != null && this.rowsetSqlca_[0] != null && this.rowsetSqlca_[0].getSqlCode() == 20237) {
                this.isBeforeFirst_ = true;
                this.setRowsetBeforeFirstEvent();
                return false;
            }
            this.flowGetRowset(5, 0L);
        } else {
            if (this.resultSetContainsNoRows() || this.isBeforeFirstX()) {
                return false;
            }
            rowNumber = this.firstRowInRowset_ - this.absolutePosition_ - (long)this.fetchSize_;
            isAfterLast = this.isAfterLastX();
            if (this.isFirstX()) {
                rowNumber = 0L;
                orientation = 2;
            } else if (isAfterLast) {
                rowNumber = -1 * this.fetchSize_;
            }
            if (rowNumber * -1L >= this.absolutePosition_) {
                rowNumber = 1L;
                orientation = 2;
            }
            if (this.maxRows_ > 0 && orientation == 1 && isAfterLast) {
                rowNumber += (long)(this.maxRows_ + 1);
                orientation = 2;
            }
            this.flowGetRowset(orientation, rowNumber);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isBeforeFirst_ = true;
            this.setRowsetBeforeFirstEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustPreviousRowset(orientation, rowNumber, isAfterLast);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustPreviousRowset(int orientation, long rowNumber, boolean isAfterLastRow) throws SqlException {
        if (orientation == 2 && rowNumber == 1L) {
            this.currentRowInRowset_ = isAfterLastRow ? this.absolutePosition_ - 2L : this.firstRowInRowset_ - 2L;
            this.firstRowInRowset_ = 1L;
            this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
            this.absolutePosition_ = isAfterLastRow ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
        } else {
            this.lastRowInRowset_ = this.maxRows_ == 0 ? (isAfterLastRow ? this.rowCount_ : this.firstRowInRowset_ - 1L) : (isAfterLastRow ? (long)this.maxRows_ : this.firstRowInRowset_ - 1L);
            this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
            this.absolutePosition_ = this.lastRowInRowset_;
            this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
        }
    }

    private boolean getAbsoluteRowset(long row) throws SqlException {
        int orientation = 2;
        if (this.isRowsetCursor_ && row == 0L) {
            orientation = 4;
        } else if (this.sensitivity_ != 3 && row < 0L) {
            row = 0L;
        }
        this.flowGetRowset(orientation, row);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer() || orientation == 4) {
            if (row > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustAbsoluteRowset(row);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustAbsoluteRowset(long rowNumber) {
        this.firstRowInRowset_ = rowNumber;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getRelativeRowset(long rows) throws SqlException {
        if (rows == 0L && (this.cursor_.allRowsReceivedFromServer() || this.absolutePosition_ > this.rowCount_)) {
            this.setRowsetAfterLastEvent();
            this.isAfterLast_ = true;
            return false;
        }
        this.flowGetRowset(1, rows);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            if (rows > 0L) {
                this.setRowsetAfterLastEvent();
                this.isAfterLast_ = true;
            } else {
                this.setRowsetBeforeFirstEvent();
                this.isBeforeFirst_ = true;
            }
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustRelativeRowset(rows);
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustRelativeRowset(long rowNumber) {
        this.firstRowInRowset_ = this.absolutePosition_ + rowNumber;
        this.lastRowInRowset_ = this.firstRowInRowset_ + (long)this.rowsReceivedInCurrentRowset_ - 1L;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getFirstRowset() throws SqlException {
        this.flowGetRowset(2, 1L);
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.resetRowsetFlags();
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustFirstRowset();
        }
        this.currentRowInRowset_ = 0L;
        return true;
    }

    private void adjustFirstRowset() {
        this.firstRowInRowset_ = 1L;
        this.lastRowInRowset_ = this.rowsReceivedInCurrentRowset_;
        this.setAbsolutePositionBasedOnAllRowsReceived();
    }

    private boolean getLastRowset(long row) throws SqlException {
        if (this.sensitivity_ != 3 && this.rowCount_ == 0L) {
            this.isAfterLast_ = false;
            this.isBeforeFirst_ = false;
            this.setRowsetNoRowsEvent();
            return false;
        }
        if (this.isRowsetCursor_ || this.sensitivity_ == 3) {
            this.flowGetRowset(7, 0L);
        } else {
            long rowNumber = this.maxRows_ == 0 ? ((long)this.fetchSize_ < row ? (long)(-1 * this.fetchSize_) : 1L) : ((long)this.fetchSize_ < row ? (long)(this.maxRows_ - this.fetchSize_ + 1) : 1L);
            this.flowGetRowset(2, rowNumber);
        }
        this.parseRowset_();
        if (this.rowsReceivedInCurrentRowset_ == 0 && this.cursor_.allRowsReceivedFromServer()) {
            this.isAfterLast_ = true;
            this.setRowsetAfterLastEvent();
            return false;
        }
        if (this.sensitivity_ != 3) {
            this.adjustLastRowset(row);
        } else {
            this.currentRowInRowset_ = this.rowsReceivedInCurrentRowset_ - 1;
        }
        return true;
    }

    private void adjustLastRowset(long row) {
        this.lastRowInRowset_ = row;
        this.firstRowInRowset_ = this.lastRowInRowset_ - (long)this.rowsReceivedInCurrentRowset_ + 1L;
        if (this.firstRowInRowset_ <= 0L) {
            this.firstRowInRowset_ = 1L;
        }
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.currentRowInRowset_ = this.lastRowInRowset_ - this.firstRowInRowset_;
    }

    private boolean getRefreshRowset() throws SqlException {
        if (this.isRowsetCursor_) {
            this.flowGetRowset(8, 0L);
        } else {
            this.flowGetRowset(1, -1L * (this.absolutePosition_ - this.firstRowInRowset_));
        }
        this.parseRowset_();
        if (this.sensitivity_ != 3) {
            this.adjustRefreshRowset();
        }
        return true;
    }

    private void adjustRefreshRowset() {
        this.setAbsolutePositionBasedOnAllRowsReceived();
        this.updateColumnInfoFromCache();
    }

    private void setAbsolutePositionBasedOnAllRowsReceived() {
        this.absolutePosition_ = this.cursor_.allRowsReceivedFromServer() ? this.lastRowInRowset_ + 1L : this.lastRowInRowset_;
    }

    public abstract void writeFetch_(Section var1) throws SqlException;

    public abstract void readFetch_() throws SqlException;

    public abstract void writeScrollableFetch_(Section var1, int var2, int var3, long var4, boolean var6) throws SqlException;

    public abstract void readScrollableFetch_() throws SqlException;

    public abstract void writePositioningFetch_(Section var1, int var2, long var3) throws SqlException;

    public abstract void readPositioningFetch_() throws SqlException;

    public abstract void writeCursorClose_(Section var1) throws SqlException;

    public abstract void readCursorClose_() throws SqlException;

    protected abstract void parseRowset_() throws SqlException;

    public abstract void setFetchSize_(int var1);

    protected abstract void preClose_() throws SqlException;

    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    public StatementCallbackInterface getStatementCallbackInterface() {
        return this.statement_;
    }

    public void expandRowsetSqlca() {
        if (this.isRowsetCursor_ && (this.rowsetSqlca_ == null || this.rowsetSqlca_.length < this.fetchSize_ + 2)) {
            this.rowsetSqlca_ = new Sqlca[this.fetchSize_ + 2];
        }
    }

    private final int checkRowsetSqlca() throws SqlException {
        return this.checkRowsetSqlca((int)this.currentRowInRowset_ + 1);
    }

    private final int checkRowsetSqlca(int row) throws SqlException {
        int sqlcode = 0;
        if (!this.isRowsetCursor_ || this.rowsetSqlca_ == null || this.rowsetSqlca_[row] == null) {
            this.warnings_ = null;
            return sqlcode;
        }
        Sqlca sqlca = this.rowsetSqlca_[row];
        if (sqlca != null) {
            sqlcode = sqlca.getSqlCode();
            if (sqlcode < 0) {
                throw new SqlException(this.agent_.logWriter_, sqlca);
            }
            if (sqlcode > 0 && sqlcode != 100 && sqlcode != 20237) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
        return sqlcode;
    }

    private void resetRowsetFlags() {
        this.isBeforeFirst_ = false;
        this.isAfterLast_ = false;
        this.isFirst_ = false;
        this.isLast_ = false;
    }

    private void resetRowsetSqlca() {
        if (this.rowsetSqlca_ != null) {
            for (int i = 0; i < this.rowsetSqlca_.length; ++i) {
                this.rowsetSqlca_[i] = null;
            }
        }
    }

    private CloseFilterInputStream createCloseFilterInputStream(InputStream is) throws SqlException {
        if (is == null) {
            return null;
        }
        if (this.is_ == is) {
            return this.is_;
        }
        this.closeCloseFilterInputStream();
        this.is_ = new CloseFilterInputStream(is);
        return this.is_;
    }

    private void closeCloseFilterInputStream() throws SqlException {
        if (this.is_ != null) {
            try {
                this.is_.close();
            }
            catch (IOException e) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), (Object)"java.io.IOException", (Object)e.getMessage(), (Throwable)e);
            }
            this.is_ = null;
        }
    }

    void useStream(int columnIndex) throws SqlException {
        if (this.streamUsedFlags_[columnIndex - 1]) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL18.S"));
        }
        this.streamUsedFlags_[columnIndex - 1] = true;
    }

    private void unuseStreams() {
        if (this.streamUsedFlags_ == null) {
            this.streamUsedFlags_ = new boolean[this.resultSetMetaData_.columns_];
            return;
        }
        for (int i = 0; i < this.streamUsedFlags_.length; ++i) {
            this.streamUsedFlags_[i] = false;
        }
    }

    private SQLException jdbc3MethodNotSupported() {
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1")).getSQLException();
    }

    public final int getHoldability() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getHoldability");
        }
        try {
            this.checkForClosedResultSet();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.resultSetHoldability_);
        }
        return this.resultSetHoldability_;
    }

    public final boolean isClosed() throws SQLException {
        boolean isClosed;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isClosed");
        }
        boolean bl = isClosed = !this.openOnClient_;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", isClosed);
        }
        return isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateAsciiStream", columnIndex, (Object)x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateAsciiStream");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObjectFromCharacterStream(this.resultSetMetaData_.types_[columnIndex - 1], x, "ISO-8859-1", Integer.MIN_VALUE));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), (Object)new Long(length), new Integer(Integer.MAX_VALUE)).getSQLException();
        }
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBinaryStream", columnIndex, (Object)x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBinaryStream");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObjectFromBinaryStream(this.resultSetMetaData_.types_[columnIndex - 1], x, Integer.MIN_VALUE));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), (Object)new Long(length), new Integer(Integer.MAX_VALUE)).getSQLException();
        }
        this.updateBinaryStream(columnIndex, x, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateBlob", columnIndex, (Object)x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateBlob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new Blob(this.agent_, x)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            try {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "updateCharacterStream", columnIndex, (Object)reader);
                }
                this.checkUpdatePreconditions(columnIndex, "updateCharacterStream");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], reader, Integer.MIN_VALUE));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003.S.4"), (Object)new Long(length), new Integer(Integer.MAX_VALUE)).getSQLException();
        }
        this.updateCharacterStream(columnIndex, x, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateClob", columnIndex, (Object)reader);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateClob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new Clob(this.agent_, reader)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        try {
            this.updateAsciiStream(this.findColumnX(columnName), x, length);
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumnX(columnLabel), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        try {
            this.updateBinaryStream(this.findColumnX(columnName), x, length);
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
    }

    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        try {
            this.updateBlob(this.findColumnX(columnLabel), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumnX(columnLabel), reader);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        try {
            this.updateCharacterStream(this.findColumnX(columnName), reader, length);
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this.updateClob(this.findColumnX(columnLabel), reader);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateClob", columnIndex, (Object)x, (int)length);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateClob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], new Clob(this.agent_, x, (int)length)));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        try {
            this.updateClob(this.findColumnX(columnName), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int columnIndex, java.sql.Clob x) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "updateClob", columnIndex, (Object)x);
            }
            try {
                this.checkUpdatePreconditions(columnIndex, "updateClob");
                this.updateColumn(columnIndex, this.agent_.crossConverters_.setObject(this.resultSetMetaData_.types_[columnIndex - 1], x));
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
        }
    }

    public void updateClob(String columnLabel, java.sql.Clob x) throws SQLException {
        try {
            this.updateClob(this.findColumnX(columnLabel), x);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public final void markLOBAsPublished(int index) {
        this.lobState.markAsPublished(index);
    }

    final void createLOBColumnTracker() {
        SanityManager.ASSERT(this.lobState == null, "LOB state tracker already initialized.");
        if (this.connection_.supportsSessionDataCaching() && this.resultSetMetaData_.hasLobColumns()) {
            int columnCount = this.resultSetMetaData_.columns_;
            int lobCount = 0;
            int[] tmpIndexes = new int[columnCount];
            boolean[] tmpIsBlob = new boolean[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int type = this.resultSetMetaData_.types_[i];
                if (type != 2004 && type != 2005) continue;
                tmpIndexes[lobCount] = i + 1;
                tmpIsBlob[lobCount++] = type == 2004;
            }
            int[] lobIndexes = new int[lobCount];
            boolean[] isBlob = new boolean[lobCount];
            System.arraycopy(tmpIndexes, 0, lobIndexes, 0, lobCount);
            System.arraycopy(tmpIsBlob, 0, isBlob, 0, lobCount);
            this.lobState = new LOBStateTracker(lobIndexes, isBlob, true);
        } else {
            this.lobState = LOBStateTracker.NO_OP_TRACKER;
        }
    }
}

