/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class StatementDuration
extends VTITemplate {
    private boolean gotFile;
    private InputStreamReader inputFileStreamReader;
    private InputStream inputStream;
    private BufferedReader bufferedReader;
    private String inputFileName;
    private Hashtable hashTable;
    private String line;
    private int gmtIndex;
    private int threadIndex;
    private int xidIndex;
    private int lccidIndex;
    private String[] currentRow;
    private static final String GMT_STRING = " GMT";
    private static final String BEGIN_THREAD_STRING = "[";
    private static final String END_THREAD_STRING = "]";
    private static final String BEGIN_XID_STRING = "= ";
    private static final String END_XID_STRING = ")";
    private static final String BEGIN_EXECUTING_STRING = "Executing prepared";
    private static final String END_EXECUTING_STRING = " :End prepared";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TS", 12, false, 26), EmbedResultSetMetaData.getResultColumnDescriptor("THREADID", 12, false, 80), EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("LCCID", 12, false, 10), EmbedResultSetMetaData.getResultColumnDescriptor("LOGTEXT", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("DURATION", 12, false, 10)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public StatementDuration() {
        String home = System.getProperty("derby.system.home");
        this.inputFileName = "derby.log";
        if (home != null) {
            this.inputFileName = home + "/" + this.inputFileName;
        }
    }

    public StatementDuration(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        String[] previousRow;
        String[] newRow;
        if (!this.gotFile) {
            this.gotFile = true;
            try {
                this.inputFileStreamReader = new InputStreamReader(new FileInputStream(this.inputFileName));
                this.bufferedReader = new BufferedReader(this.inputFileStreamReader, 32768);
            }
            catch (FileNotFoundException ex) {
                throw new SQLException(ex.getMessage());
            }
            this.hashTable = new Hashtable();
        }
        while (true) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException ioe) {
                throw new SQLException(ioe.getMessage());
            }
            if (this.line == null) {
                return false;
            }
            this.gmtIndex = this.line.indexOf(GMT_STRING);
            this.threadIndex = this.line.indexOf(BEGIN_THREAD_STRING);
            this.xidIndex = this.line.indexOf(BEGIN_XID_STRING);
            this.lccidIndex = this.line.indexOf(BEGIN_XID_STRING, this.xidIndex + 1);
            if (this.gmtIndex == -1 || this.threadIndex == -1) continue;
            newRow = new String[6];
            for (int index = 1; index <= 5; ++index) {
                newRow[index - 1] = this.setupColumn(index);
            }
            previousRow = this.hashTable.put(newRow[3], newRow);
            if (previousRow != null) break;
        }
        this.currentRow = previousRow;
        Timestamp endTs = Timestamp.valueOf(newRow[0]);
        long end = endTs.getTime() + (long)(endTs.getNanos() / 1000000);
        Timestamp startTs = Timestamp.valueOf(this.currentRow[0]);
        long start = startTs.getTime() + (long)(startTs.getNanos() / 1000000);
        this.currentRow[5] = Long.toString(end - start);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
                this.inputFileStreamReader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bufferedReader = null;
                this.inputFileStreamReader = null;
            }
        }
    }

    public String getString(int columnNumber) throws SQLException {
        return this.currentRow[columnNumber - 1];
    }

    private String setupColumn(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 1: {
                return this.line.substring(0, this.gmtIndex);
            }
            case 2: {
                return this.line.substring(this.threadIndex + 1, this.line.indexOf(END_THREAD_STRING));
            }
            case 3: {
                return this.line.substring(this.xidIndex + 2, this.line.indexOf(END_XID_STRING, this.xidIndex));
            }
            case 4: {
                return this.line.substring(this.lccidIndex + 2, this.line.indexOf(END_XID_STRING, this.lccidIndex));
            }
            case 5: {
                String output;
                if (this.line.indexOf(BEGIN_EXECUTING_STRING) == -1) {
                    output = this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3);
                } else {
                    int endIndex = this.line.indexOf(END_EXECUTING_STRING, this.lccidIndex);
                    output = endIndex == -1 ? this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3) : this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3, endIndex);
                    while (endIndex == -1) {
                        try {
                            this.line = this.bufferedReader.readLine();
                        }
                        catch (IOException ioe) {
                            throw new SQLException("Error reading file " + ioe);
                        }
                        endIndex = this.line.indexOf(END_EXECUTING_STRING);
                        if (endIndex == -1) {
                            output = output + this.line;
                            continue;
                        }
                        output = output + this.line.substring(0, endIndex);
                    }
                }
                output = StringUtil.truncate(output, 32672);
                return output;
            }
        }
        return null;
    }

    public boolean wasNull() {
        return false;
    }
}

