/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

final class StorageFactoryService
implements PersistentService {
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String subSubProtocol, Class storageFactoryClass) throws StandardException {
        this.subSubProtocol = subSubProtocol;
        this.storageFactoryClass = storageFactoryClass;
        Object monitorEnv = Monitor.getMonitor().getEnvironment();
        if (monitorEnv instanceof File) {
            final File relativeRoot = (File)monitorEnv;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, StandardException {
                        StorageFactoryService.this.home = relativeRoot.getPath();
                        StorageFactoryService.this.canonicalHome = relativeRoot.getCanonicalPath();
                        StorageFactoryService.this.rootStorageFactory = StorageFactoryService.this.getStorageFactoryInstance(true, null, null, null);
                        if (StorageFactoryService.this.home != null) {
                            StorageFile rootDir = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                            rootDir.mkdirs();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException ioe) {
                throw Monitor.exceptionStartingModule(ioe);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StorageFactoryService.this.separatorChar = StorageFactoryService.this.rootStorageFactory.getSeparator();
                return null;
            }
        });
    }

    public boolean hasStorageFactory() {
        return true;
    }

    public StorageFactory getStorageFactoryInstance(final boolean useHome, final String databaseName, final String tempDirName, final String uniqueName) throws StandardException, IOException {
        try {
            return (StorageFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException, IOException {
                    return StorageFactoryService.this.privGetStorageFactoryInstance(useHome, databaseName, tempDirName, uniqueName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            throw StandardException.newException("XBM0W.S", e, (Object)this.subSubProtocol, (Object)this.storageFactoryClass);
        }
    }

    private StorageFactory privGetStorageFactoryInstance(boolean useHome, String databaseName, String tempDirName, String uniqueName) throws InstantiationException, IllegalAccessException, IOException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.newInstance();
        String dbn = databaseName != null && this.subSubProtocol != null && databaseName.startsWith(this.subSubProtocol + ":") ? databaseName.substring(this.subSubProtocol.length() + 1) : databaseName;
        storageFactory.init(useHome ? this.home : null, dbn, tempDirName, uniqueName);
        return storageFactory;
    }

    public String getType() {
        return this.subSubProtocol;
    }

    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    public Properties getServiceProperties(final String serviceName, Properties defaultProperties) throws StandardException {
        if (!serviceName.equals(this.getCanonicalServiceName(serviceName))) {
            SanityManager.THROWASSERT("serviceName (" + serviceName + ") expected to equal getCanonicalServiceName(serviceName) (" + this.getCanonicalServiceName(serviceName) + ")");
        }
        final String recreateFrom = this.recreateServiceRoot(serviceName, defaultProperties);
        final Properties serviceProperties = new Properties(defaultProperties);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    if (recreateFrom != null) {
                        File propFile = new File(recreateFrom, "service.properties");
                        FileInputStream is = new FileInputStream(propFile);
                        try {
                            serviceProperties.load(new BufferedInputStream(is));
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                    StorageFile file = storageFactory.newStorageFile("service.properties");
                    try {
                        InputStream is = file.getInputStream();
                        try {
                            serviceProperties.load(new BufferedInputStream(is));
                        }
                        finally {
                            is.close();
                        }
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                    return null;
                }
            });
            return serviceProperties;
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof FileNotFoundException) {
                return null;
            }
            throw Monitor.exceptionStartingModule(pae.getException());
        }
        catch (SecurityException se) {
            throw Monitor.exceptionStartingModule(se);
        }
    }

    public void saveServiceProperties(final String serviceName, StorageFactory sf, final Properties properties, final boolean replace) throws StandardException {
        SanityManager.ASSERT(serviceName.equals(this.getCanonicalServiceName(serviceName)), serviceName);
        if (!(sf instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D");
        }
        final WritableStorageFactory storageFactory = (WritableStorageFactory)sf;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    StorageFile backupFile = null;
                    StorageFile servicePropertiesFile = storageFactory.newStorageFile("service.properties");
                    if (replace) {
                        backupFile = storageFactory.newStorageFile("service.properties".concat("old"));
                        try {
                            if (!servicePropertiesFile.renameTo(backupFile)) {
                                throw StandardException.newException("XBM0S.D", (Object)servicePropertiesFile, (Object)backupFile);
                            }
                        }
                        catch (SecurityException se) {
                            throw Monitor.exceptionStartingModule(se);
                        }
                    }
                    OutputStream os = null;
                    try {
                        os = servicePropertiesFile.getOutputStream();
                        properties.store(os, serviceName + MessageService.getTextMessage("M001"));
                        storageFactory.sync(os, false);
                        os.close();
                        os = null;
                    }
                    catch (IOException ioe) {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            os = null;
                        }
                        if (backupFile != null) {
                            try {
                                servicePropertiesFile.delete();
                                backupFile.renameTo(servicePropertiesFile);
                            }
                            catch (SecurityException se) {
                                // empty catch block
                            }
                        }
                        throw Monitor.exceptionStartingModule(ioe);
                    }
                    if (backupFile != null) {
                        try {
                            backupFile.delete();
                            backupFile = null;
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
    }

    public void saveServiceProperties(final String serviceName, final Properties properties, final boolean replace) throws StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                File backupFile = null;

                public Object run() throws StandardException {
                    File servicePropertiesFile = new File(serviceName, "service.properties");
                    if (replace) {
                        this.backupFile = new File(serviceName, "service.properties".concat("old"));
                        try {
                            if (!servicePropertiesFile.renameTo(this.backupFile)) {
                                throw StandardException.newException("XBM0S.D", (Object)servicePropertiesFile, (Object)this.backupFile);
                            }
                        }
                        catch (SecurityException se) {
                            throw Monitor.exceptionStartingModule(se);
                        }
                    }
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(servicePropertiesFile);
                        properties.store(fos, serviceName + MessageService.getTextMessage("M001"));
                        fos.getFD().sync();
                        fos.close();
                        fos = null;
                    }
                    catch (IOException ioe) {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            fos = null;
                        }
                        if (this.backupFile != null) {
                            try {
                                servicePropertiesFile.delete();
                                this.backupFile.renameTo(servicePropertiesFile);
                            }
                            catch (SecurityException se) {
                                // empty catch block
                            }
                        }
                        throw Monitor.exceptionStartingModule(ioe);
                    }
                    if (this.backupFile != null) {
                        try {
                            this.backupFile.delete();
                            this.backupFile = null;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String recreateServiceRoot(final String serviceName, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean createRoot = false;
        boolean deleteExistingRoot = false;
        String restoreFrom = properties.getProperty("createFrom");
        if (restoreFrom != null) {
            createRoot = true;
            deleteExistingRoot = false;
        } else {
            restoreFrom = properties.getProperty("restoreFrom");
            if (restoreFrom != null) {
                createRoot = true;
                deleteExistingRoot = true;
            } else {
                restoreFrom = properties.getProperty("rollForwardRecoveryFrom");
                if (restoreFrom != null) {
                    try {
                        if (AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                                StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                                try {
                                    StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                                    7 var3_3 = serviceDirectory.exists() ? this : null;
                                    return var3_3;
                                }
                                finally {
                                    storageFactory.shutdown();
                                }
                            }
                        }) == null) {
                            createRoot = true;
                            deleteExistingRoot = false;
                        }
                    }
                    catch (PrivilegedActionException pae) {
                        throw Monitor.exceptionStartingModule((IOException)pae.getException());
                    }
                }
            }
        }
        if (restoreFrom == null) return restoreFrom;
        File backupRoot = new File(restoreFrom);
        if (!this.fileExists(backupRoot)) throw StandardException.newException("XBM0Y.D", backupRoot);
        File bserviceProp = new File(restoreFrom, "service.properties");
        if (!this.fileExists(bserviceProp)) throw StandardException.newException("XBM0Q.D", bserviceProp);
        if (createRoot) {
            this.createServiceRoot(serviceName, deleteExistingRoot);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    WritableStorageFactory storageFactory = (WritableStorageFactory)StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                    try {
                        StorageFile cserviceProp = storageFactory.newStorageFile("service.properties");
                        if (cserviceProp.exists() && !cserviceProp.delete()) {
                            throw StandardException.newException("XBM0R.D", cserviceProp);
                        }
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw Monitor.exceptionStartingModule((IOException)pae.getException());
        }
        properties.put("derby.__rt.inRestore", "True");
        if (!createRoot) return restoreFrom;
        properties.put("derby.__rt.deleteRootOnError", "True");
        return restoreFrom;
    }

    public String createServiceRoot(final String name, final boolean deleteExisting) throws StandardException {
        Exception t;
        block5: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D");
            }
            t = null;
            try {
                String protocolLeadIn = "";
                if (!this.getType().equals("directory")) {
                    protocolLeadIn = this.getType() + ":";
                }
                return protocolLeadIn + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                        StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, name, null, null);
                        try {
                            StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                            if (serviceDirectory.exists()) {
                                if (deleteExisting) {
                                    if (!serviceDirectory.deleteAll()) {
                                        throw StandardException.newException("XBM0I.D", StorageFactoryService.this.getDirectoryPath(name));
                                    }
                                } else {
                                    throw StandardException.newException("XBM0J.D", StorageFactoryService.this.getDirectoryPath(name));
                                }
                            }
                            if (serviceDirectory.mkdirs()) {
                                try {
                                    String string = storageFactory.getCanonicalName();
                                    return string;
                                }
                                catch (IOException ioe) {
                                    serviceDirectory.deleteAll();
                                    throw ioe;
                                }
                            }
                            throw StandardException.newException("XBM0H.D", serviceDirectory);
                        }
                        finally {
                            storageFactory.shutdown();
                        }
                    }
                });
            }
            catch (SecurityException se) {
                t = se;
            }
            catch (PrivilegedActionException pae) {
                t = pae.getException();
                if (!(t instanceof StandardException)) break block5;
                throw (StandardException)t;
            }
        }
        throw StandardException.newException("XBM0H.D", t, (Object)name);
    }

    private String getDirectoryPath(String name) {
        StringBuffer sb = new StringBuffer();
        if (this.home != null) {
            sb.append(this.home);
            sb.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            sb.append(name.replace('/', this.separatorChar));
        } else {
            sb.append(name);
        }
        return sb.toString();
    }

    public boolean removeServiceRoot(final String serviceName) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, serviceName, null, null);
                    try {
                        SanityManager.ASSERT(serviceName.equals(storageFactory.getCanonicalName()), "serviceName = " + serviceName + ";storageFactory.getCanonicalName() = " + storageFactory.getCanonicalName());
                        StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                        10 var3_3 = serviceDirectory.deleteAll() ? this : null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            }) != null;
        }
        catch (PrivilegedActionException pae) {
            return false;
        }
    }

    public String getCanonicalServiceName(String name) throws StandardException {
        String protocolLeadIn = this.getType() + ":";
        int colon = name.indexOf(58);
        if (colon > 1) {
            if (!name.startsWith(protocolLeadIn)) {
                return null;
            }
            name = name.substring(colon + 1);
        }
        if (this.getType().equals("directory")) {
            protocolLeadIn = "";
        }
        final String nm = name;
        try {
            return protocolLeadIn + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, nm, null, null);
                    try {
                        String string = storageFactory.getCanonicalName();
                        return string;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw Monitor.exceptionStartingModule(pae.getException());
        }
    }

    public String getUserServiceName(String serviceName) {
        if (this.home != null && serviceName.length() > this.canonicalHome.length() + 1 && serviceName.startsWith(this.canonicalHome) && (serviceName = serviceName.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            serviceName = serviceName.substring(1);
        }
        return serviceName.replace(this.separatorChar, '/');
    }

    public boolean isSameService(String serviceName1, String serviceName2) {
        try {
            SanityManager.ASSERT(serviceName1.equals(this.getCanonicalServiceName(serviceName1)), serviceName1);
            SanityManager.ASSERT(serviceName2.equals(this.getCanonicalServiceName(serviceName2)), serviceName2);
        }
        catch (StandardException se) {
            return false;
        }
        return serviceName1.equals(serviceName2);
    }

    private final boolean fileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    final class DirectoryList
    implements Enumeration,
    PrivilegedAction {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            AccessController.doPrivileged(this);
        }

        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return AccessController.doPrivileged(this) != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        public final Object run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile properties;
                            String dirname = this.contents[this.index];
                            StorageFile dir = StorageFactoryService.this.rootStorageFactory.newStorageFile(dirname);
                            if (dir.isDirectory() && (properties = StorageFactoryService.this.rootStorageFactory.newStorageFile(dir, "service.properties")).exists()) {
                                this.contents[this.index] = dir.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception se) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

