/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class AndNode
extends BinaryLogicalOperatorNode {
    public void init(Object leftOperand, Object rightOperand) {
        super.init(leftOperand, rightOperand, "and");
        this.shortCircuitValue = false;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        this.postBindFixup();
        return this;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.leftOperand instanceof OrNode) {
            ((OrNode)this.leftOperand).setFirstOr();
        }
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.leftOperand instanceof AndNode) {
            this.changeToCNF(false);
        }
        this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        this.leftOperand = this.leftOperand.eliminateNots(underNotNode);
        this.rightOperand = this.rightOperand.eliminateNots(underNotNode);
        if (!underNotNode) {
            return this;
        }
        ValueNode orNode = (ValueNode)this.getNodeFactory().getNode(52, this.leftOperand, this.rightOperand, this.getContextManager());
        orNode.setType(this.getTypeServices());
        return orNode;
    }

    public ValueNode putAndsOnTop() throws StandardException {
        SanityManager.ASSERT(this.rightOperand != null, "rightOperand is expected to be non-null");
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    public boolean verifyPutAndsOnTop() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof AndNode || this.rightOperand.isBooleanTrue();
        if (this.rightOperand instanceof AndNode) {
            isValid = this.rightOperand.verifyPutAndsOnTop();
        }
        return isValid;
    }

    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        AndNode curAnd = this;
        if (!(this.rightOperand instanceof AndNode) && !this.rightOperand.isBooleanTrue()) {
            BooleanConstantNode trueNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
            curAnd.setRightOperand((ValueNode)this.getNodeFactory().getNode(39, curAnd.getRightOperand(), trueNode, this.getContextManager()));
            ((AndNode)curAnd.getRightOperand()).postBindFixup();
        }
        while (this.leftOperand instanceof AndNode) {
            ValueNode newLeft = ((AndNode)this.leftOperand).getLeftOperand();
            AndNode oldLeft = (AndNode)this.leftOperand;
            AndNode newRight = (AndNode)this.leftOperand;
            ValueNode oldRight = this.rightOperand;
            this.leftOperand = newLeft;
            this.rightOperand = newRight;
            newRight.setLeftOperand(oldLeft.getRightOperand());
            newRight.setRightOperand(oldRight);
        }
        this.leftOperand = this.leftOperand.changeToCNF(underTopAndNode);
        this.rightOperand = this.rightOperand.changeToCNF(underTopAndNode);
        return this;
    }

    public boolean verifyChangeToCNF() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof AndNode || this.rightOperand.isBooleanTrue();
        if (this.rightOperand instanceof AndNode) {
            isValid = this.rightOperand.verifyChangeToCNF();
        }
        isValid = this.leftOperand instanceof AndNode ? false : isValid && this.leftOperand.verifyChangeToCNF();
        return isValid;
    }

    void postBindFixup() throws StandardException {
        this.setType(this.resolveLogicalBinaryOperator(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
    }
}

