/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class DateTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    public boolean storable(TypeId otherType, ClassFactory cf) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        if (otherJDBCTypeId == 91 || otherJDBCTypeId == 1 || otherJDBCTypeId == 12) {
            return true;
        }
        return cf.getClassInspector().assignableTo(otherType.getCorrespondingJavaTypeName(), "java.sql.Date");
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Date";
    }

    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 10;
    }

    String nullMethodName() {
        return "getNullDate";
    }
}

