/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.GenericQualifier;

abstract class NoPutResultSetImpl
extends BasicNoPutResultSetImpl {
    public final int resultSetNumber;
    private boolean needsRowLocation;
    protected ExecRow clonedExecRow;
    protected TargetResultSet targetResultSet;
    protected int[] checkNullCols;
    protected int cncLen;

    NoPutResultSetImpl(Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, optimizerEstimatedRowCount, optimizerEstimatedCost);
        SanityManager.ASSERT(activation != null, "activation expected to be non-null");
        SanityManager.ASSERT(resultSetNumber >= 0, "resultSetNumber expected to be >= 0");
        this.resultSetNumber = resultSetNumber;
    }

    public String getCursorName() {
        String cursorName = this.activation.getCursorName();
        if (cursorName == null && this.isForUpdate()) {
            this.activation.setCursorName(this.activation.getLanguageConnectionContext().getUniqueCursorName());
            cursorName = this.activation.getCursorName();
        }
        return cursorName;
    }

    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.isTopResultSet) {
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            if (lcc.getRunTimeStatisticsMode()) {
                HeaderPrintWriter istream;
                this.endExecutionTime = this.getCurrentTimeMillis();
                lcc.setRunTimeStatisticsObject(lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory().getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                HeaderPrintWriter headerPrintWriter = istream = lcc.getLogQueryPlan() ? Monitor.getStream() : null;
                if (istream != null) {
                    istream.printlnWithHeader("(XID = " + lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
            }
            int staLength = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
            for (int index = 0; index < staLength; ++index) {
                if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
                this.subqueryTrackingArray[index].close();
            }
        }
        this.isOpen = false;
    }

    public void setTargetResultSet(TargetResultSet trs) {
        this.targetResultSet = trs;
    }

    public void setNeedsRowLocation(boolean needsRowLocation) {
        this.needsRowLocation = needsRowLocation;
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.getNextRowCore();
        if (execRow != null) {
            this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            return execRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.needsRowLocation;
    }

    public void rowLocation(RowLocation rl) throws StandardException {
        this.targetResultSet.changedRow(this.clonedExecRow, rl);
    }

    protected void clearOrderableCache(Qualifier[][] qualifiers) throws StandardException {
        if (qualifiers != null) {
            for (int term = 0; term < qualifiers.length; ++term) {
                for (int index = 0; index < qualifiers[term].length; ++index) {
                    Qualifier qual = qualifiers[term][index];
                    qual.clearOrderableCache();
                    if (((GenericQualifier)qual).variantType == 0) continue;
                    qual.getOrderable();
                }
            }
        }
    }

    public final void setCurrentRow(ExecRow row) {
        this.activation.setCurrentRow(row, this.resultSetNumber);
        this.currentRow = row;
    }

    public void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    public boolean isForUpdate() {
        return false;
    }

    protected boolean skipScan(ExecIndexRow startPosition, ExecIndexRow stopPosition) throws StandardException {
        int position;
        int nStartCols = startPosition == null ? 0 : startPosition.nColumns();
        int nStopCols = stopPosition == null ? 0 : stopPosition.nColumns();
        boolean startKeyLonger = false;
        int size = nStopCols;
        if (nStartCols > nStopCols) {
            startKeyLonger = true;
            size = nStartCols;
        }
        if (size == 0) {
            return false;
        }
        if (this.checkNullCols == null || this.checkNullCols.length < size) {
            this.checkNullCols = new int[size];
        }
        this.cncLen = 0;
        boolean returnValue = false;
        for (position = 0; position < nStartCols; ++position) {
            if (startPosition.areNullsOrdered(position)) continue;
            if (startKeyLonger) {
                this.checkNullCols[this.cncLen++] = position + 1;
            }
            if (!startPosition.getColumn(position + 1).isNull()) continue;
            returnValue = true;
            if (!startKeyLonger) break;
        }
        if (startKeyLonger && returnValue) {
            return true;
        }
        for (position = 0; position < nStopCols; ++position) {
            if (stopPosition.areNullsOrdered(position)) continue;
            if (!startKeyLonger) {
                this.checkNullCols[this.cncLen++] = position + 1;
            }
            if (returnValue || !stopPosition.getColumn(position + 1).isNull()) continue;
            returnValue = true;
            if (startKeyLonger) break;
        }
        return returnValue;
    }

    protected boolean skipRow(ExecRow row) throws StandardException {
        for (int i = 0; i < this.cncLen; ++i) {
            if (!row.getColumn(this.checkNullCols[i]).isNull()) continue;
            return true;
        }
        return false;
    }

    public static String printQualifiers(Qualifier[][] qualifiers) {
        String idt = "";
        String output = "";
        if (qualifiers == null) {
            return idt + MessageService.getTextMessage("42Z37.U");
        }
        for (int term = 0; term < qualifiers.length; ++term) {
            for (int i = 0; i < qualifiers[term].length; ++i) {
                Qualifier qual = qualifiers[term][i];
                output = idt + output + MessageService.getTextMessage("42Z48.U", String.valueOf(term), String.valueOf(i)) + ": " + qual.getColumnId() + "\n";
                int operator = qual.getOperator();
                String opString = null;
                switch (operator) {
                    case 2: {
                        opString = "=";
                        break;
                    }
                    case 3: {
                        opString = "<=";
                        break;
                    }
                    case 1: {
                        opString = "<";
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("Unknown operator " + operator);
                        opString = "unknown value (" + operator + ")";
                    }
                }
                output = output + idt + MessageService.getTextMessage("42Z43.U") + ": " + opString + "\n" + idt + MessageService.getTextMessage("42Z44.U") + ": " + qual.getOrderedNulls() + "\n" + idt + MessageService.getTextMessage("42Z45.U") + ": " + qual.getUnknownRV() + "\n" + idt + MessageService.getTextMessage("42Z46.U") + ": " + qual.negateCompareResult() + "\n";
            }
        }
        return output;
    }

    public void updateRow(ExecRow row) throws StandardException {
    }

    public void markRowAsDeleted() throws StandardException {
    }

    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }
}

