/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.log.LogCounter;

public class CheckpointOperation
implements Loggable {
    protected long redoLWM;
    protected long undoLWM;
    protected Formatable transactionTable;

    public CheckpointOperation(long redoLWM, long undoLWM, Formatable ttab) {
        this.redoLWM = redoLWM;
        this.undoLWM = undoLWM;
        this.transactionTable = ttab;
    }

    public CheckpointOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.redoLWM);
        CompressedNumber.writeLong(out, this.undoLWM);
        CompressedNumber.writeInt(out, 0);
        if (this.transactionTable == null) {
            CompressedNumber.writeInt(out, 0);
        } else {
            CompressedNumber.writeInt(out, 1);
            out.writeObject(this.transactionTable);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.redoLWM = CompressedNumber.readLong(in);
        this.undoLWM = CompressedNumber.readLong(in);
        int tsize = CompressedNumber.readInt(in);
        int haveTTab = CompressedNumber.readInt(in);
        this.transactionTable = haveTTab == 1 ? (Formatable)in.readObject() : (Formatable)null;
    }

    public int getTypeFormatId() {
        return 263;
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException {
        if (((RawTransaction)xact).inRollForwardRecovery()) {
            ((RawTransaction)xact).checkpointInRollForwardRecovery(instant, this.redoLWM, this.undoLWM);
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction xact) {
        return ((RawTransaction)xact).inRollForwardRecovery();
    }

    public void releaseResource(Transaction xact) {
    }

    public int group() {
        return 256;
    }

    public long redoLWM() {
        return this.redoLWM;
    }

    public long undoLWM() {
        return this.undoLWM;
    }

    public Formatable getTransactionTable() {
        return this.transactionTable;
    }

    public String toString() {
        LogCounter undolwm = new LogCounter(this.undoLWM);
        LogCounter redolwm = new LogCounter(this.redoLWM);
        StringBuffer str = new StringBuffer(1000).append("Checkpoint : \tredoLWM ").append(redolwm.toString()).append("\n\t\tundoLWM ").append(undolwm.toString());
        if (this.transactionTable != null) {
            str.append(this.transactionTable.toString());
        }
        return str.toString();
    }
}

