/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.Permission;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSet20;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.InternalDriver;

public abstract class Driver20
extends InternalDriver
implements Driver {
    private static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};
    private Class antiGCDriverManager;

    public void boot(boolean create, Properties properties) throws StandardException {
        super.boot(create, properties);
        AutoloadedDriver.registerDriverModule(this);
        this.antiGCDriverManager = DriverManager.class;
    }

    public void stop() {
        super.stop();
        AutoloadedDriver.unregisterDriverModule();
    }

    public EmbedResultSet newEmbedResultSet(EmbedConnection conn, ResultSet results, boolean forMetaData, EmbedStatement statement, boolean isAtomic) throws SQLException {
        return new EmbedResultSet20(conn, results, forMetaData, statement, isAtomic);
    }

    public abstract BrokeredConnection newBrokeredConnection(BrokeredConnectionControl var1);

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info != null && Boolean.valueOf(info.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        String dbname = InternalDriver.getDatabaseName(url, info);
        FormatableProperties finfo = this.getAttributes(url, info);
        info = null;
        boolean encryptDB = Boolean.valueOf(finfo.getProperty("dataEncryption"));
        String encryptpassword = finfo.getProperty("bootPassword");
        if (dbname.length() == 0 || (encryptDB = encryptpassword == null)) {
            String[][] connStringAttributes = new String[][]{{"databaseName", "J004"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"territory", "J021"}, {"collation", "J031"}, {"user", "J022"}, {"logDevice", "J025"}, {"rollForwardRecoveryFrom", "J028"}, {"createFrom", "J029"}, {"restoreFrom", "J030"}};
            String[][] connBooleanAttributes = new String[][]{{"shutdown", "J005"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"upgrade", "J013"}};
            String[][] connStringSecretAttributes = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] optionsNoDB = new DriverPropertyInfo[connStringAttributes.length + connBooleanAttributes.length + connStringSecretAttributes.length];
            int attrIndex = 0;
            int i = 0;
            while (i < connStringAttributes.length) {
                optionsNoDB[attrIndex] = new DriverPropertyInfo(connStringAttributes[i][0], finfo.getProperty(connStringAttributes[i][0]));
                optionsNoDB[attrIndex].description = MessageService.getTextMessage(connStringAttributes[i][1]);
                ++i;
                ++attrIndex;
            }
            optionsNoDB[0].choices = Monitor.getMonitor().getServiceList("org.apache.derby.database.Database");
            optionsNoDB[0].value = dbname;
            i = 0;
            while (i < connStringSecretAttributes.length) {
                optionsNoDB[attrIndex] = new DriverPropertyInfo(connStringSecretAttributes[i][0], finfo.getProperty(connStringSecretAttributes[i][0]) == null ? "" : "****");
                optionsNoDB[attrIndex].description = MessageService.getTextMessage(connStringSecretAttributes[i][1]);
                ++i;
                ++attrIndex;
            }
            i = 0;
            while (i < connBooleanAttributes.length) {
                optionsNoDB[attrIndex] = new DriverPropertyInfo(connBooleanAttributes[i][0], Boolean.valueOf(finfo == null ? "" : finfo.getProperty(connBooleanAttributes[i][0])).toString());
                optionsNoDB[attrIndex].description = MessageService.getTextMessage(connBooleanAttributes[i][1]);
                optionsNoDB[attrIndex].choices = BOOLEAN_CHOICES;
                ++i;
                ++attrIndex;
            }
            return optionsNoDB;
        }
        return new DriverPropertyInfo[0];
    }

    public void checkSystemPrivileges(String user, Permission perm) throws Exception {
        SecurityUtil.checkUserHasPermission(user, perm);
    }
}

