/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.jdbc.EmbeddedSimpleDataSource;

public class SignatureChecker {
    private static final String WILDCARD = "%";
    private static final String[] SYSTEM_SCHEMAS = new String[]{"SQLJ", "SYSCS_UTIL", "SYSIBM"};
    private ParsedArgs _parsedArgs;
    private ArrayList _procedures = new ArrayList();
    private ArrayList _functions = new ArrayList();
    private boolean _debugging = false;
    private static LocalizedResource _messageFormatter;

    private SignatureChecker(ParsedArgs parsedArgs) {
        this._parsedArgs = parsedArgs;
    }

    public static void main(String[] args) {
        ParsedArgs parsedArgs = new ParsedArgs(args);
        if (!parsedArgs.isValid()) {
            SignatureChecker.printUsage();
            System.exit(1);
        } else {
            SignatureChecker me = new SignatureChecker(parsedArgs);
            me.execute();
        }
    }

    private void execute() {
        try {
            Connection conn = this._parsedArgs.isJ2ME() ? this.getJ2MEConnection() : this.getJ2SEConnection();
            if (conn == null) {
                SignatureChecker.println(SignatureChecker.formatMessage("SC_NO_CONN"));
                return;
            }
            this.matchSignatures(conn);
            conn.close();
        }
        catch (Throwable t) {
            SignatureChecker.printThrowable(t);
        }
    }

    private void matchSignatures(Connection conn) throws SQLException {
        this.matchProcedures(conn);
        this.matchFunctions(conn);
    }

    private void matchProcedures(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.findProcedures(dbmd);
        this.countProcedureArgs(dbmd);
        int count = this._procedures.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine procedure = this.getProcedure(i);
            StringBuffer buffer = new StringBuffer();
            int argCount = procedure.getArgCount();
            buffer.append("call ");
            buffer.append(procedure.getQualifiedName());
            buffer.append("( ");
            for (int k = 0; k < argCount; ++k) {
                if (k > 0) {
                    buffer.append(", ");
                }
                buffer.append(" ? ");
            }
            buffer.append(" )");
            this.checkSignature(conn, procedure, buffer.toString(), this.makeReadableSignature(procedure));
        }
    }

    private void matchFunctions(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        this.findFunctions(dbmd);
        this.countFunctionArgs(dbmd);
        int count = this._functions.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine function = this.getFunction(i);
            StringBuffer query = new StringBuffer();
            int argCount = function.getArgCount();
            if (function.isTableFunction()) {
                query.append("select * from table( ");
            } else {
                query.append("values(  ");
            }
            query.append(function.getQualifiedName());
            query.append("( ");
            for (int k = 0; k < argCount; ++k) {
                if (k > 0) {
                    query.append(", ");
                }
                query.append(" ? ");
            }
            query.append(" ) )");
            if (function.isTableFunction()) {
                query.append(" s");
            }
            this.checkSignature(conn, function, query.toString(), this.makeReadableSignature(function));
        }
    }

    private String makeReadableSignature(SQLRoutine routine) {
        StringBuffer signature = new StringBuffer();
        int argCount = routine.getArgCount();
        signature.append(routine.getQualifiedName());
        signature.append("( ");
        for (int k = 0; k < argCount; ++k) {
            if (k > 0) {
                signature.append(", ");
            }
            signature.append(" " + routine.getArgType(k) + " ");
        }
        signature.append(" )");
        return signature.toString();
    }

    private void findProcedures(DatabaseMetaData dbmd) throws SQLException {
        ResultSet rs = dbmd.getProcedures(null, null, WILDCARD);
        while (rs.next()) {
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (this.isSystemSchema(schema)) continue;
            this.putProcedure(schema, name);
        }
        rs.close();
    }

    private void countProcedureArgs(DatabaseMetaData dbmd) throws SQLException {
        int count = this._procedures.size();
        for (int i = 0; i < count; ++i) {
            SQLRoutine procedure = this.getProcedure(i);
            ResultSet rs = dbmd.getProcedureColumns(null, procedure.getSchema(), procedure.getName(), WILDCARD);
            while (rs.next()) {
                procedure.addArg(rs.getString(7));
            }
            rs.close();
        }
    }

    private void findFunctions(DatabaseMetaData dbmd) throws SQLException {
        try {
            Method getFunctionsMethod = dbmd.getClass().getMethod("getFunctions", String.class, String.class, String.class);
            ResultSet rs = (ResultSet)getFunctionsMethod.invoke((Object)dbmd, null, null, WILDCARD);
            while (rs.next()) {
                String schema = rs.getString(2);
                String name = rs.getString(3);
                short functionType = rs.getShort(5);
                if (this.isSystemSchema(schema)) continue;
                boolean isTableFunction = functionType == 2;
                this.putFunction(schema, name, isTableFunction);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void countFunctionArgs(DatabaseMetaData dbmd) throws SQLException {
        try {
            Method getFunctionColumnsMethod = dbmd.getClass().getMethod("getFunctionColumns", String.class, String.class, String.class, String.class);
            int count = this._functions.size();
            for (int i = 0; i < count; ++i) {
                SQLRoutine function = this.getFunction(i);
                ResultSet rs = (ResultSet)getFunctionColumnsMethod.invoke((Object)dbmd, null, function.getSchema(), function.getName(), WILDCARD);
                while (rs.next()) {
                    short columnType = rs.getShort(5);
                    if (columnType == 4 || columnType == 5) continue;
                    function.addArg(rs.getString(7));
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void checkSignature(Connection conn, SQLRoutine routine, String query, String readableSignature) {
        try {
            PreparedStatement ps = this.prepareStatement(conn, query);
            ps.close();
            SignatureChecker.println(SignatureChecker.formatMessage("SC_FOUND_MATCH", readableSignature));
        }
        catch (SQLException se) {
            SignatureChecker.println(SignatureChecker.formatMessage("SC_UNRESOLVABLE", readableSignature, se.getMessage()));
        }
    }

    private Connection getJ2MEConnection() throws SQLException {
        EmbeddedSimpleDataSource dataSource = new EmbeddedSimpleDataSource();
        dataSource.setDatabaseName(this._parsedArgs.getJ2meDatabaseName());
        return dataSource.getConnection();
    }

    private Connection getJ2SEConnection() throws SQLException {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName("org.apache.derby.jdbc.ClientDriver");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Class<?> driverManagerClass = Class.forName("java.sql.DriverManager");
            Method getConnectionMethod = driverManagerClass.getDeclaredMethod("getConnection", String.class);
            return (Connection)getConnectionMethod.invoke(null, this._parsedArgs.getJ2seConnectionUrl());
        }
        catch (Throwable t) {
            SignatureChecker.printThrowable(t);
            return null;
        }
    }

    private PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        if (this._debugging) {
            SignatureChecker.println("Preparing: " + text);
        }
        return conn.prepareStatement(text);
    }

    private static void printUsage() {
        SignatureChecker.println(SignatureChecker.formatMessage("SC_USAGE"));
    }

    private static void printThrowable(Throwable t) {
        t.printStackTrace();
    }

    private static void println(String text) {
        System.out.println(text);
    }

    private boolean isSystemSchema(String schema) {
        int count = SYSTEM_SCHEMAS.length;
        for (int i = 0; i < count; ++i) {
            if (!SYSTEM_SCHEMAS[i].equals(schema)) continue;
            return true;
        }
        return false;
    }

    private void putProcedure(String schema, String name) {
        this._procedures.add(new SQLRoutine(schema, name, false));
    }

    private SQLRoutine getProcedure(int idx) {
        return (SQLRoutine)this._procedures.get(idx);
    }

    private void putFunction(String schema, String name, boolean isTableFunction) {
        this._functions.add(new SQLRoutine(schema, name, isTableFunction));
    }

    private SQLRoutine getFunction(int idx) {
        return (SQLRoutine)this._functions.get(idx);
    }

    private static String formatMessage(String key) {
        return SignatureChecker.getMessageFormatter().getTextMessage(key);
    }

    private static String formatMessage(String key, String arg0) {
        return SignatureChecker.getMessageFormatter().getTextMessage(key, arg0);
    }

    private static String formatMessage(String key, String arg0, String arg1) {
        return SignatureChecker.getMessageFormatter().getTextMessage(key, arg0, arg1);
    }

    private static LocalizedResource getMessageFormatter() {
        if (_messageFormatter == null) {
            _messageFormatter = LocalizedResource.getInstance();
        }
        return _messageFormatter;
    }

    static class ParsedArgs {
        private boolean _isValid = false;
        private boolean _isJ2ME = !this.classExists("java.sql.DriverManager");
        private String _j2seConnectionUrl;
        private String _j2meDatabaseName;

        public ParsedArgs(String[] args) {
            this.parseArgs(args);
        }

        public boolean isValid() {
            return this._isValid;
        }

        public boolean isJ2ME() {
            return this._isJ2ME;
        }

        public String getJ2seConnectionUrl() {
            return this._j2seConnectionUrl;
        }

        public String getJ2meDatabaseName() {
            return this._j2meDatabaseName;
        }

        private void parseArgs(String[] args) {
            if (args == null) {
                return;
            }
            if (args.length == 0) {
                return;
            }
            if (this.isJ2ME()) {
                if (args.length != 1) {
                    return;
                }
                this._j2meDatabaseName = args[0];
                this._isValid = true;
            } else {
                if (args.length != 1) {
                    return;
                }
                this._j2seConnectionUrl = args[0];
                this._isValid = true;
            }
        }

        private boolean classExists(String className) {
            try {
                Class.forName(className);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    class SQLRoutine {
        private String _schema;
        private String _name;
        private boolean _isTableFunction;
        private ArrayList _argList = new ArrayList();

        public SQLRoutine(String schema, String name, boolean isTableFunction) {
            this._schema = schema;
            this._name = name;
            this._isTableFunction = isTableFunction;
        }

        public void addArg(String typeName) {
            this._argList.add(typeName);
        }

        public String getSchema() {
            return this._schema;
        }

        public String getName() {
            return this._name;
        }

        public int getArgCount() {
            return this._argList.size();
        }

        public String getArgType(int idx) {
            return (String)this._argList.get(idx);
        }

        public boolean isTableFunction() {
            return this._isTableFunction;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SQLRoutine( ");
            buffer.append(this._schema + ", ");
            buffer.append(this._name + ", ");
            buffer.append("isTableFunction = " + this._isTableFunction + ", ");
            buffer.append(" argCount = " + this.getArgCount());
            buffer.append(" )");
            return buffer.toString();
        }

        private String doubleQuote(String raw) {
            return '\"' + raw + '\"';
        }

        public String getQualifiedName() {
            return this.doubleQuote(this._schema) + '.' + this.doubleQuote(this._name);
        }
    }
}

