/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.NodeIterator;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.content.DefinitionContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.content.InstanceContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.content.SMLIFContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.DerefXPathFunction;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLValidatorUtil {
    public static XPath xpath;
    private static SAXParserFactory saxParserFactory;

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = xpath = factory == null ? null : factory.newXPath();
        if (xpath != null) {
            xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

                public XPathFunction resolveFunction(QName functionName, int arity) {
                    if ("http://www.w3.org/ns/sml-function".equals(functionName.getNamespaceURI()) && "deref".equals(functionName.getLocalPart()) && arity == 1) {
                        return DerefXPathFunction.instance();
                    }
                    return null;
                }
            });
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception exception) {
            saxParserFactory = null;
        }
    }

    public static Object retrieveDataStructure(String id) {
        return SMLValidatorUtil.retrieveDataStructure(1, id);
    }

    public static Object retrieveDataStructure(int mode, String id) {
        DataBuilderRegistry registry = mode == 0 ? DataBuilderRegistry.getTopLevelRegistry() : DataBuilderRegistry.getInstanceLevelRegistry();
        IDataBuilder<?> databuilder = registry.getDataStructureBuilder(id);
        if (databuilder == null) {
            return null;
        }
        return databuilder.getDataStructure();
    }

    public static String removeLineBreaks(String str, boolean replaceWithSpace) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int lastChar = 0;
        int i = 0;
        int strLength = str.length();
        while (i < strLength) {
            char currentChar = str.charAt(i);
            if (currentChar != '\r' && (lastChar != 10 || currentChar != '\t' && currentChar != ' ')) {
                sb.append(currentChar == '\n' ? (replaceWithSpace ? " " : "") : String.valueOf(currentChar));
                lastChar = currentChar;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeLineBreaks(String str) {
        return SMLValidatorUtil.removeLineBreaks(str, true);
    }

    public static <T> Map<?, ?> retrieveNestedMap(Map<String, Map<String, T>> map, String key, boolean create) {
        if (key == null) {
            return null;
        }
        Map<String, T> nestedMap = map.get(key);
        if (create && nestedMap == null) {
            nestedMap = new Hashtable<String, T>();
            map.put(key, nestedMap);
        }
        return nestedMap;
    }

    /*
     * Exception decompiling
     */
    public static Node retrieveRemoteDocument(String uri) throws RemoteRetrievalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saxParseDocument(InputStream resource, DefaultHandler contentHandler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        saxParserFactory.newSAXParser().parse(resource, contentHandler);
    }

    public static int identifyDocumentType(File resource) throws IOException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(resource);
        try {
            int type = 3;
            Object[][] describer = new Object[][]{{new SMLIFContentDescriber(), new Integer(2)}, {new DefinitionContentDescriber(), new Integer(0)}, {new InstanceContentDescriber(), new Integer(1)}};
            BufferedReader br = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuffer sb = new StringBuffer();
            String input = null;
            while ((input = br.readLine()) != null) {
                sb.append(String.valueOf(input) + IValidationConstants.LINE_SEPARATOR);
            }
            int i = 0;
            while (i < describer.length) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sb.toString().getBytes());
                if (((IContentDescriber)describer[i][0]).describe((InputStream)byteArrayInputStream, null) == 2) {
                    int n = (Integer)describer[i][1];
                    return n;
                }
                ++i;
            }
            int n = type;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static int identifyDocumentType(IFile file) throws IOException, CoreException {
        int type = 3;
        InputStream fileInputStream = null;
        fileInputStream = file.exists() ? file.getContents() : new FileInputStream(file.getFullPath().toOSString());
        IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileInputStream, file.getName());
        int i = 0;
        while (i < types.length) {
            if ("org.eclipse.cosmos.rm.validation.smlifContentType".equals(types[i].getId())) {
                return 2;
            }
            if ("org.eclipse.cosmos.rm.validation.definitionContentType".equals(types[i].getId())) {
                return 0;
            }
            if ("org.eclipse.cosmos.rm.validation.instanceContentType".equals(types[i].getId())) {
                type = 1;
            }
            ++i;
        }
        return type;
    }

    public static int identifyDocumentType(ResourceWrapper resourceWrapper) throws IOException, CoreException {
        return resourceWrapper.getResource() instanceof File ? SMLValidatorUtil.identifyDocumentType((File)resourceWrapper.getResource()) : SMLValidatorUtil.identifyDocumentType((IFile)resourceWrapper.getResource());
    }

    public static boolean deleteFileTree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    SMLValidatorUtil.deleteFileTree(children[i]);
                    ++i;
                }
            }
            return root.delete();
        }
        return true;
    }

    public static Node[] retrieveChildElements(Node node) {
        if (node == null) {
            return new Node[0];
        }
        ArrayList<Node> childElements = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                childElements.add(child);
            }
            ++i;
        }
        return childElements.toArray(new Node[childElements.size()]);
    }

    public static String tagNameFor(String namespace, String elementName) {
        StringBuffer buffer = new StringBuffer("");
        if (namespace != null) {
            buffer.append(namespace).append(":");
        }
        buffer.append(elementName);
        return buffer.toString();
    }

    public static String beginTagFor(String elementName) {
        return SMLValidatorUtil.tagFor(false, null, elementName);
    }

    public static String beginTagFor(String namespace, String elementName) {
        return SMLValidatorUtil.tagFor(false, namespace, elementName);
    }

    public static String endTagFor(String elementName) {
        return SMLValidatorUtil.tagFor(true, null, elementName);
    }

    public static String endTagFor(String namespace, String elementName) {
        return SMLValidatorUtil.tagFor(true, namespace, elementName);
    }

    public static String tagFor(boolean end, String namespace, String elementName) {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<");
        if (end) {
            tagBuffer.append("/");
        }
        tagBuffer.append(SMLValidatorUtil.tagNameFor(namespace, elementName));
        tagBuffer.append(">");
        return tagBuffer.toString();
    }

    public static String createElementTag(String elementName, String elementData) {
        return String.valueOf(SMLValidatorUtil.beginTagFor(elementName)) + elementData + SMLValidatorUtil.endTagFor(elementName);
    }

    public static String createElementTag(String namespace, String elementName, String elementData) {
        return String.valueOf(SMLValidatorUtil.beginTagFor(namespace, elementName)) + elementData + SMLValidatorUtil.endTagFor(namespace, elementName);
    }

    public static String getExceptionStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        Throwable throwable = SMLValidatorUtil.findCause(t);
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        return stackTrace.toString();
    }

    protected static Throwable findCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        } else if (t instanceof CoreException) {
            cause = ((CoreException)t).getStatus().getException();
        }
        if (cause == null) {
            return t;
        }
        return SMLValidatorUtil.findCause(cause);
    }

    /*
     * Unable to fully structure code
     */
    public static String stringReplace(String originalString, String oldSubstring, String newSubstring) {
        result = new StringBuffer();
        index = 0;
        if (newSubstring != null) ** GOTO lbl14
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            prevIndex = index;
            if (index + oldSubstring.length() <= originalString.length() && (oldSubstring.length() == 0 || originalString.substring(index, index + oldSubstring.length()).equals(oldSubstring))) {
                result.append(newSubstring);
                index += oldSubstring.length();
            }
            if (prevIndex != index && !"".equals(oldSubstring)) continue;
            result.append(originalString.charAt(index));
            ++index;
lbl14:
            // 3 sources

            ** while (index < originalString.length())
        }
lbl15:
        // 1 sources

        return result.toString();
    }

    public static SAXParser createSAXParser(Object schemaSource, boolean validating, LexicalHandler lexicalHandler, IValidationOutput<?, ?> validationLogger) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        InputStream[] schemas;
        SAXParserFactory saxParserFactory = SMLValidatorUtil.saxParserFactory;
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(validating);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            saxParserFactory.setFeature("http://apache.org/xml/features/generate-synthetic-annotations", true);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SMLValidatorUtil.saxParserFactory = saxParserFactory;
        }
        saxParserFactory.setFeature("http://xml.org/sax/features/validation", validating);
        SAXParser newSaxParser = saxParserFactory.newSAXParser();
        if (schemaSource == null) {
            return newSaxParser;
        }
        if (schemaSource instanceof InputStream[] && (schemas = (InputStream[])schemaSource).length == 0) {
            return newSaxParser;
        }
        try {
            newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
            if (lexicalHandler != null) {
                newSaxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
        }
        catch (Exception exception) {
            validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, SMLValidationMessages.errorUnsupportedSAXProperty0));
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            newSaxParser = saxParserFactory.newSAXParser();
        }
        return newSaxParser;
    }

    public static String retrieveAbsolutePath(String path) {
        Path resourcePath = new Path(path);
        if (resourcePath.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(resourcePath.segment(0)).getLocation().toOSString();
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        if (file != null && SMLValidatorUtil.checkWorkspaceResourceName(path)) {
            return file.getLocation().toOSString();
        }
        return path;
    }

    public static boolean checkWorkspaceDirName(String dirName) {
        boolean okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 2).isOK();
        if (!okForFolder) {
            okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 4).isOK();
        }
        return okForFolder;
    }

    public static boolean checkWorkspaceResourceName(String resourceName) {
        if (!resourceName.startsWith("/")) {
            resourceName = String.valueOf('/') + resourceName;
        }
        return ResourcesPlugin.getWorkspace().validatePath(resourceName, 1).isOK();
    }

    public static boolean isReference(Node node) {
        return SMLValidatorUtil.isAttributeSet(node, "http://www.w3.org/ns/sml", "ref");
    }

    public static boolean isNullified(Node node) {
        return SMLValidatorUtil.isAttributeSet(node, "http://www.w3.org/ns/sml", "nilref");
    }

    private static boolean isAttributeSet(Node node, String namespace, String localName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node nilRefAttribute = attributes.getNamedItemNS(namespace, localName);
        String value = nilRefAttribute == null ? null : nilRefAttribute.getNodeValue();
        return value == null ? false : SMLValidatorUtil.isTrue(value);
    }

    public static boolean isSMLRef(Attributes attributes) {
        return SMLValidatorUtil.isTrue(attributes.getValue("http://www.w3.org/ns/sml", "ref"));
    }

    public static boolean isSMLNilRef(Attributes attributes) {
        return SMLValidatorUtil.isTrue(attributes.getValue("http://www.w3.org/ns/sml", "nilref"));
    }

    public static boolean isAcyclic(Attributes attributes) {
        return SMLValidatorUtil.isTrue(attributes.getValue("http://www.w3.org/ns/sml", "acyclic"));
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return "true".equals(value = value.trim()) || "1".equals(value);
    }

    public static boolean isFalse(String value) {
        if (value == null) {
            return false;
        }
        return "false".equals(value = value.trim()) || "0".equals(value);
    }

    public static String extractReference(Node root) {
        NodeIterator nodeIterator = new NodeIterator(root, "http://www.w3.org/ns/sml", "uri");
        if (!nodeIterator.hasNext()) {
            return "";
        }
        Node uriElement = nodeIterator.next();
        NodeList children = uriElement.getChildNodes();
        StringBuffer reference = new StringBuffer();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            if (children.item(i).getNodeType() == 3) {
                String value = children.item(i).getNodeValue();
                value = value.trim();
                value = value.replaceAll("\n", "");
                reference.append(value);
            }
            ++i;
        }
        return reference.toString();
    }

    public static QName toQName(String targetNamespace, String value) {
        if (value == null) {
            return null;
        }
        String[] tokenizedValue = value.split(":");
        if (tokenizedValue.length >= 2) {
            return new QName(targetNamespace, tokenizedValue[1], tokenizedValue[0]);
        }
        return new QName(targetNamespace, tokenizedValue[0]);
    }

    public static QName toQName(Map<String, String> prefixUriMap, String targetNamespace, String value) {
        if (value == null) {
            return null;
        }
        String[] tokenizedValue = value.split(":");
        if (tokenizedValue.length >= 2) {
            return new QName(prefixUriMap.get(tokenizedValue[0]), tokenizedValue[1], tokenizedValue[0]);
        }
        return new QName(targetNamespace, tokenizedValue[0]);
    }

    public static boolean isBuiltInNamespace(String namespace) {
        return namespace != null && namespace.equals("http://www.w3.org/ns/sml") || namespace.equals("http://purl.oclc.org/dsdl/schematron") || namespace.equals("http://www.w3.org/ns/sml-if") || namespace.equals("http://www.w3.org/2001/XMLSchema") || namespace.equals("http://www.w3.org/ns/sml-function") || namespace.equals("http://www.w3.org/1999/xlink") || namespace.equals("http://www.w3.org/2001/XMLSchema-instance") || namespace.equals("http://www.w3.org/1999/XSL/Transform");
    }

    public static boolean isAnyType(XSTypeDefinition type) {
        return type == null ? false : "http://www.w3.org/2001/XMLSchema".equals(type.getNamespace()) && "anyType".equals(type.getName());
    }

    public static InputStream[] toInputStream(ElementSchemaModel[] definitions) {
        ArrayList<ByteArrayInputStream> inputStreamList = new ArrayList<ByteArrayInputStream>();
        int i = 0;
        while (i < definitions.length) {
            inputStreamList.add(new ByteArrayInputStream(definitions[i].getSource().getBytes()));
            ++i;
        }
        return inputStreamList.toArray(new InputStream[inputStreamList.size()]);
    }

    public static AbstractDataBuilder.AnnotationResult retrieveAnnotation(PSVIProvider psvi, String uri, String localName, boolean checkHierarchy) {
        ElementPSVI elementPSVI = psvi.getElementPSVI();
        XSTypeDefinition typeDefinition = elementPSVI == null ? null : elementPSVI.getTypeDefinition();
        return SMLValidatorUtil.retrieveAnnotation(typeDefinition, uri, localName, checkHierarchy);
    }

    public static AbstractDataBuilder.AnnotationResult retrieveAnnotation(XSTypeDefinition typeDefinition, String uri, String[] localNames, boolean checkHierarchy) {
        XSObjectList xsObjectList = SMLValidatorUtil.retrieveAnnotations(typeDefinition);
        if (xsObjectList == null) {
            return null;
        }
        AbstractDataBuilder.AnnotationResult annotationResult = null;
        Document document = SMLValidatorUtil.createDocument();
        int i = 0;
        int objectListCount = xsObjectList.getLength();
        while (i < objectListCount) {
            XSAnnotation annotation = (XSAnnotation)xsObjectList.item(i);
            annotation.writeAnnotation((Object)document, (short)3);
            Node[] nodes = SMLValidatorUtil.findNodes(document.getFirstChild(), uri, localNames);
            if (nodes != null && nodes.length > 0) {
                annotationResult = new AbstractDataBuilder.AnnotationResult();
                annotationResult.setType(typeDefinition);
                int j = 0;
                while (j < nodes.length) {
                    annotationResult.addNode(nodes[j]);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return annotationResult;
    }

    public static AbstractDataBuilder.AnnotationResult retrieveAnnotation(XSTypeDefinition typeDefinition, String uri, String localName, boolean checkHierarchy) {
        XSObjectList xsObjectList = SMLValidatorUtil.retrieveAnnotations(typeDefinition);
        if (xsObjectList == null) {
            return null;
        }
        int objectListCount = xsObjectList.getLength();
        if (objectListCount <= 0) {
            return checkHierarchy ? SMLValidatorUtil.retrieveAnnotation(typeDefinition.getBaseType(), uri, localName, checkHierarchy) : null;
        }
        Document document = SMLValidatorUtil.createDocument();
        AbstractDataBuilder.AnnotationResult annotationResult = null;
        int i = 0;
        while (i < objectListCount) {
            annotationResult = SMLValidatorUtil.handleAnnotation(document, typeDefinition, (XSAnnotation)xsObjectList.item(i), uri, localName);
            AbstractDataBuilder.AnnotationResult annotationResult2 = annotationResult = annotationResult == null && checkHierarchy ? SMLValidatorUtil.retrieveAnnotation(typeDefinition.getBaseType(), uri, localName, checkHierarchy) : annotationResult;
            if (annotationResult != null) {
                return annotationResult;
            }
            ++i;
        }
        return null;
    }

    private static XSObjectList retrieveAnnotations(XSTypeDefinition typeDefinition) {
        if (typeDefinition == null || SMLValidatorUtil.isAnyType(typeDefinition) || typeDefinition.getTypeCategory() != 15) {
            return null;
        }
        return ((XSComplexTypeDefinition)typeDefinition).getAnnotations();
    }

    public static AbstractDataBuilder.AnnotationResult retrieveAnnotation(XSElementDeclaration elementDeclaration, String uri, String localName) {
        if (elementDeclaration == null) {
            return null;
        }
        XSAnnotation annotation = elementDeclaration.getAnnotation();
        Document domDocument = SMLValidatorUtil.createDocument();
        return SMLValidatorUtil.handleAnnotation(domDocument, elementDeclaration.getTypeDefinition(), annotation, uri, localName);
    }

    public static Node[] retrieveAnnotation(XSElementDeclaration elementDeclaration, String uri, String[] localNames) {
        XSAnnotation annotation = null;
        if (elementDeclaration == null || (annotation = elementDeclaration.getAnnotation()) == null) {
            return new Node[0];
        }
        Document document = SMLValidatorUtil.createDocument();
        annotation.writeAnnotation((Object)document, (short)3);
        return SMLValidatorUtil.findNodes(document.getFirstChild(), uri, localNames);
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Node[] findNodes(Node node, String uri, String[] localNames) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        SMLValidatorUtil.findNodes(nodes, node, uri, localNames);
        return nodes.toArray(new Node[nodes.size()]);
    }

    public static Node[] findNodes(Node node, String uri, String localNames) {
        return SMLValidatorUtil.findNodes(node, uri, new String[]{localNames});
    }

    private static void findNodes(List<Node> nodes, Node node, String uri, String[] localIds) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        if (uri.equals(node.getNamespaceURI())) {
            int i = 0;
            while (i < localIds.length) {
                if (localIds[i].equals(node.getLocalName())) {
                    nodes.add(node);
                    return;
                }
                ++i;
            }
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            SMLValidatorUtil.findNodes(nodes, children.item(i), uri, localIds);
            ++i;
        }
    }

    private static AbstractDataBuilder.AnnotationResult handleAnnotation(Document document, XSTypeDefinition type, XSAnnotation annotation, String uri, String localName) {
        return SMLValidatorUtil.handleAnnotation(document, type, annotation, uri, new String[]{localName});
    }

    private static AbstractDataBuilder.AnnotationResult handleAnnotation(Document document, XSTypeDefinition type, XSAnnotation annotation, String uri, String[] localNames) {
        NamedNodeMap attributes;
        if (annotation == null) {
            return null;
        }
        annotation.writeAnnotation((Object)document, (short)3);
        Node firstChild = document.getFirstChild();
        NamedNodeMap namedNodeMap = attributes = firstChild == null ? null : firstChild.getAttributes();
        if (attributes == null) {
            return null;
        }
        int i = 0;
        while (i < localNames.length) {
            Node attribute = attributes.getNamedItemNS(uri, localNames[i]);
            if (attribute != null) {
                AbstractDataBuilder.AnnotationResult annotationResult = new AbstractDataBuilder.AnnotationResult();
                annotationResult.addNode(attribute);
                annotationResult.setType(type);
                return annotationResult;
            }
            ++i;
        }
        return null;
    }

    public static String[] tokenizeName(String qName) {
        String[] tokenizedQName = qName.split(":");
        if (tokenizedQName.length <= 1) {
            String[] stringArray = new String[2];
            stringArray[1] = tokenizedQName[0];
            return stringArray;
        }
        return new String[]{tokenizedQName[0], tokenizedQName[1]};
    }

    public static String createQualifiedName(String namespace, String name) {
        return "\"" + namespace + "\":" + name;
    }

    public static String createQualifiedName(XSElementDeclaration elementDeclaration) {
        return SMLValidatorUtil.createQualifiedName(elementDeclaration.getNamespace(), elementDeclaration.getName());
    }

    public static Node findDocumentNode(String[] aliases, int orphanInx) {
        DOMStructure domDocuments = (DOMStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        if (aliases == null || aliases.length <= 0) {
            return orphanInx >= 0 ? domDocuments.getOrphan(orphanInx) : null;
        }
        int i = 0;
        while (i < aliases.length) {
            Node documentNode = domDocuments.get(aliases[i]);
            if (documentNode != null) {
                return documentNode;
            }
            ++i;
        }
        return null;
    }

    public static NamespaceContext buildNamespaceContext(Node startingNode, int[] indices) {
        MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
        SMLValidatorUtil.addNamespaceEntries(namespaceContext, startingNode);
        Node currentNode = startingNode;
        NodeList nodeList = null;
        int i = 1;
        while (i < indices.length) {
            nodeList = currentNode.getChildNodes();
            if ((currentNode = SMLValidatorUtil.findNode(nodeList, indices[i])) == null) break;
            SMLValidatorUtil.addNamespaceEntries(namespaceContext, currentNode);
            ++i;
        }
        return namespaceContext;
    }

    public static NamespaceContext buildNamespaceContext(Node node) {
        MappedNamespaceContext namespaceContext = new MappedNamespaceContext();
        SMLValidatorUtil.buildNamespaceContext(namespaceContext, node);
        return namespaceContext;
    }

    private static void buildNamespaceContext(MappedNamespaceContext namespaceContext, Node node) {
        if (node.getNodeType() != 1) {
            return;
        }
        SMLValidatorUtil.addNamespaceEntries(namespaceContext, node);
        SMLValidatorUtil.buildNamespaceContext(namespaceContext, node.getParentNode());
    }

    private static Node findNode(NodeList nodeList, int index) {
        int counter = 0;
        int i = 0;
        int nodeCount = nodeList.getLength();
        while (i < nodeCount) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() == 1) {
                if (counter == index) {
                    return currentNode;
                }
                ++counter;
            }
            ++i;
        }
        return null;
    }

    private static void addNamespaceEntries(MappedNamespaceContext namespaceContext, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        int attCount = attributes.getLength();
        while (i < attCount) {
            Node attribute = attributes.item(i);
            if ("xmlns".equals(attribute.getPrefix())) {
                namespaceContext.addEntry(attribute.getLocalName(), attribute.getNodeValue());
            } else if (attribute.getPrefix() == null && "xmlns".equals(attribute.getLocalName())) {
                namespaceContext.addEntry("", attribute.getNodeValue());
            }
            ++i;
        }
    }

    public static Node locateDocumentNode(String[] aliases, int documentPosition) {
        DOMStructure domStructure = (DOMStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        Node contextNode = null;
        if (aliases == null || aliases.length == 0) {
            contextNode = domStructure.getOrphan(documentPosition);
        } else {
            int j = 0;
            while (j < aliases.length && contextNode == null) {
                String alias = aliases[j];
                contextNode = domStructure.get(alias);
                ++j;
            }
        }
        return contextNode;
    }

    public static Node findNode(Node node, int[] indices) {
        Node currentNode = node;
        int i = 1;
        while (i < indices.length) {
            NodeList children = currentNode.getChildNodes();
            int counter = 0;
            boolean found = false;
            int j = 0;
            int childCount = children.getLength();
            while (j < childCount) {
                Node child = children.item(j);
                if (child.getNodeType() == 1) {
                    if (counter == indices[i]) {
                        found = true;
                        currentNode = child;
                        break;
                    }
                    ++counter;
                }
                ++j;
            }
            if (!found) {
                return null;
            }
            ++i;
        }
        return currentNode;
    }

    public static class RemoteRetrievalException
    extends Exception {
        private static final long serialVersionUID = 7633895444717500045L;

        public RemoteRetrievalException(String message) {
            super(message);
        }

        public RemoteRetrievalException(Exception cause) {
            super(cause);
        }
    }
}

