/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XMLLineStyler
implements LineStyleListener {
    private XMLScanner xmlScanner = new XMLScanner();
    private Color[] colorContainer;
    private int[] colorIndexContainer;
    protected static final int EOL = -1;
    protected static final int ELEMENT = 0;
    protected static final int ATTRIBUTE = 1;
    protected static final int COMMENT = 2;
    protected static final int OTHER = 3;
    protected static final int NUM_OF_TOKENS = 4;

    public XMLLineStyler() {
        Display display = Display.getDefault();
        this.colorContainer = new Color[]{new Color((Device)display, new RGB(0, 0, 0)), new Color((Device)display, new RGB(0, 0, 128)), new Color((Device)display, new RGB(0, 128, 0)), new Color((Device)display, new RGB(128, 0, 0))};
        this.colorIndexContainer = new int[4];
        this.colorIndexContainer[0] = 1;
        this.colorIndexContainer[1] = 2;
        this.colorIndexContainer[2] = 3;
        this.colorIndexContainer[3] = 0;
    }

    public void lineGetStyle(LineStyleEvent event) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        this.xmlScanner.setEventInput(event);
        int token = this.xmlScanner.nextToken();
        while (token != -1) {
            Color tokenColor = this.colorContainer[this.colorIndexContainer[token]];
            StyleRange style = new StyleRange(this.xmlScanner.getStartOffsetOfToken() + event.lineOffset, this.xmlScanner.getTokenLength(), tokenColor, null);
            if (styles.isEmpty()) {
                styles.add(style);
            } else {
                StyleRange lastStyle = (StyleRange)styles.get(styles.size() - 1);
                if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                    lastStyle.length += style.length;
                } else {
                    styles.add(style);
                }
            }
            int startOffset = 0;
            int endOffset = 0;
            do {
                token = this.xmlScanner.nextToken();
                startOffset = this.xmlScanner.getStartOffsetOfToken();
                endOffset = startOffset + this.xmlScanner.getTokenLength();
            } while (token != -1 && startOffset >= 0 && endOffset < event.lineText.length() && event.lineText.substring(startOffset, endOffset).trim().length() <= 0);
        }
        event.styles = new StyleRange[styles.size()];
        styles.toArray(event.styles);
    }

    protected void dispose() {
        int i = 0;
        while (i < this.colorContainer.length) {
            this.colorContainer[i].dispose();
            ++i;
        }
    }

    public class XMLScanner {
        private int lineStartOffset;
        private int lineLength;
        private String lineText;
        private int tokenStartOffset;
        private int tokenLength;
        private int lastToken;
        private List<CommentBlock> commentBlocks = new ArrayList<CommentBlock>();

        public void setEventInput(LineStyleEvent event) {
            this.lineStartOffset = event.lineOffset;
            this.lineLength = event.lineText.length();
            this.lineText = event.lineText;
            this.tokenStartOffset = 0;
            this.tokenLength = 0;
        }

        public int getTokenLength() {
            return this.tokenLength;
        }

        public int getStartOffsetOfToken() {
            return this.tokenStartOffset;
        }

        /*
         * Unable to fully structure code
         */
        public int nextToken() {
            this.tokenStartOffset += this.tokenLength;
            this.tokenLength = 0;
            currentChar = this.readChar();
            block4: while (currentChar != -1) {
                if (this.fallsUnderCommentBlock(this.lineStartOffset + this.tokenStartOffset)) {
                    while (currentChar != -1 && currentChar != 62) {
                        currentChar = this.readChar();
                    }
                    if (this.tokenLength - 3 >= 0 && this.lineText.substring(this.tokenStartOffset + this.tokenLength - 3, this.tokenStartOffset + this.tokenLength).equals("-->")) {
                        this.insertEndCommentBlock(this.lineStartOffset + this.tokenStartOffset + this.tokenLength - 3);
                    }
                    return this.returnToken(2);
                }
                switch (currentChar) {
                    case 60: {
                        currentChar = this.readChar();
                        if (currentChar != 33) {
                            currentChar = this.readChar();
                            while (currentChar != -1 && currentChar != 62 && currentChar != 61) {
                                currentChar = this.readChar();
                            }
                            return this.returnToken(0);
                        }
                        if (this.lineText.substring(this.tokenStartOffset).trim().length() < 4 || !this.lineText.substring(this.tokenStartOffset).trim().substring(0, 4).equals("<!--")) continue block4;
                        startOfCommentBlock = this.lineStartOffset + this.tokenStartOffset + this.tokenLength - 2;
                        this.skipChar(2);
                        currentChar = this.readChar();
                        while (currentChar != -1 && currentChar != 62) {
                            currentChar = this.readChar();
                        }
                        if (this.tokenStartOffset + this.tokenLength - 2 <= this.tokenStartOffset + 3 || !this.lineText.substring(this.tokenStartOffset + this.tokenLength - 3, this.tokenStartOffset + this.tokenLength).equals("-->")) {
                            this.insertStartCommentBlock(startOfCommentBlock);
                        }
                        return this.returnToken(2);
                    }
                    case 34: {
                        if (this.lastToken == 0) {
                            currentChar = this.readChar();
                            while (currentChar != -1 && currentChar != 34) {
                                currentChar = this.readChar();
                            }
                            return this.returnToken(1);
                        }
                        this.skipUntilEnd();
                        return this.returnToken(0);
                    }
                    default: {
                        if (this.lastToken == 1) {
                            while (currentChar != -1 && currentChar != 61 && currentChar != 62) {
                                currentChar = this.readChar();
                            }
                            return this.returnToken(0);
                        }
                        if (currentChar != 47 || this.lastToken != 1 && this.lastToken != 0) ** GOTO lbl51
                        if (this.readChar() == 62) {
                            return this.returnToken(0);
                        }
                        return this.returnToken(3);
lbl-1000:
                        // 1 sources

                        {
                            currentChar = this.readChar();
lbl51:
                            // 2 sources

                            ** while (currentChar != -1 && currentChar != 60)
                        }
lbl52:
                        // 1 sources

                        if (currentChar == 60) {
                            this.unreadChar();
                        }
                        return this.returnToken(3);
                    }
                }
            }
            return -1;
        }

        private void unreadChar() {
            --this.tokenLength;
        }

        private int returnToken(int token) {
            this.lastToken = token;
            return token;
        }

        private void skipUntilEnd() {
            this.tokenLength = this.lineLength;
        }

        private int readChar() {
            char character;
            if (this.tokenStartOffset + this.tokenLength >= this.lineLength) {
                return -1;
            }
            if (this.isWhiteSpace(character = this.lineText.charAt(this.tokenStartOffset + this.tokenLength++))) {
                return this.readChar();
            }
            return character;
        }

        private void skipChar(int numOfChar) {
            int i = 0;
            while (i < numOfChar) {
                this.readChar();
                ++i;
            }
        }

        private boolean isWhiteSpace(int characterInt) {
            char character = (char)characterInt;
            return character == ' ' || character == '\t' || character == '\f';
        }

        private void insertStartCommentBlock(int start) {
            int i = 0;
            int commentBlockCount = this.commentBlocks.size();
            while (i < commentBlockCount) {
                CommentBlock commentBlock = this.commentBlocks.get(i);
                if (commentBlock.start == start) {
                    return;
                }
                ++i;
            }
            CommentBlock commentBlock = new CommentBlock();
            commentBlock.start = start;
            this.commentBlocks.add(commentBlock);
        }

        private void insertEndCommentBlock(int end) {
            CommentBlock lastEligibleCommentBlock = null;
            int i = 0;
            int commentBlockCount = this.commentBlocks.size();
            while (i < commentBlockCount) {
                CommentBlock commentBlock = this.commentBlocks.get(i);
                if (end > commentBlock.start && commentBlock.end == -1 && (lastEligibleCommentBlock == null || lastEligibleCommentBlock.start > commentBlock.start)) {
                    lastEligibleCommentBlock = commentBlock;
                }
                ++i;
            }
            if (lastEligibleCommentBlock != null) {
                lastEligibleCommentBlock.end = end;
            }
        }

        private boolean fallsUnderCommentBlock(int offset) {
            int i = 0;
            int commentBlockCount = this.commentBlocks.size();
            while (i < commentBlockCount) {
                CommentBlock commentBlock = this.commentBlocks.get(i);
                if (offset > commentBlock.start && (commentBlock.end == -1 || offset < commentBlock.end)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private class CommentBlock {
            protected int start = -1;
            protected int end = -1;
        }
    }
}

